/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.novell.gw.ab.Addressable;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.notification.NotifySubscribeEntry;
import com.novell.gw.notification.NotifySubscribeList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class NotifyTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{StringResources.NAME, StringResources.ADDRESS};
    private NotifySubscribeList lstNotifySubscribe;
    private String userGuid;

    public NotifyTableModel(String userGuid) {
        this.userGuid = userGuid;
        this.lstNotifySubscribe = GWCommandManager.getInstance(this.userGuid).getNotifySubscribeList();
    }

    public int getRowCount() {
        return this.lstNotifySubscribe.size();
    }

    public String getColumnName(int column) {
        return this.columns[column];
    }

    public int indexOf(IAddressable addr) {
        int index = -1;
        int nSize = this.lstNotifySubscribe.size();
        for (int i = 0; i < nSize && index < 0; ++i) {
            if (!addr.getDisplayName().equals(this.lstNotifySubscribe.get(i).getDisplayName())) continue;
            index = i;
        }
        return index;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.lstNotifySubscribe.get(rowIndex).getDisplayName();
            }
            case 1: {
                return this.lstNotifySubscribe.get(rowIndex).getEmailAddress();
            }
        }
        return "";
    }

    public void saveChanges() {
        this.lstNotifySubscribe.commit();
    }

    public boolean removeContact(int index) {
        boolean bRet = this.lstNotifySubscribe.remove(index);
        if (bRet) {
            this.fireTableRowsDeleted(index, index);
        }
        return bRet;
    }

    public void addContacts(List selectedContacts) {
        int addedUsersCount = 0;
        int nSize = selectedContacts.size();
        for (int i = 0; i < nSize; ++i) {
            if (selectedContacts.get(i) instanceof IContact) {
                IContact contact = (IContact)selectedContacts.get(i);
                if (GWCommandManager.getInstance(this.userGuid).getCurrentUserInfo().getID().equals(contact.getUserName())) {
                    JOptionPane.showMessageDialog(null, StringResources.YOU_CANNOT_SHARE, StringResources.ADDRESS_BOOK_ERROR, 2);
                    continue;
                }
                int paSizeBefore = this.lstNotifySubscribe.size();
                int result = this.lstNotifySubscribe.add((Addressable)contact.getNativeContact());
                int paSizeAfter = this.lstNotifySubscribe.size();
                if (result != -1) {
                    if (paSizeAfter > paSizeBefore) {
                        ++addedUsersCount;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, contact.getDisplayName(), contact.getDisplayName()), StringResources.NOVELL_GROUPWISE, 2);
                }
            } else {
                throw new IllegalArgumentException();
            }
            if (addedUsersCount <= 0) continue;
            int index = this.lstNotifySubscribe.size() - 1;
            this.fireTableRowsInserted(this.lstNotifySubscribe.size() - addedUsersCount, index);
        }
    }

    public NotifySubscribeEntry getNotifySubscribeEntry(int index) {
        return this.lstNotifySubscribe.get(index);
    }
}

