/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.components.ComponentBorder;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.send.GWExpandButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractItemOptionsPanel
extends AbstractOptionPanel {
    protected GWExpandButton btnWhenDeleted;
    protected GWExpandButton btnWhenOpened;
    protected GWExpandButton btnWhenDeclined;
    protected GWExpandButton btnWhenAccepted;
    protected GWExpandButton btnWhenCompleted;
    protected JCheckBox cbCreateSentItemToTrack;
    protected JCheckBox cbAutoDeleteSentItem;
    protected JCheckBox cbEnableDeliveryConfirmation;
    protected JCheckBox cbSendNotifications;
    protected JRadioButton rbDelivered;
    protected JRadioButton rbDeliveredAndOpened;
    protected JRadioButton rbAllInformation;
    protected ArrayList<JRadioButton> buttonList;
    protected ComposeItemSendOptions itemSendOptions;
    protected boolean isOnFrameCompose;

    public AbstractItemOptionsPanel(OptionChangesListener theChangesListener, MVCController theParentController) {
        super(theChangesListener, theParentController);
        this.isOnFrameCompose = theParentController instanceof ItemEditPanelController;
        this.init();
    }

    private void init() {
        this.cbCreateSentItemToTrack = new JMnemonicCheckBox(StringResources.CREATE_SENT_ITEM_TO_TRACK);
        this.cbCreateSentItemToTrack.addItemListener(this.itemListener);
        this.cbCreateSentItemToTrack.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractItemOptionsPanel.this.createSentItemToTrack(((JToggleButton)e.getSource()).isSelected());
            }
        });
        this.rbDelivered = new JMnemonicRadioButton(StringResources.DELIVERED);
        this.rbDelivered.addItemListener(this.itemListener);
        this.rbDeliveredAndOpened = new JMnemonicRadioButton(StringResources.DELIVERED_AND_OPENED);
        this.rbDeliveredAndOpened.addItemListener(this.itemListener);
        this.rbAllInformation = new JMnemonicRadioButton(StringResources.ALL_INFORMATION);
        this.rbAllInformation.addItemListener(this.itemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbDelivered);
        buttonGroup.add(this.rbDeliveredAndOpened);
        buttonGroup.add(this.rbAllInformation);
        this.buttonList = new ArrayList();
        this.buttonList.add(this.rbDelivered);
        this.buttonList.add(this.rbDeliveredAndOpened);
        this.buttonList.add(this.rbAllInformation);
        this.cbAutoDeleteSentItem = new JMnemonicCheckBox(StringResources.AUTO_DELETE_SENT_ITEM);
        this.cbAutoDeleteSentItem.addItemListener(this.itemListener);
        this.cbAutoDeleteSentItem.setEnabled(false);
        this.cbEnableDeliveryConfirmation = new JMnemonicCheckBox(StringResources.ENABLE_DELIVERY_CONFIRMATION);
        this.cbEnableDeliveryConfirmation.addItemListener(this.itemListener);
        this.cbEnableDeliveryConfirmation.setEnabled(false);
        this.cbEnableDeliveryConfirmation.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AbstractItemOptionsPanel.this.cbSendNotifications.setEnabled(AbstractItemOptionsPanel.this.cbEnableDeliveryConfirmation.isSelected());
            }
        });
        this.cbSendNotifications = new JMnemonicCheckBox(StringResources.SEND_NOTIFICATION_TO_MY_MAILBOX);
        this.cbSendNotifications.addItemListener(this.itemListener);
    }

    protected void createSentItemToTrack(boolean enabled) {
        this.rbAllInformation.setEnabled(enabled);
        this.rbDelivered.setEnabled(enabled);
        this.rbDeliveredAndOpened.setEnabled(enabled);
        if (this.isOnFrameCompose) {
            this.cbAutoDeleteSentItem.setEnabled(enabled);
        }
    }

    private void setValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbAutoDeleteSentItem.setSelected((Boolean)dataStoreSettings.getSendOptionMailAutoDelete().getValue());
        this.cbCreateSentItemToTrack.setSelected((Boolean)dataStoreSettings.getSendOptionCreateSentItem().getValue());
        int value = (Integer)dataStoreSettings.getSendOptionInternetStatusTracking().getValue();
        this.cbSendNotifications.setEnabled(false);
        if (value == 3) {
            this.cbEnableDeliveryConfirmation.setSelected(true);
            this.cbSendNotifications.setSelected(true);
        } else if (value == 1) {
            this.cbEnableDeliveryConfirmation.setSelected(true);
            this.cbSendNotifications.setSelected(false);
            this.cbSendNotifications.setEnabled(true);
        } else if (value == 0) {
            this.cbEnableDeliveryConfirmation.setSelected(false);
            this.cbSendNotifications.setSelected(false);
            this.cbSendNotifications.setEnabled(false);
        }
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)this.createCreateSentItemPanel(), constraints);
        ++constraints.gridy;
        this.add((Component)this.createReturnNotificationPanel(), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        this.add((Component)this.createInternetMailPanel(), constraints);
    }

    protected JPanel createInternetMailPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(StringResources.INTERNET_MAIL));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 10, 0, 10);
        panel.add((Component)this.cbEnableDeliveryConfirmation, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 30, 10, 10);
        panel.add((Component)this.cbSendNotifications, constraints);
        return panel;
    }

    protected JPanel createCreateSentItemPanel() {
        OrientablePanel panel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setBorder(new ComponentBorder(this.cbCreateSentItemToTrack));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 21;
        panel.add((Component)this.cbCreateSentItemToTrack, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 10, 0, 10);
        panel.add((Component)this.rbDelivered, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        panel.add((Component)this.rbDeliveredAndOpened, constraints);
        ++constraints.gridy;
        constraints.insets.bottom = 10;
        panel.add((Component)this.rbAllInformation, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        panel.add((Component)this.cbAutoDeleteSentItem, constraints);
        return panel;
    }

    abstract JPanel createReturnNotificationPanel();

    public void collectValues() {
    }

    protected void build() {
    }

    public void fireOptionsChanged() {
        this.cbEnableDeliveryConfirmation.setSelected(true);
        this.cbCreateSentItemToTrack.setSelected(true);
        if (this.isOnFrameCompose) {
            this.cbEnableDeliveryConfirmation.setEnabled(true);
            this.cbCreateSentItemToTrack.setEnabled(true);
        }
        this.setValues();
    }

    public void setOptions(ComposeItemSendOptions theAbstractOptions) {
    }

    public void collectValues(ComposeItemSendOptions composeItemSendOptions, IMessage message) {
        if (this.btnWhenAccepted != null) {
            composeItemSendOptions.setRNWhenAccept((Notification)this.btnWhenAccepted.getSelectedItem());
        }
        if (this.btnWhenCompleted != null) {
            composeItemSendOptions.setRNWhenCompleted((Notification)this.btnWhenCompleted.getSelectedItem());
        }
        if (this.btnWhenDeclined != null) {
            composeItemSendOptions.setRNWhenDeclined((Notification)this.btnWhenDeclined.getSelectedItem());
        }
        if (this.btnWhenDeleted != null) {
            composeItemSendOptions.setRNWhenDeleted((Notification)this.btnWhenDeleted.getSelectedItem());
        }
        if (this.btnWhenOpened != null) {
            composeItemSendOptions.setRNWhenOpened((Notification)this.btnWhenOpened.getSelectedItem());
        }
        message.setSendOptionCreateSentItem(this.cbCreateSentItemToTrack.isSelected());
        message.setSendOptionStatusTracking(this.getSendOptionStatusTrackingValue());
        message.setSendOptionMailAutoDelete(this.cbAutoDeleteSentItem.isSelected());
        int value = this.cbEnableDeliveryConfirmation.isSelected() ? (this.cbSendNotifications.isSelected() ? 3 : 1) : 0;
        message.setSendOptionInternetStatusTracking(value);
    }

    public void setEnabledCreateItemToTrack(boolean b) {
        this.cbCreateSentItemToTrack.setSelected(b);
    }

    public void setEnabledDeliveryConfirmation(boolean b) {
        this.cbEnableDeliveryConfirmation.setSelected(b);
        this.cbSendNotifications.setEnabled(false);
    }

    protected int getSendOptionStatusTrackingValue() {
        int i = 1;
        for (JRadioButton rb : this.buttonList) {
            if (rb.isSelected()) break;
            ++i;
        }
        return i;
    }
}

