/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;

public class GWExpandButton
extends OrientableButton {
    private static Logger logger = Logger.getLogger(GWExpandButton.class);
    private Object[] itemList;
    private JPopupMenu popupMenu;
    private Object selectedItem;
    private ItemListener itemListener;

    public GWExpandButton(Object[] itemList, ItemListener itemListener) {
        this(itemList, 0, itemListener);
    }

    public GWExpandButton(Object[] itemList) {
        this(itemList, 0, null);
    }

    public GWExpandButton(Object[] itemList, int selectedItemIndex, ItemListener itemListener) {
        this.itemList = itemList;
        this.selectedItem = itemList[selectedItemIndex];
        this.itemListener = itemListener;
        this.init();
        this.buildUI();
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object o) {
        this.setText(o.toString());
        this.selectedItem = o;
        for (MenuElement element : this.popupMenu.getSubElements()) {
            JMenuItem menuItem = (JMenuItem)element;
            if (menuItem.getText().equals(this.selectedItem.toString())) {
                menuItem.setSelected(true);
                continue;
            }
            menuItem.setSelected(false);
        }
    }

    private void buildUI() {
        this.setSelectedItem(this.selectedItem);
        this.setHorizontalTextPosition(2);
        this.setIcon(ImageResources.OPTONS_LIST_BUTTON);
    }

    private void init() {
        this.popupMenu = new GWPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GWExpandButton.this.popupMenu.show(GWExpandButton.this, 0, GWExpandButton.this.getHeight());
            }
        });
        for (Object o : this.itemList) {
            JMenuItem cbItem = MenuItemFactory.createCkeckBoxMenuItem(o.toString());
            buttonGroup.add(cbItem);
            cbItem.addItemListener(this.itemListener);
            cbItem.addActionListener(new CheckButtonActionListener(o));
            this.popupMenu.add(cbItem);
        }
    }

    private class CheckButtonActionListener
    implements ActionListener {
        private Object item;

        public CheckButtonActionListener(Object item) {
            this.item = item;
        }

        public void actionPerformed(ActionEvent e) {
            GWExpandButton.this.setSelectedItem(this.item);
        }
    }
}

