/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.LimitingTableScrollPane;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.frames.options.compose.send.CategoriesCheckBoxChooser;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SelectCategoryControl
extends GWTextField {
    private static final int PREFERRED_WIDTH = 200;
    private boolean isUnderMouse = false;
    private OrientableButton btnPopup = new OrientableButton(ImageResources.ICON_CATEGORIES);
    private JPopupMenu pMenu = new GWPopupMenu();
    private CategoriesCheckBoxChooser viewCategoriesTable;

    public SelectCategoryControl(ICategoryList categories, boolean isMultiple, String userGuid) {
        this.setDragEnabled(false);
        this.setPreferredSize(new Dimension(200, this.getPreferredSize().height));
        this.btnPopup.setMargin(new Insets(1, 3, 1, 3));
        this.btnPopup.addMouseListener(new MouseListenerBtnPopup());
        this.btnPopup.setBorderPainted(false);
        this.btnPopup.setFocusable(false);
        this.btnPopup.setBorder(BorderFactory.createBevelBorder(0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.btnPopup, "After");
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (!e.isActionKey()) {
                    SelectCategoryControl.this.showPopup();
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setKeymap(null);
        this.setInputMap(0, null);
        this.viewCategoriesTable = new CategoriesCheckBoxChooser(categories, this, isMultiple, userGuid);
        this.pMenu.add(new LimitingTableScrollPane(this.viewCategoriesTable, this.getPreferredSize().width));
        this.updateText();
    }

    public SelectCategoryControl(ICategoryList categories, String userGuid) {
        this(categories, true, userGuid);
    }

    private void showPopup() {
        this.pMenu.show(this, 0, this.getHeight());
        this.pMenu.pack();
        this.viewCategoriesTable.setRowSelectionInterval(0, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectCategoryControl.this.viewCategoriesTable.requestFocus();
            }
        });
    }

    private void mouseEnter(MouseEvent e) {
        if (this.btnPopup.isEnabled()) {
            this.btnPopup.setBorderPainted(true);
            this.isUnderMouse = true;
        }
    }

    private void mouseExit(MouseEvent e) {
        if (this.btnPopup.isEnabled()) {
            this.btnPopup.setBorderPainted(false);
            this.isUnderMouse = false;
        }
    }

    private void mousePress(MouseEvent e) {
        if (this.btnPopup.isEnabled()) {
            this.btnPopup.setBorder(BorderFactory.createBevelBorder(1));
            this.btnPopup.setBorderPainted(true);
            this.showPopup();
        }
    }

    private void mouseRelease(MouseEvent e) {
        if (this.btnPopup.isEnabled()) {
            this.btnPopup.setBorderPainted(true);
            if (!this.isUnderMouse) {
                this.btnPopup.setBorderPainted(false);
            }
            this.btnPopup.setBorder(BorderFactory.createBevelBorder(0));
        }
    }

    public void setCategories(ICategoryList categories) {
        this.viewCategoriesTable.setCategories(categories);
        this.updateText();
    }

    public ICategoryList getCategories() {
        return this.viewCategoriesTable.getCategories();
    }

    public void updateText() {
        this.viewCategoriesTable.updateText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnPopup.setEnabled(enabled);
    }

    private class MouseListenerBtnPopup
    implements MouseListener {
        private MouseListenerBtnPopup() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            SelectCategoryControl.this.mousePress(e);
        }

        public void mouseReleased(MouseEvent e) {
            SelectCategoryControl.this.mouseRelease(e);
        }

        public void mouseEntered(MouseEvent e) {
            SelectCategoryControl.this.mouseEnter(e);
        }

        public void mouseExited(MouseEvent e) {
            SelectCategoryControl.this.mouseExit(e);
        }
    }
}

