/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.pageselector;

import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.options.pageselector.OptionsPageSelectorController;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class OptionsPageSelector
extends GWToolBar
implements MVCView {
    private static HashMap icons = new HashMap();
    private MVCController controller;
    private HashMap mapNames;
    private HashMap mapButtons;
    private String selectedButtonID;

    public OptionsPageSelector(HashMap buttonsID, MVCController theParentController) {
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        this.mapNames = buttonsID;
        this.controller = new OptionsPageSelectorController(this, theParentController);
        this.build();
    }

    private void build() {
        this.createButtons();
        this.setLayout(new BorderLayout());
        OrientablePanel pnlMain = new OrientablePanel(new GridBagLayout());
        this.add((Component)pnlMain, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.fill = 2;
        c.insets = new Insets(0, 7, 7, 7);
        Object[] ids = this.mapNames.keySet().toArray();
        int nSize = this.mapNames.size();
        for (int i = 0; i < nSize; ++i) {
            AbstractButton button = (AbstractButton)this.mapButtons.get(ids[i]);
            ++c.gridy;
            if (i == this.mapNames.size() - 1) {
                c.weighty = 1.0;
            }
            pnlMain.add((Component)button, c);
        }
    }

    private void setBorder() {
        MatteBorder border = UIUtils.getComponentOrientation().isLeftToRight() ? BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray) : BorderFactory.createMatteBorder(0, 1, 0, 0, Color.gray);
        this.setBorder(border);
    }

    public void setSelectedOption(String theID) {
        if (this.selectedButtonID != null && this.selectedButtonID.equals(theID)) {
            return;
        }
        ((AbstractButton)this.mapButtons.get(theID)).setSelected(true);
        this.selectedButtonID = theID;
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof String) {
            // empty if block
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void createButtons() {
        Color buttonForeground = (Color)UIManager.getDefaults().get("Button.foreground");
        if (buttonForeground == null) {
            buttonForeground = Color.BLACK;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mapButtons = new HashMap();
        for (Object id : this.mapNames.keySet().toArray()) {
            ToolBarToggleButton button = new ToolBarToggleButton(new ActionShowOptionPane(this.mapNames.get(id).toString(), (Icon)icons.get(id), id.toString()));
            button.clearPropertyBindings();
            button.setForeground(buttonForeground);
            button.setHorizontalAlignment(10);
            buttonGroup.add(button);
            this.mapButtons.put(id, button);
        }
    }

    static {
        icons.put("General", ImageResources.OPTIONS_GENERAL);
        icons.put("Send", ImageResources.ICON_ACT_SEND);
        icons.put("Security", ImageResources.OPTIONS_SECURITY);
        icons.put("Printing", ImageResources.ACT_PRINT);
        icons.put("Date and Time", ImageResources.OPTIONS_DATE_TIME);
    }

    private class ActionShowOptionPane
    extends AbstractAction {
        private String optionID;

        public ActionShowOptionPane(String name, Icon icon, String optionID) {
            super(name, icon);
            this.optionID = optionID;
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.optionID.equals(OptionsPageSelector.this.selectedButtonID)) {
                OptionsPageSelector.this.getController().processCommand(new Command(120, this.optionID));
                OptionsPageSelector.this.selectedButtonID = this.optionID;
            }
        }
    }
}

