/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.search;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filter.FilterFeedbackDialog;
import com.novell.gw.jclient.application.controls.filter.IFilterOwner;
import com.novell.gw.jclient.application.controls.filter.QuickFilterPanel;
import com.novell.gw.jclient.application.controls.header.HeaderLabel;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListComponent;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewPanel;
import com.novell.gw.jclient.application.controls.itemview.QuickViewer;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerShowUpInfoProvider;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FrameSearchMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.toolbars.FrameSearchToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.WindowFocusOwnerChangeListener;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.options.QuickViewerOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameItemSearch
extends ApplicationFrame<FrameItemSearchActionList, Object>
implements QuickViewerShowUpInfoProvider,
IFilterOwner {
    private static Logger logger = Logger.getLogger(FrameItemSearch.class);
    private SearchResultsView searchResultsView;
    private SkinnablePanel tableHeaderPanel;
    private HeaderLabel lblHeader;
    private QueryFolder queryFolder;
    private Filter filter;
    private QuickFilterPanel pnlQuickFind;
    private QuickViewer pnlQuickView;
    private JPanel pnlResultPanel;

    public FrameItemSearch(String userGuid, Filter theFilter) {
        super(StringResources.GROUPWISE_FIND_RESULTS, "Frame Item Search", userGuid);
        this.setController(new FrameItemSearchActionList(this, (MVCController)GWClient.getApplication()));
        this.searchResultsView = new SearchResultsView(this.getController());
        this.pnlResultPanel = this.buildResultPane();
        this.filter = theFilter;
        this.queryFolder = GWCommandManager.getInstance(this.getUserGuid()).find(this.filter.getItemListFilter());
        this.searchResultsView.setData(this.queryFolder, this.queryFolder.getDisplaySettings().asViewDisplaySettings(), null);
        this.searchResultsView.refresh();
        this.buildUI(true);
        Command command = new Command(10, this.queryFolder);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        command = new Command(1090, this.queryFolder);
        command.setAttribute("FORCE_REFRESH", true);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        this.lblHeader.setFolder(this.queryFolder);
    }

    public FrameItemSearch(String userGuid, QueryFolder theQueryFolder) {
        super(StringResources.GROUPWISE_FIND_RESULTS, "Frame Item Search", userGuid);
        this.setController(new FrameItemSearchActionList(this, (MVCController)GWClient.getApplication()));
        this.searchResultsView = new SearchResultsView(this.getController());
        this.pnlResultPanel = this.buildResultPane();
        this.queryFolder = theQueryFolder;
        Command command = new Command(10, this.queryFolder);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        this.searchResultsView.setData(this.queryFolder, this.queryFolder.getDisplaySettings().asViewDisplaySettings(), null);
        this.searchResultsView.refresh();
        this.buildUI(false);
        command = new Command(1090, this.queryFolder);
        command.setAttribute("FORCE_REFRESH", true);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        this.lblHeader.setFolder(this.queryFolder);
    }

    @Override
    public Filter getFilter() {
        return this.pnlQuickFind.getFilter();
    }

    public Filter getFilterForModify() {
        return this.filter;
    }

    private void buildUI(boolean isToolBarPanel) {
        this.centeredContentPanel.setLayout(new BorderLayout());
        this.getContentPane().setPreferredSize(new Dimension(540, 480));
        this.setGWMenuBar(new FrameSearchMenuBar((ApplicationFrameActionList)this.getController()));
        if (isToolBarPanel) {
            GWToolBarPanel toolBarPanel = new GWToolBarPanel();
            toolBarPanel.add((Component)new FrameSearchToolBar((ApplicationFrameActionList)this.getController()), "Center");
            this.setToolBarPanel(toolBarPanel, "North");
        }
        this.setIconImage(ImageResources.ACT_FIND.getImage());
        this.updateQuickViewer(OptionManager.getInstance().getQuickViewerOptions());
        this.getStatusBar().setItemsInfoPanelVisible(true);
        this.refreshQueryStatus(false);
    }

    public void setFilter(Filter filter) {
        if (this.lblHeader != null && this.queryFolder != null) {
            this.lblHeader.setFiltered(filter != null && !filter.isEmpty());
        }
    }

    private void buildTableHeader() {
        this.tableHeaderPanel = new SkinnablePanel(new GridBagLayout());
        ControlsUtils.prepareHeaderPanel(this.tableHeaderPanel);
        this.lblHeader = new HeaderLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        this.tableHeaderPanel.add((Component)this.lblHeader, c);
        c.weightx = 1.0;
        this.tableHeaderPanel.add(Box.createHorizontalGlue(), c);
        c.weightx = 0.0;
        this.pnlQuickFind = new QuickFilterPanel(this.appActionList);
        this.tableHeaderPanel.add((Component)this.pnlQuickFind, c);
        this.tableHeaderPanel.add(Box.createHorizontalStrut(10), c);
        HeaderPopupMenu headerPopupMenu = new HeaderPopupMenu((ActionList)this.getController());
        this.tableHeaderPanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(headerPopupMenu));
    }

    private JPanel buildResultPane() {
        OrientablePanel pnlResult = new OrientablePanel(new BorderLayout());
        this.buildTableHeader();
        pnlResult.add((Component)this.tableHeaderPanel, "North");
        pnlResult.add((Component)this.searchResultsView.getComponent(), "Center");
        pnlResult.setMinimumSize(new Dimension(100, 100));
        return pnlResult;
    }

    public QueryFolder getQueryFolder() {
        return this.queryFolder;
    }

    public void startSearch(Filter theFilter) {
        this.filter = theFilter;
        this.queryFolder = GWCommandManager.getInstance(this.getUserGuid()).find(this.filter.getItemListFilter());
        this.searchResultsView.setSearchingStarted(true);
        this.searchResultsView.setData(this.queryFolder, this.queryFolder.getDisplaySettings().asViewDisplaySettings(), null);
        if (this.getFilter() != null) {
            ((FrameItemSearchActionList)this.getController()).processCommand(new Command(400, null));
        }
        this.searchResultsView.refresh();
        Command command = new Command(10, this.queryFolder);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        command = new Command(1090, this.queryFolder);
        command.setAttribute("FORCE_REFRESH", true);
        ((FrameItemSearchActionList)this.getController()).processCommand(command);
        this.lblHeader.setFolder(this.queryFolder);
    }

    public QuickViewer getQuickViewer() {
        if (this.pnlQuickView == null) {
            this.pnlQuickView = new QuickViewer(this.getController(), this);
            WindowFocusOwnerChangeListener propertyChangeListener = new WindowFocusOwnerChangeListener(this);
            ControlsUtils.getListenerManager(this.getController()).addListener(KeyboardFocusManager.getCurrentKeyboardFocusManager(), propertyChangeListener, ListenerType.PROPERTY_CHANGE_LISTENER);
        }
        this.pnlQuickView.setSize(400, 300);
        return this.pnlQuickView;
    }

    void refreshQueryStatus(boolean isSearching) {
        this.setCursor(isSearching ? Cursor.getPredefinedCursor(3) : null);
        if (isSearching) {
            this.setStatusText(StringResources.SEARCHING_D);
        } else {
            this.setStatusText("");
        }
    }

    @Override
    public void release() {
        this.removeAll();
        if (this.pnlQuickView != null) {
            this.pnlQuickView.release();
            this.pnlQuickView = null;
        }
        super.release();
        this.tableHeaderPanel = null;
        this.pnlQuickFind = null;
    }

    public void updateQuickViewer(QuickViewerOptions options) {
        logger.debug((Object)("options: " + options));
        this.centeredContentPanel.removeAll();
        if (!options.isQuickViewerEnabled()) {
            this.getQuickViewer().setHidden(true);
            this.centeredContentPanel.add((Component)this.pnlResultPanel, "Center");
        } else {
            this.getQuickViewer().setHidden(false);
            JSplitPane splitPane = new JSplitPane();
            splitPane.setOneTouchExpandable(false);
            splitPane.setResizeWeight(0.5);
            this.pnlResultPanel.setSize(400, 300);
            if (options.isRightPosition()) {
                splitPane.setOrientation(1);
                splitPane.setLeftComponent(this.pnlResultPanel);
                splitPane.setRightComponent(this.getQuickViewer());
            } else {
                splitPane.setOrientation(0);
                splitPane.setTopComponent(this.pnlResultPanel);
                splitPane.setBottomComponent(this.getQuickViewer());
            }
            this.centeredContentPanel.add((Component)splitPane, "Center");
        }
        this.centeredContentPanel.updateUI();
    }

    @Override
    public ISelectedItemsInfo getSelectedItemsInfo() {
        ItemListComponent itemListComponent = this.searchResultsView.getItemListComponent();
        if (itemListComponent == null) {
            return null;
        }
        return MessageUtils.createSelectedItemsInfo(itemListComponent.getSelectedItems(), this.searchResultsView.getItemList(), this.getUserGuid());
    }

    public void refreshTable() {
        IViewDisplaySettings viewDisplaySettings = this.searchResultsView.getFolder().getDisplaySettings().asViewDisplaySettings();
        this.searchResultsView.setViewDisplaySettings(viewDisplaySettings);
        this.searchResultsView.refresh();
    }

    public String getSelectedTextFromItemViewer() {
        if (((FrameItemSearchActionList)this.getController()).isQuickViewerVisible() && this.pnlQuickView != null) {
            return this.pnlQuickView.getSelectedText();
        }
        return null;
    }

    private class SearchResultsView
    extends ItemListViewPanel {
        boolean isSearchingStarted;

        public SearchResultsView(MVCController controller) {
            super(controller);
            this.isSearchingStarted = true;
        }

        protected void processNothingFound(ItemListEvent e) {
            if (this.isSearchingStarted) {
                this.isSearchingStarted = false;
                FilterFeedbackDialog dialog = new FilterFeedbackDialog(FrameItemSearch.this, null);
                dialog.setLocationRelativeTo(FrameItemSearch.this);
                ((Dialog)dialog).setVisible(true);
            } else {
                super.processNothingFound(e);
            }
        }

        protected void processRefreshFolderQueryFinished() {
            super.processRefreshFolderQueryFinished();
            this.isSearchingStarted = false;
        }

        public void setSearchingStarted(boolean isSearchingStarted) {
            this.isSearchingStarted = isSearchingStarted;
        }
    }
}

