/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.notify.NotifyActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeSystemTrayFrame
extends JFrame
implements MVCView<NotifyActionList, Object> {
    private static Logger logger = Logger.getLogger(FakeSystemTrayFrame.class);
    NotifyActionList actionList;

    public FakeSystemTrayFrame(MVCController theParentController) {
        this.setIconImage(ImageResources.GW_ICON.getImage());
        this.actionList = new NotifyActionList(this, theParentController);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                logger.debug((Object)"exiting Notify");
                GWClient.exitNotify();
            }
        });
        this.buildUI();
    }

    private void buildUI() {
        JButton btnReadMail = new JButton(this.actionList.getAction(ActionKey.READ_MAIL));
        JButton btnNotificationList = new JButton(this.actionList.getAction(ActionKey.DISPLAY_NOTIFICATION_LIST));
        JButton btnHelp = new JButton(this.actionList.getAction(ActionKey.DISPLAY_NOTIFY_HELP));
        JButton btnOptions = null;
        JButton btnAbout = null;
        JButton btnExit = null;
        if (!OS.isMacOS()) {
            btnOptions = new JButton(this.actionList.getAction(ActionKey.DISPLAY_NOTIFY_OPTIONS));
            btnAbout = new JButton(this.actionList.getAction(ActionKey.ABOUT_NOTIFY));
            btnExit = new JButton(this.actionList.getAction(ActionKey.EXIT_NOTIFY));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)btnReadMail, c);
        ++c.gridy;
        panel.add((Component)btnNotificationList, c);
        if (btnOptions != null) {
            ++c.gridy;
            panel.add((Component)btnOptions, c);
        }
        if (btnAbout != null) {
            ++c.gridy;
            panel.add((Component)btnAbout, c);
        }
        ++c.gridy;
        panel.add((Component)btnHelp, c);
        if (btnExit != null) {
            ++c.gridy;
            panel.add((Component)btnExit, c);
        }
        this.getContentPane().add((Component)panel, "Center");
        this.setTitle(StringResources.NOTIFY);
    }

    @Override
    public NotifyActionList getController() {
        return this.actionList;
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    @Override
    public void setController(NotifyActionList theController) {
    }

    @Override
    public void setMVCModel(Object theModel) {
    }
}

