/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.actions;

import com.appframework.ActionList;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.notify.actions.AbstractNotificationItemAction;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import java.awt.event.ActionEvent;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionDeleteNotification
extends AbstractNotificationItemAction {
    public ActionDeleteNotification(ActionList actionList) {
        super(actionList, ActionKey.DELETE_NOTIFICATION, StringResources.DELETE, false);
        this.setEnabled(false);
    }

    @Override
    protected void performAction(ActionEvent e) {
        if (this.selectedItemList.isEmpty()) {
            throw new IllegalStateException("No item is selected");
        }
        for (NotificationItem item : this.selectedItemList) {
            if (!item.canDeleteItem()) continue;
            GWNotify.getInstance().deleteNotificationItem(item);
        }
        GlobalCommand commandSize = new GlobalCommand(1570);
        this.getActionList().processCommand(commandSize);
    }

    @Override
    protected void handle_NOTIFICATIONS_SELECTED(List<NotificationItem> selectedItems) {
        this.selectedItemList.clear();
        boolean nonDeletableItemSelected = false;
        boolean canDelete = false;
        for (NotificationItem item : selectedItems) {
            if (item.isReturnStatus() || item.isAlarm()) {
                nonDeletableItemSelected = true;
                break;
            }
            this.selectedItemList.add(item);
            if (!item.canDeleteItem()) continue;
            canDelete = true;
        }
        if (nonDeletableItemSelected) {
            this.selectedItemList.clear();
            canDelete = false;
        }
        this.setEnabled(canDelete);
    }
}

