/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.dialogs.options;

public class SettingsPanelModel {
    public static final String SOUND_BEEP = "<BEEP>";
    private boolean showDialog;
    private boolean playSound;
    private boolean launchProgram;
    private String soundFilePath;
    private String programFilePath;
    private boolean modified = false;

    public SettingsPanelModel(boolean showDialog, boolean playSound, boolean launchProgram, String soundFilePath, String programFilePath) {
        this.showDialog = showDialog;
        this.playSound = playSound;
        this.launchProgram = launchProgram;
        this.programFilePath = programFilePath;
        this.soundFilePath = soundFilePath == null || soundFilePath.equals("") ? SOUND_BEEP : soundFilePath;
    }

    public boolean isLaunchProgram() {
        return this.launchProgram;
    }

    public void setLaunchProgram(boolean launchProgram) {
        if (this.launchProgram != launchProgram) {
            if (!this.modified) {
                this.modified = true;
            }
            this.launchProgram = launchProgram;
        }
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean playSound) {
        if (this.playSound != playSound) {
            if (!this.modified) {
                this.modified = true;
            }
            this.playSound = playSound;
        }
    }

    public String getProgramFilePath() {
        return this.programFilePath;
    }

    public void setProgramFilePath(String programFilePath) {
        if (!SettingsPanelModel.areStringsEqual(this.programFilePath, programFilePath)) {
            if (!this.modified) {
                this.modified = true;
            }
            this.programFilePath = programFilePath;
        }
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        if (this.showDialog != showDialog) {
            if (!this.modified) {
                this.modified = true;
            }
            this.showDialog = showDialog;
        }
    }

    public String getSoundFilePath() {
        return this.soundFilePath;
    }

    public void setSoundFilePath(String soundFilePath) {
        if (!SettingsPanelModel.areStringsEqual(this.soundFilePath, soundFilePath)) {
            if (!this.modified) {
                this.modified = true;
            }
            this.soundFilePath = soundFilePath == null || soundFilePath.equals("") ? SOUND_BEEP : soundFilePath;
        }
    }

    private static boolean areStringsEqual(String first, String second) {
        boolean result = first == null ? second == null : first.equals(second);
        return result;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void reset() {
        this.modified = false;
    }

    public String toString() {
        return this.getClass().getName() + "[showDialog: " + this.showDialog + ", playSound: " + this.playSound + ", launchProgram: " + this.launchProgram + ", soundFilePath: " + this.soundFilePath + ", programFilePath: " + this.programFilePath + ']';
    }
}

