/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.frames;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.notify.frames.NotificationListFrameActionList;
import com.novell.gw.jclient.application.notify.frames.NotificationTable;
import com.novell.gw.jclient.application.notify.frames.NotificationTableModel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationListFrame
extends ApplicationFrame<NotificationListFrameActionList, Object> {
    private static Logger logger = Logger.getLogger(NotificationListFrame.class);
    private static int INSET = 5;
    private static boolean displayed = false;
    private static WeakReference<NotificationListFrame> lastInstance = null;
    private JPanel buttonPanel = new OrientablePanel();
    private NotificationTable table;

    public NotificationListFrame(MVCController parentController) {
        this(EngineCommandManager.getUserGuid(), parentController);
    }

    public NotificationListFrame(String userGuid, MVCController parentController) {
        super(StringResources.GROUPWISE_NOTIFY, "NOTIFY_FRAME", userGuid);
        lastInstance = new WeakReference<NotificationListFrame>(this);
        if (displayed) {
            throw new RuntimeException("this frame is displayed already");
        }
        displayed = true;
        this.setController(new NotificationListFrameActionList(this, parentController));
        this.buildUI();
    }

    private void buildUI() {
        this.table = new NotificationTable(this.getController());
        NotificationTableModel tableModel = new NotificationTableModel(this.table);
        this.table.setModel(tableModel);
        tableModel.loadItems();
        ColoredScrollPane tableScrollPane = new ColoredScrollPane(this.table);
        OrientableButton btnClose = new OrientableButton(new ActionClose());
        OrientableButton btnRead = new OrientableButton(((NotificationListFrameActionList)this.getController()).getAction(ActionKey.READ_NOTIFICATION));
        OrientableButton btnClear = new OrientableButton(((NotificationListFrameActionList)this.getController()).getAction(ActionKey.CLEAR_NOTIFICATION));
        OrientableButton btnClearAll = new OrientableButton(((NotificationListFrameActionList)this.getController()).getAction(ActionKey.CLEAR_ALL_NOTIFICATIONS));
        OrientableButton btnDelete = new OrientableButton(((NotificationListFrameActionList)this.getController()).getAction(ActionKey.DELETE_NOTIFICATION));
        this.buttonPanel.add(btnClose);
        this.buttonPanel.add(btnRead);
        this.buttonPanel.add(btnClear);
        this.buttonPanel.add(btnClearAll);
        this.buttonPanel.add(btnDelete);
        OrientablePanel mainPanel = new OrientablePanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(INSET, INSET, INSET, INSET);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)tableScrollPane, c);
        c.fill = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        mainPanel.add((Component)this.buttonPanel, c);
        this.setContentPane(mainPanel);
    }

    @Override
    protected Dimension getFrameSize() {
        int h = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_HEIGHT", 200);
        int w = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", this.buttonPanel.getMinimumSize().width + 2 * INSET + 10);
        return new Dimension(w, h);
    }

    @Override
    public void dispose() {
        super.dispose();
        lastInstance = null;
        displayed = false;
    }

    public static boolean isDisplayed() {
        return displayed;
    }

    public static NotificationListFrame getLastInstance() {
        return (NotificationListFrame)lastInstance.get();
    }

    private class ActionClose
    extends AbstractAction {
        public ActionClose() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent e) {
            Application.disposeFrame(NotificationListFrame.this);
        }
    }
}

