/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.notify.frames;

import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.notify.frames.NotificationTable;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(NotificationTableModel.class);
    private List<String> columnNames;
    private List<NotificationItem> items = new ArrayList<NotificationItem>();
    private NotificationTable table;

    public NotificationTableModel(NotificationTable table) {
        this.table = table;
        this.initColumnNames();
    }

    private void initColumnNames() {
        this.columnNames = new ArrayList<String>();
        this.columnNames.add(StringResources.NAME);
        this.columnNames.add(StringResources.SUBJECT);
        this.columnNames.add(StringResources.DATE);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = this.items.get(rowIndex);
                break;
            }
            case 1: {
                result = this.items.get(rowIndex).getSubject();
                break;
            }
            case 2: {
                String format = OptionManager.getInstance().getDateTimeOptions().getMainWindowFormat();
                result = DateAndTimeFormattingUtils.formatDate(this.items.get(rowIndex).getDate(), format);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal column index: " + rowIndex);
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public void loadItems() {
        List<NotificationItem> items = GWNotify.getInstance().getNotificationItems();
        this.items.clear();
        Object[] notificationItems = items.toArray();
        Arrays.sort(notificationItems);
        for (Object o : notificationItems) {
            NotificationItem item = (NotificationItem)o;
            this.items.add(item);
        }
        logger.debug((Object)(this.items.size() + " item(s) loaded"));
        Command commandSize = new Command(1520, this.items.size());
        this.table.getController().processCommand(commandSize);
    }

    public List<NotificationItem> getItemsByIndices(int[] indices) {
        ArrayList<NotificationItem> results = new ArrayList<NotificationItem>();
        for (int index : indices) {
            if (index < this.items.size()) {
                results.add(this.items.get(index));
                continue;
            }
            logger.warn((Object)("Illegal index: " + index + " > skipping"));
        }
        return results;
    }
}

