/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class RMISettings
implements Serializable {
    private static Logger logger = Logger.getLogger(RMISettings.class);
    private static final String PROPS_FILE_NAME = "rmi.options";
    private static final String SETTING_RMI_PORT = "rmi.port";
    private static final int DEFAULT_RMI_PORT = 1099;
    private static RMISettings instance;
    private String optionsFileName = this.optionsFileName + "rmi.options";
    private Hashtable settings = new Hashtable();

    public static RMISettings getInstance() {
        if (instance == null) {
            instance = new RMISettings();
        }
        return instance;
    }

    private RMISettings() {
        this.load(this.optionsFileName);
    }

    private void save() {
        try {
            File f = new File(this.optionsFileName);
            f.createNewFile();
            FileOutputStream fo = new FileOutputStream(f);
            ObjectOutputStream oo = new ObjectOutputStream(fo);
            this.writeObject(oo);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void load(String theFileName) {
        try {
            FileInputStream fi = new FileInputStream(theFileName);
            ObjectInputStream oi = new ObjectInputStream(fi);
            this.readObject(oi);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.settings);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.settings = (Hashtable)s.readObject();
    }

    public void storeRMIPort(int port) {
        this.settings.put(SETTING_RMI_PORT, new Integer(port));
        this.save();
    }

    public int getRMIPort() {
        int res = 1099;
        Integer r = (Integer)this.settings.get(SETTING_RMI_PORT);
        if (r != null) {
            res = r;
        }
        return res;
    }
}

