/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class WeekDayMarks {
    private static final Set<Integer> calendarDays = new HashSet<Integer>(7);
    private Set<Integer> marks = new HashSet<Integer>(7);

    public WeekDayMarks(boolean markForAllDays) {
        if (markForAllDays) {
            this.marks.add(2);
            this.marks.add(3);
            this.marks.add(4);
            this.marks.add(5);
            this.marks.add(6);
            this.marks.add(7);
            this.marks.add(1);
        }
    }

    public static WeekDayMarks createFromGwBitmask(int gwBitmask) {
        WeekDayMarks weekDayMarks = new WeekDayMarks(false);
        weekDayMarks.setMondayMarked((gwBitmask & 2) > 0);
        weekDayMarks.setTuesdayMarked((gwBitmask & 4) > 0);
        weekDayMarks.setWednesdayMarked((gwBitmask & 8) > 0);
        weekDayMarks.setThursdayMarked((gwBitmask & 0x10) > 0);
        weekDayMarks.setFridayMarked((gwBitmask & 0x20) > 0);
        weekDayMarks.setSaturdayMarked((gwBitmask & 0x40) > 0);
        weekDayMarks.setSundayMarked((gwBitmask & 1) > 0);
        return weekDayMarks;
    }

    public boolean isCalendarDayMarked(int day) {
        if (!calendarDays.contains(day)) {
            throw new IllegalArgumentException("illegal day value: " + day);
        }
        return this.marks.contains(day);
    }

    public void setCalendarDayMarked(int day, boolean mark) {
        if (!calendarDays.contains(day)) {
            throw new IllegalArgumentException("illegal day value: " + day);
        }
        if (mark) {
            this.marks.add(day);
        } else {
            this.marks.remove(day);
        }
    }

    public boolean isMondayMarked() {
        return this.marks.contains(2);
    }

    public void setMondayMarked(boolean mark) {
        if (mark) {
            this.marks.add(2);
        } else {
            this.marks.remove(2);
        }
    }

    public boolean isTuesdayMarked() {
        return this.marks.contains(3);
    }

    public void setTuesdayMarked(boolean mark) {
        if (mark) {
            this.marks.add(3);
        } else {
            this.marks.remove(3);
        }
    }

    public boolean isWednesdayMarked() {
        return this.marks.contains(4);
    }

    public void setWednesdayMarked(boolean mark) {
        if (mark) {
            this.marks.add(4);
        } else {
            this.marks.remove(4);
        }
    }

    public boolean isThursdayMarked() {
        return this.marks.contains(5);
    }

    public void setThursdayMarked(boolean mark) {
        if (mark) {
            this.marks.add(5);
        } else {
            this.marks.remove(5);
        }
    }

    public boolean isFridayMarked() {
        return this.marks.contains(6);
    }

    public void setFridayMarked(boolean mark) {
        if (mark) {
            this.marks.add(6);
        } else {
            this.marks.remove(6);
        }
    }

    public boolean isSaturdayMarked() {
        return this.marks.contains(7);
    }

    public void setSaturdayMarked(boolean mark) {
        if (mark) {
            this.marks.add(7);
        } else {
            this.marks.remove(7);
        }
    }

    public boolean isSundayMarked() {
        return this.marks.contains(1);
    }

    public void setSundayMarked(boolean mark) {
        if (mark) {
            this.marks.add(1);
        } else {
            this.marks.remove(1);
        }
    }

    public int getMarkedCount() {
        return this.marks.size();
    }

    public boolean isEveryDayMarked() {
        return this.marks.size() == 7;
    }

    public int countMarkedDays(Calendar startDay, int daysCount) {
        if (daysCount < 1) {
            throw new IllegalArgumentException("daysCount value is illegal: " + daysCount);
        }
        Calendar day = (Calendar)startDay.clone();
        int count = 0;
        for (int i = 1; i <= daysCount; ++i) {
            if (this.isCalendarDayMarked(day.get(7))) {
                ++count;
            }
            day.add(7, 1);
        }
        return count;
    }

    public int countDaysToMarkedDay(Calendar startDay, int markedDayIndex) {
        if (markedDayIndex < 0) {
            throw new IllegalArgumentException("illegal markedDayIndex value: " + markedDayIndex);
        }
        if (this.getMarkedCount() == 0) {
            throw new IllegalStateException("none of the days is marked");
        }
        int days = -1;
        Calendar day = (Calendar)startDay.clone();
        do {
            ++days;
            if (this.isCalendarDayMarked(day.get(7))) {
                --markedDayIndex;
            }
            day.add(7, 1);
        } while (markedDayIndex > -1);
        assert (days > -1) : "Illegal days count: " + days;
        return days;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WeekDayMarks(");
        if (this.isMondayMarked()) {
            builder.append("Monday ");
        }
        if (this.isTuesdayMarked()) {
            builder.append("Tuesday ");
        }
        if (this.isWednesdayMarked()) {
            builder.append("Wednesday ");
        }
        if (this.isThursdayMarked()) {
            builder.append("Thursday ");
        }
        if (this.isFridayMarked()) {
            builder.append("Friday ");
        }
        if (this.isSaturdayMarked()) {
            builder.append("Saturday ");
        }
        if (this.isSundayMarked()) {
            builder.append("Sunday ");
        }
        builder.append(')');
        return builder.toString();
    }

    static {
        calendarDays.add(2);
        calendarDays.add(3);
        calendarDays.add(4);
        calendarDays.add(5);
        calendarDays.add(6);
        calendarDays.add(7);
        calendarDays.add(1);
    }
}

