/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.PrintHTMLTextPane;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.store.GWItemFormatSerializer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class HTMLPrintForm
extends PrintForm {
    private static Logger logger = Logger.getLogger(HTMLPrintForm.class);
    private final Font fontHeader = new Font(PLAFChanger.getFontName(), 0, 8);
    protected static final String BODY_TAG = "<body";
    protected static final String START_HEADER = "<!-- START ITEM HEADER -->";
    protected static final String END_HEADER = "<!-- END ITEM HEADER -->";
    protected ItemChecksPanel itemChecksPanel;
    private JHFrame frame = new JHFrame();
    protected HTMLTextPane editor = new PrintHTMLTextPane();
    private Vector transforms;
    private double imgX;
    private double imgY;
    protected AbstractItem item;
    private String userGuid;

    public HTMLPrintForm(URL url, ItemChecksPanel theItemChecksPanel, String userGuid) {
        this.itemChecksPanel = theItemChecksPanel;
        this.userGuid = userGuid;
        this.editor.setEditable(false);
        this.editor.setMode(1);
        this.editor.setIgnoreDefaultFontAttributes(true);
        this.frame.getContentPane().add(this.editor);
        this.setPage(url);
    }

    public HTMLPrintForm(AbstractItem theItem, ItemChecksPanel theItemChecksPanel, String userGuid) {
        this((URL)null, theItemChecksPanel, userGuid);
        this.item = theItem;
    }

    protected HTMLPrintForm(String theText, ItemChecksPanel theItemChecksPanel, String userGuid) {
        this.itemChecksPanel = theItemChecksPanel;
        this.userGuid = userGuid;
        this.editor.setEditable(false);
        this.editor.setMode(2);
        this.editor.setPlainText(theText);
        this.editor.setIgnoreDefaultFontAttributes(true);
        this.frame.getContentPane().add(this.editor);
    }

    protected void setPage(URL url) {
        if (url == null) {
            return;
        }
        try {
            this.editor.setPage(url);
        }
        catch (IOException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        this.editor.setMode(1);
        this.editor.updateUI();
        this.editor.repaint();
    }

    public Vector createTransforms(JEditorPane editor) {
        double d2;
        int i = 0;
        double d = 0.0;
        Vector<PageTransform> vector = new Vector<PageTransform>();
        View view = editor.getUI().getRootView(editor);
        Rectangle rectangle = HTMLPrintForm.getViewRec(view, this.pageWidth, this.pageHeight);
        double dScale = rectangle.getWidth() > (double)this.pageWidth ? (double)this.pageWidth / rectangle.getWidth() : 1.0;
        Insets insets = editor.getInsets();
        this.frame.setBounds(0, 0, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        this.frame.setVisible(true);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.pageWidth, (double)this.pageHeight / dScale);
        Position.Bias[] abias = new Position.Bias[1];
        do {
            double d6 = rect.getHeight() + d;
            int j = view.viewToModel(0.0f, (float)d6, rectangle, abias);
            Shape shape = null;
            try {
                shape = view.modelToView(j, rectangle, abias[0]);
            }
            catch (BadLocationException e) {
                logger.debug((Object)e);
                break;
            }
            Rectangle2D rectangle2d = shape.getBounds2D();
            double d4 = d;
            d2 = rectangle2d.getY() - 1.0;
            if (d6 >= rectangle2d.getY() + rectangle2d.getHeight()) {
                d2 = rectangle2d.getY() + rectangle2d.getHeight() - 1.0;
            }
            double d7 = rectangle2d.getY();
            double d8 = rectangle2d.getY() + rectangle2d.getHeight() - 1.0;
            double d9 = rectangle2d.getX() + 20.0;
            Rectangle2D rectangle2d1 = rectangle2d;
            while (d9 <= (double)this.pageWidth * dScale) {
                int k = view.viewToModel((float)d9, (float)d6, rectangle, abias);
                Shape shape1 = null;
                try {
                    shape1 = view.modelToView(k, rectangle, abias[0]);
                }
                catch (BadLocationException e) {
                    logger.debug((Object)e);
                    break;
                }
                Rectangle2D rectangle2d2 = shape1.getBounds2D();
                if (rectangle2d1.equals(rectangle2d2) || rectangle2d2.getX() < d9) {
                    d9 += 20.0;
                    continue;
                }
                double d11 = rectangle2d2.getY();
                double d13 = rectangle2d2.getY() + rectangle2d2.getHeight() - 1.0;
                if (d13 > d7) {
                    if (d13 > d8) {
                        if (d13 < d6) {
                            d2 = d13;
                            d8 = d13;
                            if (d11 < d7) {
                                d7 = d11;
                            }
                        } else if (d11 > d8) {
                            d2 = d11 - 1.0;
                            d8 = d13;
                            d7 = d11;
                        } else if (d11 < d7) {
                            d2 = d11 - 1.0;
                            d7 = d11;
                            d8 = d13;
                        } else {
                            d2 = d7 - 1.0;
                            d8 = d13;
                        }
                    } else if (d8 < d6) {
                        d2 = d8;
                        if (d11 < d7) {
                            d7 = d11;
                        }
                    } else if (d7 <= d11) {
                        d2 = d7 - 1.0;
                    } else {
                        d2 = d11 - 1.0;
                        d7 = d11;
                    }
                }
                rectangle2d1 = rectangle2d2;
                d9 = rectangle2d1.getX() + 20.0;
            }
            PageTransform pagetransform = new PageTransform();
            pagetransform.translate(this.imgX, this.imgY);
            pagetransform.translate(-((double)insets.left) * dScale, -((double)insets.top + d4) * dScale);
            pagetransform.scale(dScale, dScale);
            pagetransform.setHeight(d2 + (double)insets.top);
            vector.add(i, pagetransform);
        } while (!((d = d2 + 1.0) >= rectangle.getHeight()) && ++i <= 100);
        return vector;
    }

    public int print(Graphics g, PageFormat pageformat, int pageIndex) {
        Shape old;
        if (pageIndex == 0) {
            this.printHeader();
        }
        Graphics2D graphics2d = (Graphics2D)g;
        if (this.isPreview) {
            this.imgX = pageformat.getImageableX();
            this.imgY = pageformat.getImageableY();
            this.pageWidth = (int)pageformat.getImageableWidth();
            this.pageHeight = (int)pageformat.getImageableHeight();
            this.isPreview = false;
        } else {
            graphics2d.scale(1.0 / SCALE_FACTOR, 1.0 / SCALE_FACTOR);
            this.imgX = SCALE_FACTOR * pageformat.getImageableX();
            this.imgY = SCALE_FACTOR * pageformat.getImageableY();
            this.pageWidth = (int)(SCALE_FACTOR * pageformat.getImageableWidth());
            this.pageHeight = (int)(SCALE_FACTOR * pageformat.getImageableHeight());
        }
        g.setColor(Color.black);
        this.commonHeaderH = this.getHeaderHeight(g);
        this.editor.setDropTarget(null);
        this.frame.setGraphics(graphics2d);
        if (this.transforms == null) {
            this.transforms = this.createTransforms(this.editor);
        }
        if (pageIndex >= this.transforms.size()) {
            return 1;
        }
        if (pageIndex >= 30) {
            return 1;
        }
        if (graphics2d.getClip() == null) {
            Rectangle2D.Double double1 = new Rectangle2D.Double(this.imgX, this.imgY, this.pageWidth, this.pageHeight);
            graphics2d.setClip(double1);
        }
        graphics2d.transform((AffineTransform)this.transforms.get(pageIndex));
        Shape shape = graphics2d.getClip();
        Rectangle2D rectangle2d = shape.getBounds2D();
        double d = ((PageTransform)this.transforms.get(pageIndex)).getHeight();
        double d1 = rectangle2d.getY() + rectangle2d.getHeight() - 1.0 - d;
        if (d1 > 0.0) {
            Rectangle2D.Double double2 = new Rectangle2D.Double(rectangle2d.getX(), rectangle2d.getY(), rectangle2d.getWidth(), rectangle2d.getHeight() - d1);
            graphics2d.clip(double2);
            Shape shape1 = graphics2d.getClip();
            rectangle2d = shape1.getBounds2D();
        }
        if (rectangle2d.getY() < d) {
            old = graphics2d.getClip();
            rectangle2d = old.getBounds2D();
            rectangle2d.setRect(rectangle2d.getX(), rectangle2d.getY() - (double)this.commonHeaderH, rectangle2d.getWidth(), this.commonHeaderH);
            graphics2d.setClip(rectangle2d);
            if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
                this.printCommonHeader(graphics2d, pageIndex, this.pageWidth, (int)rectangle2d.getX(), (int)rectangle2d.getY() + 10);
            }
        } else {
            return 1;
        }
        graphics2d.setClip(old);
        this.editor.paint(graphics2d);
        return 0;
    }

    protected String getItemHeaders() {
        GWItemFormatSerializer serializer = new GWItemFormatSerializer(this.item);
        String itemHeader = serializer.getItemHeader(this.item, this.itemChecksPanel.isDateSelected());
        String additionalItemHeader = serializer.getAdditionalItemHeader(this.item, this.itemChecksPanel.isFromSelected(), this.itemChecksPanel.isToSelected(), this.itemChecksPanel.isDateSelected(), this.itemChecksPanel.isSubjectSelected());
        return itemHeader + additionalItemHeader;
    }

    protected void printHeader() {
        String header = (START_HEADER + this.getItemHeaders() + END_HEADER).replaceAll("\n", "<br>");
        StringBuilder sb = new StringBuilder(this.editor.getText());
        int start = sb.indexOf(START_HEADER);
        if (start >= 0) {
            int end = sb.indexOf(END_HEADER);
            if (end > start) {
                sb.replace(start, end + END_HEADER.length(), header);
            }
        } else {
            int body = sb.indexOf(BODY_TAG);
            if (body >= 0) {
                sb.insert(sb.indexOf(">", body) + 1, header);
            }
        }
        this.editor.setStyledText(sb.toString());
    }

    protected int printCommonHeader(Graphics pg, int pageIndex, int wPage, int x, int y) {
        int h = 0;
        pg.setFont(this.fontHeader);
        FontMetrics fm = pg.getFontMetrics();
        h += fm.getAscent();
        int width = wPage;
        String userNameSubject = GWCommandManager.getInstance(this.userGuid).getUserFields().getUserName();
        if (this.item != null) {
            userNameSubject = userNameSubject + " - " + this.item.getSubject();
        }
        String date = OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(GWCalendarUtils.getToday().getTime());
        int dateWidth = SwingUtilities.computeStringWidth(fm, date);
        String pageNumber = "";
        int pageNumberWidth = 0;
        boolean printPageNumber = this.itemChecksPanel.isPageNumberSelected();
        if (printPageNumber) {
            pageNumber = StringResources.PAGE + ' ' + (pageIndex + 1);
            pageNumberWidth = SwingUtilities.computeStringWidth(fm, pageNumber);
        }
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            int dateStart = width - dateWidth + x;
            int userNameWidth = width - dateWidth - 10 + x;
            if (printPageNumber) {
                pg.drawString(pageNumber, width - pageNumberWidth + x, h + y);
                dateStart = dateStart - pageNumberWidth - 10;
                userNameWidth = userNameWidth - pageNumberWidth - 10;
            }
            pg.drawString(date, dateStart, h + y);
            pg.drawString(UIUtils.cutStringToWidth(userNameSubject, fm, userNameWidth), x, h + y);
        } else {
            int datePos = x;
            int userNameMaxWdth = width - x - dateWidth - 10;
            if (printPageNumber) {
                pg.drawString(pageNumber, x, h + y);
                datePos = datePos + pageNumberWidth + 10;
                userNameMaxWdth = userNameMaxWdth - pageNumberWidth - 10;
            }
            pg.drawString(date, datePos, h + y);
            String cut = UIUtils.cutStringToWidth(userNameSubject, fm, userNameMaxWdth);
            int cutPos = width - SwingUtilities.computeStringWidth(fm, cut);
            pg.drawString(cut, cutPos, h + y);
        }
        pg.drawLine(x, h + y + 5, x + wPage, h + y + 5);
        return h;
    }

    protected int getHeaderHeight(Graphics pg) {
        int h = 0;
        pg.setFont(this.fontHeader);
        FontMetrics fm = pg.getFontMetrics();
        return h += fm.getAscent() + fm.getHeight() + 10;
    }

    public void onPrintBegin() {
        super.onPrintBegin();
        this.transforms = null;
    }

    public static Rectangle getViewRec(View view, float f, float f1) {
        Rectangle rectangle = new Rectangle();
        view.setSize(f, f1);
        rectangle.width = (int)Math.max((long)Math.ceil(view.getMinimumSpan(0)), (long)f);
        rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        view.setSize(rectangle.width, rectangle.height);
        if (view.getView(0) instanceof BoxView) {
            BoxView boxview = (BoxView)view.getView(0);
            rectangle.width = boxview.getWidth();
            rectangle.height = boxview.getHeight();
        } else {
            rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        }
        return rectangle;
    }

    public String toString() {
        return StringResources.HTML_PRINT_FORM;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_MAIL_HTML;
    }

    static class JHFrame
    extends JFrame {
        private Graphics graphics;

        JHFrame() {
        }

        public void addNotify() {
            this.getRootPane().addNotify();
        }

        public void validate() {
            this.validateTree();
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public void setGraphics(Graphics g) {
            this.graphics = g;
        }
    }

    static class PageTransform
    extends AffineTransform {
        private double height;

        PageTransform() {
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }
    }
}

