/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Logger;

public class PagePreview
extends JPanel {
    private static Logger logger = Logger.getLogger(PagePreview.class);
    private int w;
    private int h;
    private Rectangle rMargin;
    private Image source;
    private Image img;

    public PagePreview(int theWidth, int theHeight, Rectangle theMargin, Image theSource) {
        this.w = theWidth;
        this.h = theHeight;
        this.rMargin = theMargin;
        this.source = theSource;
        this.img = this.source.getScaledInstance(this.w, this.h, 4);
        this.setBackground(Color.white);
        this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
    }

    public void setScaledSize(int theWidth, int theHeight, Rectangle theMargin) {
        this.w = theWidth;
        this.h = theHeight;
        this.rMargin = theMargin;
        this.img.flush();
        this.img = this.source.getScaledInstance(this.w, this.h, 4);
        this.repaint();
    }

    public void flushImages() {
        this.img.flush();
        this.source.flush();
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(this.w + ins.left + ins.right, this.h + ins.top + ins.bottom);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.img, 0, 0, this);
        this.paintBorder(g);
        g.setColor(new Color(128, 128, 255));
        g.drawRect(this.rMargin.x, this.rMargin.y, this.rMargin.width, this.rMargin.height);
    }
}

