/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PreviewContainer
extends JPanel {
    private static Logger logger = Logger.getLogger(PreviewContainer.class);
    private int H_GAP = 16;
    private int V_GAP = 10;

    public Dimension getPreferredSize() {
        int n = this.getComponentCount();
        if (n == 0) {
            return new Dimension(this.H_GAP, this.V_GAP);
        }
        Component comp = this.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;
        Dimension dp = this.getParent().getSize();
        int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
        int nRow = n / nCol;
        if (nRow * nCol < n) {
            ++nRow;
        }
        int ww = nCol * (w + this.H_GAP) + this.H_GAP;
        int hh = nRow * (h + this.V_GAP) + this.V_GAP;
        Insets ins = this.getInsets();
        return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        int nCol;
        int nRow;
        Insets ins = this.getInsets();
        int x = ins.left + this.H_GAP;
        int y = ins.top + this.V_GAP;
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        Component comp = this.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;
        Dimension dp = new Dimension(0, 0);
        if (this.getParent() != null) {
            dp = this.getParent().getSize();
        }
        if ((nRow = n / (nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1))) * nCol < n) {
            ++nRow;
        }
        int index = 0;
        for (int k = 0; k < nRow; ++k) {
            for (int m = 0; m < nCol; ++m) {
                if (index >= n) {
                    return;
                }
                comp = this.getComponent(index++);
                comp.setBounds(x, y, w, h);
                x += w + this.H_GAP;
            }
            y += h + this.V_GAP;
            x = ins.left + this.H_GAP;
        }
    }
}

