/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import com.appframework.ActionList;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.preview.PagePreview;
import com.novell.gw.jclient.application.printing.preview.PreviewContainer;
import com.novell.gw.jclient.application.printing.preview.PrintPreviewDialogActionList;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintPreviewDialog
extends ApplicationDialog<PrintPreviewDialogActionList> {
    private static Logger logger = Logger.getLogger(PrintPreviewDialog.class);
    private static final int MAX_PAGES = 10;
    private static final String[] SCALES = new String[]{"10 %", "25 %", "50 %", "100 %"};
    private static String defaultScale = SCALES[3];
    private JPanel toolBar;
    private PageFormat pageFormat;
    private int wPage;
    private int hPage;
    private int w;
    private int h;
    private int firstPage = 0;
    private Rectangle rMargin;
    private JComboBox cbScale;
    private PreviewContainer previewContainer;
    private JButton btnPrevious;
    private JButton btnNext;
    private JButton btnPrint;
    private boolean isRefreshFirstTime = true;
    private PrintInformation printInformation;

    public PrintPreviewDialog(JDialog theParent, MVCController theParentController, PrintInformation thePrintInformation) {
        super((Dialog)theParent, theParentController);
        this.printInformation = thePrintInformation;
        this.setTitle(StringResources.PRINT_PREVIEW);
        this.setModal(true);
        this.pageFormat = PrintUtils.getScreenPageFormatFromPrintAttributes(this.printInformation.getPrintAttributes());
        this.rMargin = new Rectangle();
        this.buildUI();
        this.cbScale.addActionListener(new CbScaleAction());
        this.setSize((int)this.pageFormat.getWidth(), 600);
        this.refreshUI();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected PrintPreviewDialogActionList createController(MVCController parentController) {
        return new PrintPreviewDialogActionList(this, parentController);
    }

    private void buildUI() {
        this.toolBar = new GWToolBarPanel();
        this.toolBar.setLayout(new FlowLayout(3));
        ActionList thisActionList = (ActionList)this.getController();
        thisActionList.getAction(ActionKey.PRINT_FORM).setMVCModel(this.printInformation);
        this.btnPrint = new JButton(thisActionList.getAction(ActionKey.PRINT_FORM));
        this.cbScale = new OrientableComboBox(SCALES);
        this.cbScale.setMaximumSize(this.cbScale.getPreferredSize());
        this.cbScale.setEditable(false);
        this.cbScale.setSelectedItem(this.getDefaultScale());
        this.toolBar.add(this.btnPrint);
        this.getBtnCancel().setText(StringResources.CLOSE);
        this.toolBar.add(this.getBtnCancel());
        this.toolBar.add(this.cbScale);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.previewContainer = new PreviewContainer();
        if (this.pageFormat.getHeight() == 0.0 || this.pageFormat.getWidth() == 0.0) {
            logger.debug((Object)"Unable to determine default page size");
            return;
        }
        this.wPage = (int)this.pageFormat.getWidth();
        this.hPage = (int)this.pageFormat.getHeight();
        int scale = 100;
        this.w = this.wPage * scale / 100;
        this.h = this.hPage * scale / 100;
        this.rMargin.x = (int)(this.pageFormat.getImageableX() * (double)scale / 100.0);
        this.rMargin.y = (int)(this.pageFormat.getImageableY() * (double)scale / 100.0);
        this.rMargin.width = (int)(this.pageFormat.getImageableWidth() * (double)scale / 100.0);
        this.rMargin.height = (int)(this.pageFormat.getImageableHeight() * (double)scale / 100.0);
        OrientableScrollPane ps = new OrientableScrollPane(this.previewContainer);
        ps.getVerticalScrollBar().setUnitIncrement(10);
        this.getContentPane().add((Component)ps, "Center");
        this.btnPrevious = new JButton(StringResources.PREVIOUS);
        this.btnPrevious.addActionListener(new BtnPreviousAction());
        this.btnNext = new JButton(StringResources.NEXT);
        this.btnNext.addActionListener(new BtnNextAction());
        this.getRootPane().setDefaultButton(this.btnPrint);
    }

    private void refreshUI() {
        int pageIndex = 0;
        PrintForm printForm = this.printInformation.getPrintForm();
        printForm.onPrintBegin();
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.wPage, this.hPage, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.wPage, this.hPage);
                printForm.setPreview(true);
                if (printForm.print(g, this.pageFormat, pageIndex) == 0) {
                    if (pageIndex >= this.firstPage && pageIndex < this.firstPage + 10) {
                        PagePreview pp = new PagePreview(this.w, this.h, this.rMargin, img);
                        this.previewContainer.add(pp);
                    }
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        if (!this.cbScale.getSelectedItem().toString().equals("100 %")) {
            this.scalePage();
        }
        this.previewContainer.updateUI();
        if (this.isRefreshFirstTime) {
            this.isRefreshFirstTime = false;
            if (pageIndex > 10) {
                this.addPrevNextButtons();
            }
        }
        this.btnPrevious.setEnabled(this.firstPage > 0);
        this.btnNext.setEnabled(pageIndex > this.firstPage + 10);
    }

    private void releaseResources() {
        for (Component component : this.previewContainer.getComponents()) {
            if (!(component instanceof PagePreview)) continue;
            PagePreview pagePreview = (PagePreview)component;
            pagePreview.flushImages();
        }
        this.previewContainer.removeAll();
    }

    private void scalePage() {
        int scale;
        String str = this.cbScale.getSelectedItem().toString();
        if (str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        try {
            scale = Integer.parseInt(str);
            PrintPreviewDialog.setDefaultScale(this.cbScale.getSelectedItem().toString());
        }
        catch (NumberFormatException ex) {
            return;
        }
        int w = this.wPage * scale / 100;
        int h = this.hPage * scale / 100;
        this.rMargin.x = (int)(this.pageFormat.getImageableX() * (double)scale / 100.0);
        this.rMargin.y = (int)(this.pageFormat.getImageableY() * (double)scale / 100.0);
        this.rMargin.width = (int)(this.pageFormat.getImageableWidth() * (double)scale / 100.0);
        this.rMargin.height = (int)(this.pageFormat.getImageableHeight() * (double)scale / 100.0);
        Component[] comps = this.previewContainer.getComponents();
        for (int k = 0; k < comps.length; ++k) {
            if (!(comps[k] instanceof PagePreview)) continue;
            PagePreview pp = (PagePreview)comps[k];
            pp.setScaledSize(w, h, this.rMargin);
        }
        this.previewContainer.doLayout();
        this.validate();
    }

    private void addPrevNextButtons() {
        this.toolBar.add(this.btnPrevious);
        this.toolBar.add(this.btnNext);
    }

    private static String getDefaultScale() {
        return defaultScale;
    }

    private static void setDefaultScale(String theDefaultScale) {
        defaultScale = theDefaultScale;
    }

    @Override
    protected void processCancelAction(ActionEvent event) {
        super.processCancelAction(event);
        this.releaseResources();
        this.dispose();
    }

    @Override
    protected void processCloseAction(WindowEvent event) {
        super.processCloseAction(event);
        this.releaseResources();
        this.dispose();
    }

    class BtnNextAction
    extends AbstractAction {
        BtnNextAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewDialog.this.firstPage += 10;
            PrintPreviewDialog.this.previewContainer.removeAll();
            PrintPreviewDialog.this.refreshUI();
        }
    }

    class BtnPreviousAction
    extends AbstractAction {
        BtnPreviousAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewDialog.this.firstPage -= 10;
            PrintPreviewDialog.this.previewContainer.removeAll();
            PrintPreviewDialog.this.refreshUI();
        }
    }

    class CbScaleAction
    extends AbstractAction {
        CbScaleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PrintPreviewDialog.this.scalePage();
        }
    }
}

