/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook;

import com.appframework.components.DigitDocument;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.filechoser.OptionChangesListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingaddressbook.ABItem;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookChecksPanelController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class AddressBookChecksPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(AddressBookChecksPanel.class);
    private AddressBookChecksPanelController controller;
    public JCheckBox cbPageNumber;
    private JList lstContents;
    private JTextField tfRowsNumber;
    private JTextField tfColsNumber;
    private Dimension dimTextField = new Dimension(30, 20);
    private CheckListener checkListener;
    private boolean showPageNumber = true;
    private int rowsNumber = OptionManager.getInstance().getPrintingOptions().getRowsNumber();
    private int colsNumber = OptionManager.getInstance().getPrintingOptions().getRowsNumber();
    private OptionChangesListener changesListener;

    public AddressBookChecksPanel(MVCController theParentController) {
        this(true, new OptionChangesListener(), theParentController);
    }

    public AddressBookChecksPanel(boolean showPageNumber, OptionChangesListener theChangesListener, MVCController theParentController) {
        this.controller = new AddressBookChecksPanelController(this, theParentController);
        this.showPageNumber = showPageNumber;
        this.changesListener = theChangesListener;
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.tfRowsNumber = new GWTextField();
        this.tfRowsNumber.setDocument(new DigitDocument());
        this.tfRowsNumber.getDocument().addDocumentListener(new TfRowsNumberListener());
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
        this.tfColsNumber = new GWTextField();
        this.tfColsNumber.setDocument(new DigitDocument());
        this.tfColsNumber.getDocument().addDocumentListener(new TfColsNumberListener());
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
        this.lstContents = new OrientableList();
        this.checkListener = new CheckListener(this.lstContents);
        this.lstContents.addMouseListener(this.checkListener);
        this.lstContents.addKeyListener(this.checkListener);
        CheckListCellRenderer renderer = new CheckListCellRenderer();
        this.lstContents.setCellRenderer(renderer);
        this.lstContents.setSelectionMode(0);
        this.lstContents.setVisibleRowCount(0);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.insets = new Insets(10, 10, 0, 10);
        int y = 0;
        int yy = 0;
        if (this.showPageNumber) {
            this.cbPageNumber = new OrientableCheckBox(StringResources.PRINT_PAGE_NUMBER);
            c.gridwidth = 2;
            c.weightx = 1.0;
            this.cbPageNumber.setSelected(true);
            this.add((Component)this.cbPageNumber, c);
            ++y;
            ++yy;
        }
        JMnemonicLabel printItem = new JMnemonicLabel(StringResources.ADDRESS_BOOK_FIELDS_SELECTION_LIST_C, this.lstContents);
        c.fill = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)printItem, c);
        this.lstContents = new JList();
        this.checkListener = new CheckListener(this.lstContents);
        this.lstContents.addMouseListener(this.checkListener);
        this.lstContents.addKeyListener(this.checkListener);
        renderer = new CheckListCellRenderer();
        this.lstContents.setCellRenderer(renderer);
        this.lstContents.setSelectionMode(0);
        this.lstContents.setVisibleRowCount(0);
        OrientableScrollPane spPI = new OrientableScrollPane(this.lstContents);
        c.gridy = y++;
        c.gridheight = 5;
        c.weighty = 1.0;
        c.insets = new Insets(5, 10, 10, 10);
        c.fill = 1;
        this.add((Component)spPI, c);
        JMnemonicLabel rowsNumb = new JMnemonicLabel(StringResources.NUMBER_OF_ROWS, this.tfRowsNumber);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = yy++;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 0, 10);
        c.fill = 11;
        this.add((Component)rowsNumb, c);
        this.tfRowsNumber = new GWTextField();
        this.tfRowsNumber.setDocument(new DigitDocument());
        this.tfRowsNumber.getDocument().addDocumentListener(new TfRowsNumberListener());
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
        this.tfRowsNumber.setColumns(2);
        c.gridy = yy++;
        c.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.tfRowsNumber, c);
        JMnemonicLabel colsNumb = new JMnemonicLabel(StringResources.NUMBER_OF_COLUMNS, this.tfColsNumber);
        c.gridy = yy++;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)colsNumb, c);
        this.tfColsNumber = new GWTextField();
        this.tfColsNumber.setDocument(new DigitDocument());
        this.tfColsNumber.getDocument().addDocumentListener(new TfColsNumberListener());
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
        this.tfColsNumber.setColumns(2);
        c.gridy = yy++;
        c.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.tfColsNumber, c);
        OptionManager.getInstance().getPrintingOptions();
        this.setSelectionState(PrintingOptions.getAddressBookSelectionState());
        this.setNames();
    }

    private void setNames() {
        this.tfRowsNumber.setName("Rows number");
        this.tfColsNumber.setName("Cols number");
        this.lstContents.setName("address book fields");
    }

    public ArrayList getCheckedItems() {
        ArrayList<ABItem> al = new ArrayList<ABItem>();
        ListModel lm = this.lstContents.getModel();
        int nSize = lm.getSize();
        for (int i = 0; i < nSize; ++i) {
            CheckableItem chi = (CheckableItem)lm.getElementAt(i);
            if (!chi.isSelected()) continue;
            al.add(chi.getItem());
        }
        return al;
    }

    public HashMap getSelectionState() {
        HashMap<String, Boolean> hm = new HashMap<String, Boolean>();
        ListModel lm = this.lstContents.getModel();
        int size = lm.getSize();
        for (int i = 0; i < size; ++i) {
            CheckableItem chi = (CheckableItem)lm.getElementAt(i);
            if (chi.isSelected()) {
                hm.put(chi.toString(), Boolean.TRUE);
                continue;
            }
            hm.put(chi.toString(), Boolean.FALSE);
        }
        return hm;
    }

    public void setSelectionState(Map theMap) {
        Vector<CheckableItem> v = new Vector<CheckableItem>();
        for (ABItem key : theMap.keySet()) {
            Boolean val = (Boolean)theMap.get(key);
            v.add(new CheckableItem(key, val));
        }
        this.lstContents.setListData(v);
        this.setListEnabled(true);
    }

    public int getRowsNumber() {
        return this.rowsNumber;
    }

    public int getColsNumber() {
        return this.colsNumber;
    }

    public void setRowsNumber(int theRowNumber) {
        this.rowsNumber = theRowNumber;
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
    }

    public void setColsNumber(int theColNumber) {
        this.colsNumber = theColNumber;
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
    }

    public void setListEnabled(boolean enabled) {
        ListModel lm = this.lstContents.getModel();
        int size = lm.getSize();
        for (int i = 0; i < size; ++i) {
            CheckableItem chi = (CheckableItem)lm.getElementAt(i);
            chi.setEnabled(enabled);
        }
        this.lstContents.removeMouseListener(this.checkListener);
        this.lstContents.removeKeyListener(this.checkListener);
        if (enabled) {
            this.lstContents.addMouseListener(this.checkListener);
            this.lstContents.addKeyListener(this.checkListener);
        }
        this.lstContents.setEnabled(enabled);
    }

    public void setController(MVCController theController) {
        this.controller = (AddressBookChecksPanelController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof Integer) {
            int x = (Integer)theModel;
            if (x == 1 || x == 3) {
                this.setListEnabled(false);
            } else {
                this.setListEnabled(true);
            }
            if (x == 0) {
                this.tfColsNumber.setEnabled(false);
                this.tfRowsNumber.setEnabled(false);
            } else if (x == 2) {
                this.tfColsNumber.setEnabled(true);
                this.tfRowsNumber.setEnabled(true);
            }
        }
    }

    public Object getMVCModel() {
        return null;
    }

    class TfRowsNumberListener
    implements DocumentListener {
        TfRowsNumberListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.doChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.doChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.doChange();
        }

        private void doChange() {
            if (AddressBookChecksPanel.this.tfRowsNumber.getText().length() == 0) {
                return;
            }
            int x = 0;
            try {
                x = Integer.parseInt(AddressBookChecksPanel.this.tfRowsNumber.getText());
                AddressBookChecksPanel.this.rowsNumber = x;
                AddressBookChecksPanel.this.changesListener.setValueChanged();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, StringResources.PLEASE_INSERT_INTEGER_VALUE);
                logger.debug((Object)nfe);
            }
        }
    }

    class TfColsNumberListener
    implements DocumentListener {
        TfColsNumberListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.doChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.doChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.doChange();
        }

        private void doChange() {
            if (AddressBookChecksPanel.this.tfColsNumber.getText().length() == 0) {
                return;
            }
            int x = 0;
            try {
                x = Integer.parseInt(AddressBookChecksPanel.this.tfColsNumber.getText());
                AddressBookChecksPanel.this.colsNumber = x;
                AddressBookChecksPanel.this.changesListener.setValueChanged();
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, StringResources.PLEASE_INSERT_INTEGER_VALUE);
                logger.debug((Object)nfe);
            }
        }
    }

    class CheckListener
    implements MouseListener,
    KeyListener {
        protected JList list;

        public CheckListener(JList theList) {
            this.list = theList;
        }

        public void mouseClicked(MouseEvent e) {
            this.doCheck();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.doCheck();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        protected void doCheck() {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            CheckableItem data = (CheckableItem)this.list.getModel().getElementAt(index);
            data.invertSelected();
            this.list.repaint();
            AddressBookChecksPanel.this.changesListener.setValueChanged();
        }
    }

    class CheckListCellRenderer
    extends OrientableCheckBox
    implements ListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            CheckableItem item = (CheckableItem)value;
            this.setSelected(item.isSelected());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            this.setEnabled(item.isEnabled());
            if (item.isEnabled()) {
                this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    public static class CheckableItem {
        private ABItem item;
        private boolean isSelected;
        private boolean isEnabled = false;

        public CheckableItem(ABItem theItem, boolean theSelected) {
            this.item = theItem;
            this.isSelected = theSelected;
        }

        public void invertSelected() {
            this.isSelected = !this.isSelected;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public String toString() {
            return this.item.toString();
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public ABItem getItem() {
            return this.item;
        }
    }
}

