/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.printing.basicforms.AddressBookForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressPhone
extends AddressBookForm {
    private static Logger logger = Logger.getLogger(AddressPhone.class);
    private boolean isPrintFirstTime = true;
    private int entryPageIndex = -1;
    private int firstEntryOnPage = 0;
    private int firstEntryOnPageCopy = 0;
    private int lastEntryOnPage = -1;
    private boolean isPrintingEntryFinished = true;
    private boolean isPrintingEntryFinishedCopy = true;
    private int printingY = 0;
    public static int PHONE_ONLY = 0;
    public static int ADDRESS_PHONE = 1;
    private int type = PHONE_ONLY;

    public AddressPhone(List<IAddressable> selectedContacts, MVCController theParentController) {
        this(selectedContacts, PHONE_ONLY, theParentController);
    }

    public AddressPhone(List<IAddressable> selectedContacts, int theType, MVCController theParentController) {
        super(selectedContacts, theParentController);
        this.type = theType;
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(pg, pageFormat, pageIndex);
        boolean bContinue = false;
        if (pageIndex > this.entryPageIndex && this.isPrintingEntryFinished) {
            this.firstEntryOnPage = this.lastEntryOnPage + 1;
            if (this.firstEntryOnPage >= this.entriesCount) {
                this.isPrintFirstTime = true;
                System.gc();
                return 1;
            }
        }
        this.refreshPrint(pageIndex);
        bContinue = this.printEntry(pg);
        if (bContinue && !this.isPrintingEntryFinished) {
            return 0;
        }
        this.isPrintingEntryFinished = true;
        return 0;
    }

    @Override
    public void onPrintBegin() {
        this.entriesCount = this.selectedContacts.size();
        this.entryPageIndex = -1;
        this.firstEntryOnPage = -1;
        this.lastEntryOnPage = -1;
        this.isPrintingEntryFinished = true;
        this.isPrintFirstTime = false;
    }

    private void refreshPrint(int thePageIndex) {
        this.printingY = 0;
        if (thePageIndex > this.entryPageIndex) {
            this.entryPageIndex = thePageIndex;
            this.firstEntryOnPageCopy = this.firstEntryOnPage;
            this.isPrintingEntryFinishedCopy = this.isPrintingEntryFinished;
        } else {
            this.firstEntryOnPage = this.firstEntryOnPageCopy;
            this.isPrintingEntryFinished = this.isPrintingEntryFinishedCopy;
        }
    }

    private boolean printEntry(Graphics pg) {
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int yMax = this.pageHeight - this.commonHeaderH;
        if (this.printingY + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        this.printingY += 5;
        int nameColumnWidth = this.findMaxKeyLength(3);
        int phoneColumnWidth = this.findMaxKeyLength(27);
        int left = isLeftToRight ? 0 : this.pageWidth - nameColumnWidth;
        this.drawAlignedString(pg, AddressBookManager.getPropertyLabel((int)3), left, this.printingY, nameColumnWidth);
        left = isLeftToRight ? nameColumnWidth : left - phoneColumnWidth;
        this.drawAlignedString(pg, AddressBookManager.getPropertyLabel((int)27), left, this.printingY, phoneColumnWidth);
        if (this.type == ADDRESS_PHONE) {
            left = isLeftToRight ? left + phoneColumnWidth : 0;
            this.drawAlignedString(pg, AddressBookManager.getPropertyLabel((int)41), left, this.printingY, this.pageWidth - phoneColumnWidth - nameColumnWidth);
        }
        this.printingY += fm.getHeight();
        pg.setFont(FNT_PLAIN);
        for (int k = this.firstEntryOnPage; k < this.entriesCount; ++k) {
            if (this.printingY + fontH > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastEntryOnPage = k;
            IContact entry = (IContact)this.selectedContacts.get(k);
            String value = entry.getDisplayName();
            left = isLeftToRight ? 0 : this.pageWidth - nameColumnWidth;
            this.drawAlignedString(pg, value, left, this.printingY, nameColumnWidth);
            value = entry.getStringValue(28);
            left = isLeftToRight ? nameColumnWidth : left - phoneColumnWidth;
            this.drawAlignedString(pg, value, left, this.printingY, phoneColumnWidth);
            if (this.type == ADDRESS_PHONE) {
                value = entry.getStringValue(41) + ' ' + entry.getStringValue(43) + ' ' + entry.getStringValue(45);
                left = isLeftToRight ? left + phoneColumnWidth : 0;
                this.drawAlignedString(pg, value, left, this.printingY, this.pageWidth - phoneColumnWidth - nameColumnWidth);
            }
            this.printingY += fontH;
        }
        if (this.lastEntryOnPage >= this.entriesCount - 1) {
            this.isPrintingEntryFinished = true;
        }
        this.printingY += 10;
        return true;
    }

    @Override
    public String toString() {
        if (this.type == PHONE_ONLY) {
            return StringResources.NAME_AND_TELEPHONE;
        }
        return StringResources.NAMEK_ADDRESS_AND_TELEPHONE;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.type == PHONE_ONLY) {
            return ImageResources.PRINT_FRM_PHONE;
        }
        return ImageResources.PRINT_FRM_ADDRESS_PHONE;
    }
}

