/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.application.printing.printingaddressbook.printforms.MultipleItems;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelsForm
extends MultipleItems {
    private static Logger logger = Logger.getLogger(LabelsForm.class);
    private int colWidth = 100;
    private int rowHeight = 100;
    float[] labelsDash = new float[]{5.0f, 5.0f};
    private BasicStroke labelsBorder = new BasicStroke(1.0f, 0, 0, 10.0f, this.labelsDash, 0.0f);
    private int X_GAP = 2;
    private int Y_GAP = 2;

    public LabelsForm(List<IAddressable> selectedContacts, MVCController theParentController) {
        super(selectedContacts, theParentController);
    }

    @Override
    protected int printCommonHeader(Graphics pg, int pageIndex) {
        this.colWidth = this.pageWidth / this.addressBookChecksPanel.getColsNumber();
        this.rowHeight = this.pageHeight / this.addressBookChecksPanel.getRowsNumber();
        Graphics2D g2 = (Graphics2D)pg;
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.labelsBorder);
        int nCols = this.addressBookChecksPanel.getColsNumber();
        for (int i = 1; i < nCols; ++i) {
            int x = i * this.colWidth;
            g2.drawLine(x, 0, x, this.pageHeight);
        }
        int nRows = this.addressBookChecksPanel.getRowsNumber();
        for (int i = 1; i < nRows; ++i) {
            int y = i * this.rowHeight;
            g2.drawLine(0, y, this.pageWidth, y);
        }
        g2.setStroke(stroke);
        return 0;
    }

    @Override
    public String toString() {
        return StringResources.SELECTED_FIELDS;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_LABELS;
    }
}

