/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.controls.ItemListComponentDataModelImpl;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentParam;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.DailyListForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DailyTableForm
extends DailyListForm {
    private static Logger logger = Logger.getLogger(DailyTableForm.class);
    private static final int MAX_HOURS = 20;
    private static final int LEFT_MARGIN = 80;
    private static final int WGAP = 5;
    private int labelHeight = 32;
    int quarterHourH = this.labelHeight / 4;
    BasicStroke halfHourLine = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{20.0f, 5.0f}, 0.0f);
    BasicStroke hourLine = new BasicStroke(1.0f);
    private static final int quarterTickWidth = 8;
    private HashMap hmAppointments;
    private HashMap hmAppointmentsCopy;
    private int columnSize;
    private int columnSizeCopy;
    private HashMap hmPrintApp;
    private HashMap hmPrintAppCopy;
    private DailyView dailyViewNew;
    private Color colorNotWorking = new Color(240, 240, 240);
    private Color colorAppointment = new Color(225, 225, 225);
    private static float SUBJECT_FONT_SIZE = 8.0f;
    private boolean isTablePrintingAppointmentsFinished = true;
    private boolean isTablePrintingAppointmentsFinishedCopy = true;

    public DailyTableForm(MVCController theParentController) {
        super(theParentController);
        AbstractFolder calendarFolder = this.getFolder();
        IViewDisplaySettings viewDisplaySettings = calendarFolder.getDisplaySettings().asViewDisplaySettings();
        IItemList itemList = calendarFolder.getNativeFolder().getContents(null, viewDisplaySettings);
        ItemListComponentDataModelImpl calendarModel = new ItemListComponentDataModelImpl(calendarFolder, viewDisplaySettings, itemList);
        this.dailyViewNew = new DailyView(GWCalendarUtils.getToday(), new TypesToggle("CALENDAR", true, true, true), this.getController(), true, calendarModel);
    }

    @Override
    protected void beforePrintNewDay() {
        super.beforePrintNewDay();
        this.isTablePrintingAppointmentsFinished = false;
        this.hmPrintApp.clear();
        this.dailyViewNew.setMVCModel(this.gcDay.getTime());
        this.hmAppointments = this.dailyViewNew.getAppointmentHashMap();
        this.columnSize = this.dailyViewNew.getAppointmentsColumns();
        if (this.columnSize == 0) {
            this.columnSize = 1;
        }
    }

    @Override
    public void onPrintBegin() {
        super.onPrintBegin();
        this.isTablePrintingAppointmentsFinished = true;
    }

    @Override
    protected int getStartAppointments() {
        return 8;
    }

    private int getEndAppointments() {
        return 19;
    }

    @Override
    protected void refreshPrint(int thePageIndex) {
        super.refreshPrint(thePageIndex);
        if (thePageIndex > this.dayPageIndex) {
            this.isTablePrintingAppointmentsFinishedCopy = this.isTablePrintingAppointmentsFinished;
        } else {
            this.isTablePrintingAppointmentsFinished = this.isTablePrintingAppointmentsFinishedCopy;
        }
        if (this.isPriningNewPage) {
            this.hmAppointmentsCopy = (HashMap)this.hmAppointments.clone();
            this.hmPrintAppCopy = (HashMap)this.hmPrintApp.clone();
            this.columnSizeCopy = this.columnSize;
        } else {
            this.hmAppointments = (HashMap)this.hmAppointmentsCopy.clone();
            this.hmPrintApp = (HashMap)this.hmPrintAppCopy.clone();
            this.columnSize = this.columnSizeCopy;
        }
    }

    @Override
    protected boolean printAppointments(Graphics pg) {
        if (this.isPrintingAppointmentsFinished) {
            return false;
        }
        if (!this.isTablePrintingAppointmentsFinished) {
            int y = this.printingY;
            int yMax = this.pageHeight - this.commonHeaderH;
            if (y + this.labelHeight * 3 > yMax) {
                this.printingY = 0;
                return true;
            }
            this.printTableAppointments(pg, y, yMax);
        }
        return this.printNotWorkHoursAppointments(pg, this.getNonWorkingHoursAppointments(), (Graphics2D)pg, StringResources.APPOINTMENTS_C);
    }

    private List<AbstractCalendarItem> getNonWorkingHoursAppointments() {
        Calendar gcBefore_1 = (Calendar)this.gcDay.clone();
        gcBefore_1.set(11, 0);
        gcBefore_1.set(12, 0);
        gcBefore_1.set(13, 0);
        Calendar gcBefore_2 = (Calendar)gcBefore_1.clone();
        gcBefore_2.set(11, this.getStartAppointments());
        List<AbstractCalendarItem> appointments = GWCalendarUtils.getAppointments(this.getItemList(), new Day(this.gcDay));
        List<AbstractCalendarItem> beforeCollection = GWCalendarUtils.getAppointmentsForTimeInterval(appointments, new TimeInterval(gcBefore_1.getTime(), gcBefore_2.getTime()));
        gcBefore_1.set(11, 20);
        gcBefore_1.set(12, 0);
        gcBefore_1.set(13, 0);
        gcBefore_2.set(11, 24);
        List<AbstractCalendarItem> afterCollection = GWCalendarUtils.getAppointmentsForTimeInterval(appointments, new TimeInterval(gcBefore_1.getTime(), gcBefore_2.getTime()));
        beforeCollection.addAll(afterCollection);
        return beforeCollection;
    }

    private void printTableAppointments(Graphics pg, int y, int yMax) {
        Graphics2D g2 = (Graphics2D)pg;
        g2.setFont(FNT_HEADER);
        g2.setColor(Color.black);
        this.paintHeaderRow(pg, StringResources.APPOINTMENTS_C, "", y);
        y += pg.getFontMetrics().getHeight() + 5;
        Calendar gc = GWCalendarUtils.getToday();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        pg.setFont(FNT_HEADER);
        Stroke prevStroke = g2.getStroke();
        int dY = pg.getFontMetrics().getHeight() / 2 + 3;
        for (int i = this.firstAppointmentOnPage; i < 20; ++i) {
            gc.set(11, i);
            if (y + this.labelHeight > yMax) {
                this.printingY = 0;
                break;
            }
            this.lastAppointmentOnPage = i;
            int yy = y - dY;
            g2.setColor(Color.black);
            int leftX = isLeftToRight ? 3 : this.pageWidth - 80 + 3;
            pg.drawString(OptionManager.getInstance().getDateTimeOptions().getTime(gc.getTime()), leftX, y + 3);
            g2.setColor(Color.gray);
            g2.setStroke(this.hourLine);
            g2.drawLine(0, yy, this.pageWidth, yy);
            leftX = isLeftToRight ? 80 : this.pageWidth - 80;
            g2.drawLine(leftX, yy, leftX, yy + this.labelHeight);
            leftX = isLeftToRight ? 80 - 8 : this.pageWidth - 8;
            int rightX = isLeftToRight ? 80 : this.pageWidth;
            g2.drawLine(leftX, yy + this.quarterHourH, rightX, yy + this.quarterHourH);
            g2.drawLine(leftX, yy + this.quarterHourH * 2, rightX, yy + this.quarterHourH * 2);
            g2.drawLine(leftX, yy + this.quarterHourH * 3, rightX, yy + this.quarterHourH * 3);
            g2.setStroke(this.halfHourLine);
            leftX = isLeftToRight ? 80 : 0;
            rightX = isLeftToRight ? this.pageWidth : this.pageWidth - 80;
            g2.drawLine(leftX, yy + this.labelHeight / 2, rightX, yy + this.labelHeight / 2);
            g2.setStroke(prevStroke);
            this.printAppointmentsTable(pg, i, yy);
            y += this.labelHeight;
        }
        g2.setStroke(this.hourLine);
        g2.drawLine(0, y - dY, this.pageWidth, y - dY);
        g2.setStroke(prevStroke);
        this.printingY = y + 5;
        if (this.lastAppointmentOnPage >= this.getEndAppointments()) {
            this.isTablePrintingAppointmentsFinished = true;
            this.firstAppointmentOnPage = 0;
            this.lastAppointmentOnPage = -1;
        }
        this.printingY = y + 10;
        g2.setColor(Color.black);
    }

    private boolean printNotWorkHoursAppointments(Graphics pg, List<AbstractCalendarItem> appointments, Graphics2D g2, String title) {
        if (!this.isTablePrintingAppointmentsFinished) {
            return true;
        }
        if (this.isPrintingAppointmentsFinished) {
            return true;
        }
        pg.setFont(FNT_HEADER);
        FontMetrics fm = pg.getFontMetrics();
        int fontH = fm.getHeight();
        int y = this.printingY;
        int yMax = this.pageHeight - this.commonHeaderH;
        if (y + fontH * 3 > yMax) {
            this.printingY = 0;
            return true;
        }
        y = this.printAppointmentsHeader(pg, y, pg.getFontMetrics().getHeight(), title);
        this.printAppointmentsCollection(appointments, ++y, pg.getFontMetrics().getHeight(), yMax, pg);
        g2.setColor(Color.black);
        return true;
    }

    private void printAppointmentsTable(Graphics pg, int theRow, int y) {
        this.prepareAppointmentsPrintingMap(theRow);
        int width = (this.pageWidth - 80 - 5) / this.columnSize - 5;
        int nTotal = theRow * 4 + 4;
        for (int i = theRow * 4; i < nTotal; ++i) {
            int yy = y + (i - theRow * 4) * this.quarterHourH;
            for (int j = 0; j < this.columnSize; ++j) {
                int key = i * 100 + j + 1;
                AppPrintParam app = (AppPrintParam)this.hmPrintApp.get(new Integer(key));
                if (app == null) continue;
                int ww = isLeftToRight ? 80 : 0;
                pg.setColor(this.colorAppointment);
                pg.fillRect((ww += 5 + j * (width + 5)) + 1, yy, width - 1, this.quarterHourH);
                pg.setColor(Color.black);
                pg.drawLine(ww, yy, ww, yy + this.quarterHourH);
                pg.drawLine(ww + width, yy, ww + width, yy + this.quarterHourH);
                pg.drawLine(ww + width + 1, yy, ww + width + 1, yy + this.quarterHourH);
                if (app.isFirst) {
                    pg.drawLine(ww, yy, ww + width, yy);
                }
                if (app.isLast) {
                    pg.drawLine(ww, yy + this.quarterHourH, ww + width, yy + this.quarterHourH);
                }
                if (!app.isSubjectPrinted) continue;
                this.printSubject(pg, ww, yy, app);
            }
        }
    }

    private void printSubject(Graphics pg, int ww, int yy, AppPrintParam app) {
        int width = (this.pageWidth - 80 - 5) / this.columnSize - 5;
        Shape oldClip = pg.getClip();
        Rectangle rec = new Rectangle(ww + 5, yy - this.labelHeight, width - 5, this.labelHeight * 2);
        pg.setClip(rec);
        pg.setFont(Utils.deriveFontForSize(FNT_PLAIN, SUBJECT_FONT_SIZE));
        int y = yy;
        if (app.getGridHeigth() == 1 || app.getGridHeigth() == 2) {
            y += this.quarterHourH - pg.getFontMetrics().getDescent();
        }
        pg.drawString(app.item.getSubject() == null ? "" : app.item.getSubject(), ww + 5, y);
        pg.setClip(oldClip);
        pg.setFont(FNT_PLAIN);
    }

    private void prepareAppointmentsPrintingMap(int theRow) {
        int nTotal = theRow * 4 + 4;
        for (int i = theRow * 4; i < nTotal; ++i) {
            for (int j = 0; j < this.columnSize; ++j) {
                int key = i * 100 + j + 1;
                AppointmentParam ap = (AppointmentParam)this.hmAppointments.get(new Integer(key));
                if (ap == null) continue;
                int gridH = ap.getGridHeigh();
                int subjPrintY = 0;
                subjPrintY = gridH == 1 || gridH == 2 ? gridH - 1 : (gridH == 3 ? 2 : gridH / 2);
                for (int k = 0; k < gridH; ++k) {
                    AppPrintParam app = new AppPrintParam(ap.getAppointmentItem());
                    if (k == 0) {
                        app.isFirst = true;
                    }
                    if (k == gridH - 1) {
                        app.isLast = true;
                    }
                    if (k == subjPrintY) {
                        app.isSubjectPrinted = true;
                    }
                    app.setGridHeigth(gridH);
                    this.hmPrintApp.put(new Integer(key + k * 100), app);
                }
            }
        }
    }

    @Override
    public String toString() {
        return StringResources.CALENDAR_PRINT_TABLE_AND_LIST;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_DAILY_TABLE;
    }

    @Override
    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        if (theModel instanceof Calendar) {
            this.dailyViewNew.setMVCModel(((Calendar)theModel).getTime());
        }
        this.hmPrintApp = new HashMap();
        this.hmAppointments = new HashMap();
    }

    static class AppPrintParam {
        AbstractItem item;
        boolean isFirst = false;
        boolean isLast = false;
        boolean isSubjectPrinted = false;
        private int gridHeigth = 0;

        public AppPrintParam(AbstractItem theItem, boolean theFirst, boolean theLast) {
            this.item = theItem;
            this.isFirst = theFirst;
            this.isLast = theLast;
        }

        public AppPrintParam(AbstractItem theItem) {
            this(theItem, false, false);
        }

        public int getGridHeigth() {
            return this.gridHeigth;
        }

        public void setGridHeigth(int gridHeigth) {
            this.gridHeigth = gridHeigth;
        }
    }
}

