/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.MonthForm;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.PageModel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.RollingMonthForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpendableMonthForm
extends MonthForm {
    private PageModel pageModel;
    private static Logger logger = Logger.getLogger(RollingMonthForm.class);
    private boolean weeksModelInited = false;
    private int pageCount = 0;
    private ArrayList<Integer> pageStart = new ArrayList();
    private WeekPrintModel[] weeks = new WeekPrintModel[4];
    private int dayOfMonthDimensionHeight;

    public ExpendableMonthForm(MVCController parentController) {
        super(parentController);
        this.setController(parentController);
        try {
            CalendarFolder folder = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCalendarFolder();
            this.itemList = folder.getItemList();
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
        this.changeDateValues(this.startingDay);
    }

    @Override
    boolean pageExists(int pageIndex) {
        PageModel model = this.getPageModel(pageIndex);
        return pageIndex < this.getNumberOfPages() && model != null;
    }

    @Override
    public String toString() {
        return StringResources.EXPANDABLE_MONTH_CALENDAR;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_MONTH_EXPAND;
    }

    protected PageModel getPageModel(int pageIndex) {
        Calendar startingDay = printingCalendarPanel.getStartingDay();
        logger.debug((Object)("start: " + DateFormat.getDateInstance(0).format(startingDay.getTime())));
        Calendar firstDay = (Calendar)startingDay.clone();
        firstDay.set(7, startingDay.getFirstDayOfWeek());
        return new PageModel(firstDay, this);
    }

    @Override
    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(pg, pageFormat, pageIndex);
        int y = 0;
        this.pageModel = this.getPageModel(pageIndex);
        this.dayOfMonthDimensionHeight = this.getDayOfMonthDimension((Graphics)pg).width;
        if (!this.weeksModelInited) {
            this.initWeeks(pg, this.pageModel, y);
        }
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        if (this.pageModel == null) {
            return 1;
        }
        CalendarForm.RTLOffset = 0;
        if (pageIndex == 0) {
            this.printPreviousMonthCalendar(pg, (int)pageFormat.getImageableWidth());
            this.printNextMonthCalendar(pg, (int)pageFormat.getImageableWidth());
            y = monthlyCalendarFontAttributes.calculateMonthlyCalendarHeight() + 20;
        }
        this.printCurrentMonth(pg, this.pageModel, y, this.pageStart.get(pageIndex), pageIndex);
        return 0;
    }

    private void initWeeks(Graphics pg, PageModel pageModel, int y) {
        Calendar day = (Calendar)printingCalendarPanel.getStartingDay().clone();
        while (pageModel.getNumberOfDaysInRow() == 5 && day.get(7) != 2 || pageModel.getNumberOfDaysInRow() == 7 && day.get(7) != 1) {
            day.add(5, -1);
        }
        for (int i = 0; i < 4; ++i) {
            this.weeks[i] = new WeekPrintModel(pg, pageModel, day, y);
            y += this.weeks[i].getHeight();
        }
        this.weeksModelInited = true;
    }

    private void printCurrentMonth(Graphics pg, PageModel pageModel, int y, Integer pageStart, int pageIndex) {
        pg.translate(0, -pageStart.intValue());
        pg.drawRect(0, y -= pageStart.intValue(), this.pageWidth, this.getClipHeight(pg) - y);
        ++y;
        y = this.printDayNames(pg, pageModel, y);
        pg.setFont(this.monthNameFont);
        HashMap<Integer, String> monthLabels = new HashMap<Integer, String>(2);
        int monthLabelsHeight = 0;
        for (int i = 0; i < 4; ++i) {
            String label = pageModel.getMonthLabel(i);
            if (label == null) continue;
            monthLabels.put(i, label);
            monthLabelsHeight += (int)pg.getFontMetrics().getStringBounds(label, pg).getHeight();
        }
        monthLabelsHeight += 6 * monthLabels.size();
        Rectangle r = pg.getClipBounds();
        logger.debug((Object)("clip: " + r + ", page height: " + this.getClipHeight(pg)));
        int heightLeft = this.getClipHeight(pg) - y - this.footerHeight;
        for (int i = 0; i < 4; ++i) {
            if (monthLabels.get(i) != null) {
                y = this.printMonthLabel(pg, y, (String)monthLabels.get(i));
                logger.debug((Object)("y > : " + y));
            }
            y = this.printWeek(pg, pageModel, y, this.weeks[i].getHeight(), i, pageIndex);
            logger.debug((Object)("week height: " + this.weeks[i].getHeight()));
            logger.debug((Object)("y > : " + y));
        }
        logger.debug((Object)("page height: " + this.getClipHeight(pg) + ", end Y: " + y));
    }

    protected int printWeek(Graphics pg, PageModel pageModel, int y, int height, int weekIndex, int pageIndex) {
        int endY = y + height;
        logger.debug((Object)("week: " + weekIndex + ", end Y: " + endY));
        assert (endY <= this.getClipHeight(pg)) : "below printable area, exceeded " + (endY - this.getClipHeight(pg)) + " pixels";
        pg.drawLine(0, endY, this.pageWidth, endY);
        int startX = 0;
        for (int i = 0; i < this.pageModel.getNumberOfDaysInRow(); ++i) {
            int endX = pageModel.getColumnWidth(i) + startX;
            pg.drawLine(startX, y, startX, endY);
            Rectangle dayRectangle = new Rectangle(startX + 1, y + 1, endX - startX - 1, endY - y - 1);
            this.printDay(pg, pageModel, this.weeks[weekIndex].getCell(i).getDay(), dayRectangle);
            startX = endX;
        }
        return endY;
    }

    private void drawCellBorder(Graphics pg, Rectangle rect, RectType type) {
        if (type == RectType.FULL) {
            pg.drawRect(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
            return;
        }
        pg.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        pg.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
        if (type == RectType.WITHOUT_BOTTOM) {
            pg.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            return;
        }
        pg.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
    }

    private void printDay(Graphics pg, PageModel pageModel, Calendar day, Rectangle rectangle) {
        Dimension dimension = this.getDayOfMonthDimension(pg);
        int y = rectangle.y + dimension.height;
        int cellEndY = (int)((double)rectangle.y + rectangle.getHeight());
        int cellEndX = (int)((double)rectangle.x + rectangle.getWidth());
        int startX = CalendarForm.isLeftToRight ? rectangle.x : rectangle.x + rectangle.width - dimension.width;
        int endX = CalendarForm.isLeftToRight ? startX + dimension.width : startX + dimension.width;
        pg.drawLine(startX, y, endX, y);
        int x = CalendarForm.isLeftToRight ? endX : startX;
        pg.drawLine(x, rectangle.y, x, y);
        pg.setFont(this.dayOfMonthFont);
        String text = Integer.toString(day.get(5));
        int descent = pg.getFontMetrics().getDescent();
        int stringWidth = pg.getFontMetrics().stringWidth(text);
        x = startX + (dimension.width - stringWidth) / 2;
        int textHeight = (int)pg.getFontMetrics().getStringBounds(text, pg).getHeight();
        int endY = y - (dimension.height - textHeight) / 2 - descent - 3;
        pg.drawString(text, x, endY);
    }

    protected int printCellStrings(Map<? extends AbstractItem, String> stringMap, Graphics pg, int x, int y, int cellEndX, int cellEndY) {
        int fontMetricsHeight = pg.getFontMetrics().getHeight();
        int descent = pg.getFontMetrics().getDescent();
        for (AbstractItem abstractItem : stringMap.keySet()) {
            String string = stringMap.get(abstractItem);
            string = CalendarForm.isLeftToRight ? "   " + string : string + "   ";
            List<String> subStrings = UIUtils.breakStringIntoSubstrings(string, pg.getFontMetrics(), cellEndX - x);
            boolean firstLine = true;
            for (String subString : subStrings) {
                int endY = y + fontMetricsHeight;
                if (endY > cellEndY) {
                    logger.debug((Object)"end of cell reached > skippng the rest of items");
                    return -1;
                }
                if (firstLine) {
                    int iconStartX = CalendarForm.isLeftToRight ? x + 1 : cellEndX - fontMetricsHeight - 1;
                    int iconStartY = y + 1;
                    this.printItemIcon(abstractItem, pg, iconStartX, iconStartY, iconStartX + fontMetricsHeight - 2, iconStartY + fontMetricsHeight - 2);
                    firstLine = false;
                }
                int startX = CalendarForm.isLeftToRight ? x + 3 : cellEndX - pg.getFontMetrics().stringWidth(subString);
                pg.drawString(subString, startX, endY -= descent);
                y += fontMetricsHeight;
            }
            this.drawHorizontalDashedLine(pg, 5, x, y, cellEndX);
        }
        return y;
    }

    public int getDayOfMonthDimensionHeight() {
        return this.dayOfMonthDimensionHeight;
    }

    private int getNumberOfPages() {
        int i;
        if (this.pageCount != 0) {
            return this.pageCount;
        }
        int fourWeeksHeight = this.commonHeaderH + this.footerHeight + 60;
        for (i = 0; i < 4; ++i) {
            fourWeeksHeight += this.weeks[i].getHeight();
        }
        this.pageCount = 2;
        while (fourWeeksHeight - this.pageHeight > 0) {
            fourWeeksHeight -= this.pageHeight;
            ++this.pageCount;
        }
        for (i = 0; i < this.pageCount; ++i) {
            this.pageStart.add(i, 280 * i);
        }
        return this.pageCount;
    }

    class ItemRecord {
        private ItemType itemType;
        private String[] strings;
        private int y;
        private int itemHeight;

        public ItemRecord(ItemType itemType, String[] strings, int y) {
            this.y = y;
            this.strings = strings;
            this.itemType = itemType;
            this.itemHeight = 0;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public String[] getStrings() {
            return this.strings;
        }

        public void initItemHeight(Graphics pg) {
            int lineHeight = pg.getFontMetrics().getHeight() + pg.getFontMetrics().getDescent();
            for (int i = 0; i < this.strings.length; ++i) {
                this.itemHeight += lineHeight;
            }
        }

        public int getItemHeight() {
            return this.itemHeight;
        }
    }

    class CellPrintModel {
        private ArrayList<ItemRecord> records = new ArrayList();
        private Calendar day;
        private int y;
        private int cellHeight;
        private ArrayList<Integer> breakPositions = new ArrayList();

        public CellPrintModel(Graphics pg, Calendar firstDay, int y) {
            this.day = (Calendar)firstDay.clone();
            this.y = y;
            this.fillRecords(pg);
            this.calculateHeight();
        }

        private void fillRecords(Graphics pg) {
            this.initAllDayEvents(pg);
            this.initAppointments(pg);
            this.initNotes(pg);
            this.initTasks(pg);
        }

        private void calculateHeight() {
            for (int i = 0; i < this.records.size(); ++i) {
                this.cellHeight += this.records.get(i).getItemHeight();
            }
        }

        private void initAllDayEvents(Graphics pg) {
            PrintingCalendarPanel optionPanel = ExpendableMonthForm.this.pageModel.getPrintingCalendarPanel();
            if (optionPanel.hasAllDayEvents()) {
                List<AbstractCalendarItem> appointments = GWCalendarUtils.getAllDayEvents(ExpendableMonthForm.this.itemList, this.day.getTime());
                for (AbstractCalendarItem item : appointments) {
                    if (!optionPanel.hasPrivateCalendarItems() && item.isPrivate()) continue;
                    String appText = CalendarForm.isLeftToRight ? "(" + StringResources.ALL_DAY_EVENT + ")" + item.getSubject() : item.getSubject() + ")" + StringResources.ALL_DAY_EVENT + "(";
                    this.createItemRecord(appText, pg, ItemType.APPT);
                }
            }
        }

        private void initAppointments(Graphics pg) {
            PrintingCalendarPanel optionPanel = ExpendableMonthForm.this.pageModel.getPrintingCalendarPanel();
            if (optionPanel.hasAppointments()) {
                List<AbstractCalendarItem> appointments = GWCalendarUtils.getAllDayEvents(ExpendableMonthForm.this.itemList, this.day.getTime());
                String appText = "";
                for (AbstractCalendarItem item : appointments) {
                    if (!optionPanel.hasPrivateCalendarItems() && item.isPersonal()) continue;
                    if (optionPanel.hasAppointmentsStart() || optionPanel.hasAppointmentsEnd()) {
                        appText = appText + (CalendarForm.isLeftToRight ? "(" : ")");
                        if (optionPanel.hasAppointmentsStart()) {
                            appText = appText + OptionManager.getInstance().getDateTimeOptions().getTime(item.getStartDate());
                        }
                        if (optionPanel.hasAppointmentsStart() && optionPanel.hasAppointmentsEnd()) {
                            appText = appText + " - ";
                        }
                        if (optionPanel.hasAppointmentsEnd()) {
                            appText = appText + OptionManager.getInstance().getDateTimeOptions().getTime(item.getEndDate());
                        }
                        appText = appText + (CalendarForm.isLeftToRight ? ") " : " (");
                    }
                    appText = appText + item.getSubject();
                    appText = appText + " ";
                    if (optionPanel.hasAppointmentsFrom()) {
                        appText = appText + StringResources.FROM_C;
                        appText = appText + " ";
                        appText = appText + item.getSenderID();
                        appText = appText + " ";
                    }
                    if (optionPanel.hasAppointmentsPlace()) {
                        appText = appText + (CalendarForm.isLeftToRight ? "(" : ")");
                        appText = appText + ((AppointmentItem)item).getPlace();
                        appText = appText + (CalendarForm.isLeftToRight ? ") " : " (");
                    }
                    if (optionPanel.hasAppointmentsMessage()) {
                        appText = appText + UIUtils.getShortCutText(item.getMessage().getMessage(), 50);
                    }
                    logger.debug((Object)("string: " + appText));
                    this.createItemRecord(appText, pg, ItemType.APPT);
                }
            }
        }

        private void initNotes(Graphics pg) {
            PrintingCalendarPanel optionPanel = ExpendableMonthForm.this.pageModel.getPrintingCalendarPanel();
            if (optionPanel.hasNotes()) {
                List<AbstractCalendarItem> notes = GWCalendarUtils.getNotes(ExpendableMonthForm.this.itemList, new Day(this.day));
                String appText = "";
                for (AbstractCalendarItem item : notes) {
                    if (!optionPanel.hasPrivateCalendarItems() && item.isPrivate()) continue;
                    appText = appText + item.getSubject();
                    appText = appText + " ";
                    if (optionPanel.hasNotesFrom()) {
                        appText = appText + StringResources.FROM_C;
                        appText = appText + "( )";
                        appText = appText + item.getSenderID();
                        appText = appText + "( )";
                    }
                    if (optionPanel.hasNotesMessage()) {
                        appText = appText + UIUtils.getShortCutText(item.getMessage().getMessage(), 50);
                    }
                    logger.debug((Object)("string: " + appText));
                    this.createItemRecord(appText, pg, ItemType.NOTE);
                }
            }
        }

        private void initTasks(Graphics pg) {
            PrintingCalendarPanel optionPanel = ExpendableMonthForm.this.pageModel.getPrintingCalendarPanel();
            if (optionPanel.hasTasks()) {
                List<AbstractItem> tasks = GWCalendarUtils.getTasks(ExpendableMonthForm.this.itemList, new Day(this.day));
                String appText = "";
                for (AbstractItem item : tasks) {
                    if (!optionPanel.hasPrivateCalendarItems() && item.isPrivate() || !optionPanel.hasCompletedTasks() && item.isStatusCompleted()) continue;
                    if (optionPanel.hasTasksPriority()) {
                        if (item.getPriority() == 4) {
                            appText = appText + StringResources.HIGH;
                        }
                        if (item.getPriority() == 1) {
                            appText = appText + StringResources.LOW;
                        }
                        if (item.getPriority() == 2) {
                            appText = appText + StringResources.STANDARD_SHORT;
                        }
                        appText = appText + " ";
                    }
                    appText = appText + item.getSubject();
                    appText = appText + " ";
                    if (optionPanel.hasTasksFrom()) {
                        appText = appText + StringResources.FROM_C;
                        appText = appText + " ";
                        appText = appText + item.getSenderID();
                        appText = appText + " ";
                    }
                    if (optionPanel.hasTasksStart()) {
                        appText = appText + StringResources.START_C;
                        appText = appText + " ";
                        appText = appText + OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(item.getDate());
                        appText = appText + " ";
                    }
                    if (optionPanel.hasTasksDue()) {
                        appText = appText + StringResources.DUE_C;
                        appText = appText + " ";
                        appText = appText + OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(new Date(item.getDueDate()));
                        appText = appText + " ";
                    }
                    if (optionPanel.hasAppointmentsMessage()) {
                        appText = appText + UIUtils.getShortCutText(item.getMessage().getMessage(), 50);
                    }
                    logger.debug((Object)("string: " + appText));
                    this.createItemRecord(appText, pg, ItemType.TODO);
                }
            }
        }

        private void createItemRecord(String appText, Graphics pg, ItemType type) {
            List<String> subStrings = UIUtils.breakStringIntoSubstrings(appText, pg.getFontMetrics(), ExpendableMonthForm.this.pageModel.getColumnWidth(0));
            String[] brokenAppText = new String[subStrings.size()];
            subStrings.toArray(brokenAppText);
            ItemRecord newRecord = new ItemRecord(type, brokenAppText, this.y);
            newRecord.initItemHeight(pg);
            this.records.add(newRecord);
        }

        public int getCellHeight() {
            return this.cellHeight;
        }

        public Calendar getDay() {
            return this.day;
        }

        public void setCellBreakPoints() {
        }
    }

    class WeekPrintModel {
        private CellPrintModel[] cells;
        private int height = 0;
        private int[] pageIndeces;

        public WeekPrintModel(Graphics pg, PageModel pageModel, Calendar day, int y) {
            this.cells = new CellPrintModel[pageModel.getNumberOfDaysInRow()];
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i] = new CellPrintModel(pg, day, y);
                day.add(5, 1);
                if (day.get(7) != 7 || pageModel.getNumberOfDaysInRow() != 5) continue;
                day.add(5, 2);
            }
            int maxHeight = ExpendableMonthForm.this.getDayOfMonthDimensionHeight();
            for (int i = 0; i < this.cells.length; ++i) {
                if (this.cells[i].getCellHeight() <= maxHeight) continue;
                maxHeight = this.cells[i].getCellHeight();
            }
            this.height = maxHeight;
        }

        public int getHeight() {
            return this.height;
        }

        public CellPrintModel getCell(int i) {
            return this.cells[i];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RectType {
        FULL,
        WITHOUT_TOP,
        WITHOUT_BOTTOM;

    }
}

