/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.apache.log4j.Logger;

public class AppointmentForm
extends GWItemForm {
    private static Logger logger = Logger.getLogger(AppointmentForm.class);
    private AppointmentItem item;

    public AppointmentForm(AppointmentItem theItem, MVCController theParentController) {
        this(theItem, GWItemForm.DONT_PRINT_ATTACHMENT_LIST, theParentController);
    }

    public AppointmentForm(AppointmentItem theItem, int printAttachmentList, MVCController theParentController) {
        super(theItem, printAttachmentList, theParentController);
        this.item = theItem;
        this.itemType = StringResources.APPOINTMENT;
    }

    protected int printHeader(Graphics pg) {
        int y = super.printHeader(pg);
        Font bold = FNT_SUB_HEADER;
        Font plain = FNT_PLAIN;
        FontMetrics fm = pg.getFontMetrics();
        this.paintHeaderRow(pg, StringResources.PLACE_C, this.item.getLocation(), y, bold, plain);
        int nHeight = fm.getHeight();
        y += nHeight;
        if (this.itemChecksPanel.isDateSelected()) {
            this.paintHeaderRow(pg, StringResources.START_DATE_C, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(this.item.getStartDate()), y, bold, plain);
            this.paintHeaderRow(pg, StringResources.DURATION_C, GWCalendarUtils.getDurationText(this.item.getDuration()), y += nHeight, bold, plain);
            y += nHeight + 10;
        }
        if (this.itemChecksPanel.isSubjectSelected()) {
            pg.setFont(bold);
            this.paintHeaderRow(pg, StringResources.SUBJECT_C, this.item.getSubject(), y, bold, plain);
            y += nHeight;
        }
        pg.setFont(bold);
        int x = (int)pg.getFontMetrics().getStringBounds(StringResources.MESSAGE_C, pg).getWidth();
        pg.drawString(StringResources.MESSAGE_C, this.getTitleX(x), y += 5);
        return y += 10;
    }

    public String toString() {
        String s = StringResources.SIMPLE_APPOINTMENT_ITEM_FORM;
        if (this.printAttachmentList == GWItemForm.PRINT_ATTACHMENT_LIST) {
            s = s + ' ' + StringResources.L_WITH_LIST_OF_ATTACHMENTS;
        }
        return s;
    }
}

