/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem.printforms;

import com.appframework.components.htmleditor.HTMLStyledEditorKit;
import com.novell.gw.jclient.application.printing.basicforms.HTMLPrintForm;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class GWItemHTMLPrintForm
extends HTMLPrintForm {
    private static Logger logger = Logger.getLogger(GWItemHTMLPrintForm.class);

    public GWItemHTMLPrintForm(AbstractItem theItem, ItemChecksPanel theItemChecksPanel, String userGuid) {
        super(theItem, theItemChecksPanel, userGuid);
        if (!theItem.isHTMLMessage()) {
            String message = theItem.getMessage().getMessage();
            if (message.toLowerCase().contains("<body")) {
                HTMLStyledEditorKit kit = new HTMLStyledEditorKit();
                try {
                    Document doc = kit.createDefaultDocument();
                    StringReader reader = new StringReader(message);
                    kit.read(reader, doc, 0);
                    this.editor.setDocument(doc);
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            } else {
                this.editor.setText(message.replaceAll("\n", "<br>"));
            }
        } else {
            try {
                String path = theItem.getHTMLBodyTextFile();
                if (path != null && path.length() != 0) {
                    File f = new File(path);
                    this.setPage(f.toURL());
                }
            }
            catch (MalformedURLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

