/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingitem.printforms;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.basicforms.GWItemForm;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaskForm
extends GWItemForm {
    private static Logger logger = Logger.getLogger(TaskForm.class);
    private TaskItem item;

    public TaskForm(TaskItem theItem, int printAttachmentList, MVCController theParentController) {
        super(theItem, printAttachmentList, theParentController);
        this.item = theItem;
        this.itemType = StringResources.TASK;
    }

    protected int printHeader(Graphics pg) {
        int y = super.printHeader(pg);
        Font bold = FNT_SUB_HEADER;
        Font plain = FNT_PLAIN;
        pg.setFont(bold);
        FontMetrics fm = pg.getFontMetrics();
        int nHeight = fm.getHeight();
        if (this.itemChecksPanel.isDateSelected()) {
            this.paintHeaderRow(pg, StringResources.START_DATE_C, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(new Date(this.item.getDateTaskAssigned())), y, bold, plain);
            pg.setFont(bold);
            this.paintHeaderRow(pg, StringResources.DUE_ON_C, OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(this.item.getEndDate()), y += nHeight, bold, plain);
            y += nHeight;
        }
        if (this.itemChecksPanel.isSubjectSelected()) {
            this.paintHeaderRow(pg, StringResources.SUBJECT_C, this.item.getSubject(), y, bold, plain);
            y += nHeight;
        }
        pg.setFont(bold);
        this.paintHeaderRow(pg, StringResources.PRIORITY_C, Integer.toString(this.item.getPriority()), y, bold, plain);
        pg.setFont(bold);
        int x = (int)pg.getFontMetrics().getStringBounds(StringResources.MESSAGE_C, pg).getWidth();
        pg.drawString(StringResources.MESSAGE_C, this.getTitleX(x), y += nHeight + 5);
        return y += 10;
    }

    public String toString() {
        String s = StringResources.SIMPLE_TASK_FORM;
        if (this.printAttachmentList == GWItemForm.PRINT_ATTACHMENT_LIST) {
            s = s + ' ' + StringResources.L_WITH_LIST_OF_ATTACHMENTS;
        }
        return s;
    }
}

