/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.utils.Assertions;
import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMailListManager;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.enums.DataStoreDisplaySettingsSubtype;
import com.novell.gw.jclient.api.enums.EngineLoginPrompt;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IEngine;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IDocumentReference;
import com.novell.gw.jclient.api.interfaces.message.IMail;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.IMessageAttachment;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.IPhoneMessage;
import com.novell.gw.jclient.api.interfaces.message.ISharedAddressBookNotification;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.FoldersChangeListener;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.AddressBookItemsFactory;
import com.novell.gw.jclient.bl.eng_impl.CallbackManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCallBackListener;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWSecurityPasswordOptions;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWItemAttachment;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.jclient.bl.om.items.UnknownTableItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import com.novell.gw.notification.NotifySubscribeList;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineCommandManager
extends GWCommandManager {
    private static Logger logger = Logger.getLogger(EngineCommandManager.class);
    private static IEngine engine = APIFactory.getEngine();
    private static EngineCallBackListener callback;
    private static IDataStore userDataStore;
    private IDataStore currentDataStore;
    private static FoldersChangeListener foldersChangeListener;
    private boolean isProxyDataStore;
    private GWUserInfo currentUserInfo;
    private static final String BACKUP_DATA_STORE = "BACKUP_DATA_STORE";
    private static final String ARCHIVE_DATA_STORE = "ARCHIVE_DATA_STORE";

    private EngineCommandManager(IDataStore dataStore) {
        this.currentDataStore = dataStore != null ? dataStore : userDataStore;
        if (!(this.currentDataStore.isArchiveDB() || this.currentDataStore.isBackupDB() || this.currentDataStore.equals(userDataStore))) {
            this.isProxyDataStore = true;
        }
        this.currentUserInfo = EngineCommandManager.createUserInfo(this.currentDataStore);
    }

    @Deprecated
    public static ContactsFolder getContactsFolder() {
        return (ContactsFolder)FoldersCache.getFolder(ContactsFolder.class, userInfo.getGuid());
    }

    public static Locale getLocale() {
        return EngineLocale.getCurrent().getLocale();
    }

    public static LoginParameters parseCommandLine(String[] args) {
        return APIFactory.getAPIUtils().parseCommandLine(args);
    }

    public static GWUserInfo loginUser(LoginParameters params) throws GWCommandException {
        logger.debug((Object)"loginUser entered");
        callback = new EngineCallBackListener();
        engine.setCallback(CallbackManager.getInstance().createCallbackProxy(callback));
        try {
            userDataStore = engine.login(params, EngineLoginPrompt.IF_NECESSARY);
            if (userDataStore == null) {
                return null;
            }
            userInfo = EngineCommandManager.createUserInfo(userDataStore);
            instances.put(userInfo.getGuid(), new EngineCommandManager(userDataStore));
            EngineCommandManager.saveLoginOptions();
        }
        catch (EngineException e) {
            throw new GWCommandException("Engine error.", "Internal error. " + e.getMessage(), e);
        }
        logger.debug((Object)"loginUser exited");
        return userInfo;
    }

    private static GWUserInfo createUserInfo(IDataStore dataStore) {
        GWUserInfo result = new GWUserInfo(dataStore.getUserId());
        result.setName(dataStore.getUserId());
        result.setUserFields(dataStore.getUserFields());
        if (dataStore.isArchiveDB()) {
            result.setGuid(ARCHIVE_DATA_STORE);
        } else if (dataStore.isBackupDB()) {
            result.setGuid(BACKUP_DATA_STORE);
        } else {
            result.setGuid(dataStore.getUserFields().getGuid());
        }
        result.setPassword("");
        result.setFileId(dataStore.getUserFileId());
        result.setPostOffice(dataStore.getHost());
        try {
            result.setPort(Integer.valueOf(dataStore.getTcpIpPort()));
        }
        catch (NumberFormatException e) {
            result.setPort(1677);
        }
        result.setServerIP(dataStore.getTcpIpAddress());
        result.setCachingPath(engine.getPathToCache());
        result.setFromText(dataStore.getUserFullName());
        return result;
    }

    private static void saveLoginOptions() {
        LoginOptions loginOptions = OptionManager.getInstance().getLoginOptions();
        loginOptions.setUserName(userInfo.getName());
        loginOptions.setServerName(userInfo.getServerIP());
        loginOptions.setServerPort(userInfo.getPort());
        loginOptions.setMode(EngineCommandManager.getCurrentMode());
        OptionManager.getInstance().setCashingPath(userInfo.getCachingPath());
        OptionManager.getInstance().setLoginOptions(loginOptions);
    }

    @Override
    public final boolean switchToCaching() {
        logger.debug((Object)"switchToCaching entered");
        boolean result = false;
        if (engine.canSwitchMode(EngineMode.CACHING) && engine.canDispose()) {
            callback.setCurrentSwitchingMode(EngineMode.CACHING);
            engine.switchMode(EngineMode.CACHING);
            result = true;
            this.isProxyDataStore = false;
        }
        logger.debug((Object)"switchToCaching exited");
        return result;
    }

    @Override
    public final boolean switchToOnline() {
        logger.debug((Object)"switchToOnline entered");
        boolean result = false;
        if (engine.canSwitchMode(EngineMode.ONLINE) && engine.canDispose()) {
            callback.setCurrentSwitchingMode(EngineMode.ONLINE);
            engine.switchMode(EngineMode.ONLINE);
            result = true;
            this.isProxyDataStore = false;
        }
        logger.debug((Object)"switchToOnline exited");
        return result;
    }

    public static EngineMode getCurrentMode() {
        if (userDataStore.isCaching()) {
            return EngineMode.CACHING;
        }
        if (userDataStore.isOnline()) {
            return EngineMode.ONLINE;
        }
        if (userDataStore.isRemote()) {
            return EngineMode.REMOTE;
        }
        throw new RuntimeException("Illegal engine mode");
    }

    public static boolean isSSLActive() {
        return engine.isSSLActive();
    }

    public static String getProductVersionName() {
        return engine.getProductVersionName();
    }

    @Override
    public final IAddressable getUserFields() {
        return this.currentDataStore.getUserFields();
    }

    @Override
    public final GWUserInfo getCurrentUserInfo() {
        return this.currentUserInfo;
    }

    public static GWUserInfo getUserInfo() {
        return userInfo;
    }

    public static String getUserGuid() {
        return userInfo.getGuid();
    }

    public static boolean logoutUser() throws GWCommandException {
        try {
            EngineCommandManager.shutdown();
            return true;
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
            throw new GWCommandException("Engine error.", "Internal error. " + e, e);
        }
    }

    private static void shutdown() {
        instances.remove(userInfo.getGuid());
        userDataStore.writeMemoryCachedData();
        userDataStore.dispose();
        userDataStore = null;
        if (!DevModeUtils.isSoftExit()) {
            engine = null;
        }
    }

    @Override
    public AbstractFolder getMailboxFolder() throws GWCommandException {
        return this.getFolder(FolderType.UNIVERSAL);
    }

    @Override
    public AbstractFolder getTrashFolder() throws GWCommandException {
        return this.getFolder(FolderType.TRASH);
    }

    @Override
    public AbstractFolder getFolder(String id) {
        String userGuid = this.currentUserInfo.getGuid();
        if (FoldersCache.containsFolder(id, userGuid)) {
            return FoldersCache.getFolder(id, userGuid);
        }
        try {
            return this.getFolder(this.getRootFolder().getNativeFolder(), Integer.parseInt(id));
        }
        catch (GWCommandException e) {
            e.printStackTrace();
            return null;
        }
    }

    private AbstractFolder getFolder(IFolder folder, int id) {
        for (IFolder parentFolder : folder.getSubFolders()) {
            if (parentFolder.getId() == id) {
                return this.getGWFolder(parentFolder);
            }
            this.getFolder(parentFolder, id);
        }
        return null;
    }

    private static IFolder getFolder(FolderType type, IFolder folder) {
        if (folder.getType() == type) {
            return folder;
        }
        for (IFolder childFolder : folder.getSubFolders()) {
            IFolder foundFolder = EngineCommandManager.getFolder(type, childFolder);
            if (foundFolder == null) continue;
            return foundFolder;
        }
        return null;
    }

    private AbstractFolder getFolder(FolderType type) {
        try {
            AbstractFolder rootFolder = this.getRootFolder();
            return this.getGWFolder(EngineCommandManager.getFolder(type, rootFolder.getNativeFolder()));
        }
        catch (GWCommandException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final AbstractFolder getRootFolder() throws GWCommandException {
        try {
            if (FoldersCache.containsRootFolder(this.currentUserInfo.getGuid())) {
                return FoldersCache.getRootFolder(this.currentUserInfo.getGuid());
            }
            this.currentDataStore.removeDataStoreListener(foldersChangeListener);
            this.currentDataStore.addDataStoreListener(foldersChangeListener);
            foldersChangeListener.setUserGuid(this.currentUserInfo.getGuid());
            IFolder[] rootFolders = this.currentDataStore.getRootFolders();
            AbstractFolder rootFolder = this.buildFolders(rootFolders).get(0);
            FoldersCache.putRootFolder(rootFolder, this.currentUserInfo.getGuid());
            return rootFolder;
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
            throw new GWCommandException("Engine error.", "Internal error. " + e, e);
        }
    }

    private List<AbstractFolder> buildFolders(IFolder[] folders) {
        ArrayList<AbstractFolder> result = new ArrayList<AbstractFolder>();
        for (IFolder folder : folders) {
            if (folder.isDeleted()) continue;
            AbstractFolder abstractFolder = this.getGWFolder(folder);
            this.buildFolders(folder.getSubFolders());
            result.add(abstractFolder);
        }
        return result;
    }

    private AbstractFolder createGWFolder(IFolder theFolder) {
        Assertions.assertNotNull(theFolder, "Can't be null");
        AbstractFolder result = null;
        String folderID = String.valueOf(theFolder.getId());
        String folderName = theFolder.getName();
        Class folderClass = GWEngineUtils.getFolderClass(theFolder);
        try {
            result = (AbstractFolder)folderClass.newInstance();
            result.setID(folderID);
            result.setName(folderName);
            result.setNativeFolder(theFolder);
            result.setUserGuid(this.currentUserInfo.getGuid());
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return result;
    }

    @Override
    public final CalendarFolder getCalendarFolder() throws GWCommandException {
        return (CalendarFolder)this.getFolder(FolderType.CALENDAR);
    }

    @Override
    public final SentItemsFolder getSentItemsFolder() throws GWCommandException {
        if (!FoldersCache.containsFolder(SentItemsFolder.class, this.currentUserInfo.getGuid())) {
            this.getRootFolder();
        }
        return (SentItemsFolder)FoldersCache.getFolder(SentItemsFolder.class, this.currentUserInfo.getGuid());
    }

    public static List<AbstractAddressBook> getAddressBooks() {
        ArrayList<AbstractAddressBook> addressBooks = new ArrayList<AbstractAddressBook>();
        addressBooks.add(AddressBookItemsFactory.createAddressBook((AddressBook)userDataStore.getAddressBookManager().getSystemAddressBook()));
        Iterator i = userDataStore.getAddressBookManager().getPersonalAddressBooksIterator();
        while (i.hasNext()) {
            AddressBook addressBook = (AddressBook)i.next();
            addressBooks.add(AddressBookItemsFactory.createAddressBook(addressBook));
        }
        return addressBooks;
    }

    public static GroupWiseAddressBook getGroupWiseAdressBook() {
        for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
            if (!(addressBook instanceof GroupWiseAddressBook)) continue;
            return (GroupWiseAddressBook)addressBook;
        }
        return null;
    }

    public static FrequentContactsAddressBook getFrequentContactsAddressBook() {
        com.novell.gw.ab.PersonalAddressBook addressBook = userDataStore.getAddressBookManager().getFrequentContactsBook();
        if (addressBook != null) {
            return (FrequentContactsAddressBook)AddressBookItemsFactory.createAddressBook((AddressBook)addressBook);
        }
        return null;
    }

    @Override
    public void directorySaveAs(AbstractAddressBook theDirectory, String theNewName, String theDescription) throws GWCommandException {
        throw new GWCommandException("directorySaveAs is not supported yet");
    }

    public static void createAddressBook(String theName) throws EngineException {
        userDataStore.getAddressBookManager().createAddressBook(theName);
    }

    public static void deleteAddressBook(PersonalAddressBook theDirectory) throws EngineException {
        userDataStore.getAddressBookManager().deleteAddressBook((com.novell.gw.ab.PersonalAddressBook)theDirectory.getNativeAddressBook());
    }

    public static boolean deleteFolder(AbstractFolder folder, String userGuid) {
        boolean result;
        String type = folder.getType();
        IDataStore dataStore = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        if (type.equals("NntpFolder") || type.equals("ImapFolder")) {
            Account account = dataStore.getAccount(folder.getNativeFolder().getName());
            dataStore.deleteAccount(account);
            logger.debug((Object)(">>--ACCOUNT " + account.getName() + " DELETED--<<"));
        }
        if (result = folder.getNativeFolder().delete(dataStore)) {
            FoldersCache.removeFolder(folder, userGuid);
        }
        return result;
    }

    @Override
    public AbstractFolder createFolder(String theFolderName, String theDescription, AbstractFolder theParentFolder, int thePosition) {
        IFolder newFolder = this.currentDataStore.createFolder(theFolderName, theDescription, theParentFolder.getNativeFolder(), thePosition);
        if (newFolder == null) {
            logger.debug((Object)"folder was not created");
            return null;
        }
        AbstractFolder folder = this.getGWFolder(newFolder);
        return folder;
    }

    @Override
    public AbstractFolder createCalendarFolder(String theFolderName, IFolder theParentFolder) {
        IFolder newFolder = this.currentDataStore.createFolder(theFolderName, "", theParentFolder, theParentFolder.getSubFolders().length);
        if (newFolder == null) {
            logger.debug((Object)"calendar folder was not created");
            return null;
        }
        newFolder.setSubCalendar();
        newFolder.setSubCalendarShown(true);
        newFolder.setCalendarListSequenceNumber(this.currentDataStore.getCalendarFoldersCount());
        AbstractFolder folder = this.getGWFolder(newFolder);
        return folder;
    }

    @Override
    public AbstractFolder createSharedFolder(String theFolderName, String theDescription, AbstractFolder theParentFolder, int thePosition, FolderSharedList theAccessList) {
        IFolder newFolder = this.currentDataStore.createSharedFolder(theFolderName, theDescription, theParentFolder.getNativeFolder(), thePosition, theAccessList);
        if (newFolder == null) {
            logger.debug((Object)"shared folder was not created");
            return null;
        }
        AbstractFolder folder = this.getGWFolder(newFolder);
        return folder;
    }

    @Override
    public void sendItem(AbstractItem theNewItem, SendCallback theCallback) throws GWCommandException, UnresolvedAddressException {
        logger.debug((Object)"sendItem entered");
        try {
            IMessage nativeItem = this.prepareItemToSending(theNewItem);
            nativeItem.send(this.currentDataStore.getGroupWiseAccount(), theCallback);
        }
        catch (UnresolvedAddressException e) {
            throw e;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
        logger.debug((Object)"sendItem exited");
    }

    @Override
    public GWBusySearch composeBusySearch(RecipientDescriptionsList recipientDescriptionsList, Date theSearchStartDate, int theDaysCount, TimeInterval theAppointmentTimeInterval) throws GWCommandException {
        if (recipientDescriptionsList == null) {
            throw new IllegalArgumentException("recipientDescriptionsList is null");
        }
        DistributionList distributionList = recipientDescriptionsList.getDistributionList();
        if (!BusySearchUtils.hasValidRecipient(distributionList)) {
            throw new IllegalArgumentException("distributionList has no valid recipients");
        }
        logger.debug((Object)"composeBusySearch entered");
        try {
            GWBusySearch result = new GWBusySearch(this.currentDataStore, theAppointmentTimeInterval.getStartDateAsDate(), theAppointmentTimeInterval.getEndDateAsDate(), recipientDescriptionsList, theSearchStartDate, theDaysCount);
            result.setAppointmentTime(theAppointmentTimeInterval);
            return result;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    @Override
    public void acceptSharedAddressBook(SharedAddressBookNotificationItem theItem) throws GWCommandException {
        try {
            ((ISharedAddressBookNotification)theItem.getNativeItem()).accept(this.currentDataStore.getAddressBookManager());
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    @Override
    public void rejectSharedAddressBook(SharedAddressBookNotificationItem theItem) throws GWCommandException {
        try {
            ((ISharedAddressBookNotification)theItem.getNativeItem()).reject(this.currentDataStore.getAddressBookManager());
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    @Override
    public boolean setSecurityPasswordOptions(String oldPass, String newPass, Boolean useCasa, Boolean rememberPassword) throws GWCommandException {
        logger.debug((Object)"setSecurityPasswordOptions entered");
        logger.debug((Object)("ignore new password = " + (newPass == null)));
        logger.debug((Object)("useCasa = " + useCasa));
        logger.debug((Object)("rememberPassword = " + rememberPassword));
        if (newPass == null && useCasa == null && rememberPassword == null) {
            throw new IllegalArgumentException("");
        }
        try {
            boolean result = this.getDataStoreSettings().setSecurityPasswordOptions(oldPass, newPass, useCasa, rememberPassword);
            logger.debug((Object)("setSecurityPasswordOptions exited with result: " + result));
            return result;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            logger.debug((Object)"setSecurityPasswordOptions exited with exception");
            throw new GWCommandException("Failed to change password", e);
        }
    }

    @Override
    public boolean setSignature(Signature signature, Account account) throws GWCommandException {
        try {
            int res = 0;
            if (signature.isUsedSignature() || signature.isUsedCard()) {
                res = signature.isPromptOnAdd() ? 201 : 1;
            }
            return this.getDataStoreSettings().setSignature(Boolean.valueOf(signature.isUsedSignature()), res, signature.getSignatureText(), Boolean.valueOf(signature.isUsedCard()), signature.getCardFileName(), account);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException(e);
        }
    }

    @Override
    public Signature getSignature(Account account) throws GWCommandException {
        Signature signature = new Signature();
        DataStoreSettings.SignatureOptions so = this.getDataStoreSettings().getSignature(account);
        if (so != null) {
            boolean useSignature = so.isSignatureOn();
            boolean useVCard = so.isVCardOn();
            boolean usePrompt = false;
            if ((useSignature || useVCard) && so.getSignatureStatus() == 201) {
                usePrompt = true;
            }
            signature = new Signature(so.getSignatureText(), useSignature, usePrompt, so.getVCardFileName(), useVCard);
        }
        return signature;
    }

    @Override
    public RuleList getRuleList() {
        return this.currentDataStore.getRuleList();
    }

    @Override
    public final ItemSendOptions getItemSendOptions() throws GWCommandException {
        Notification notification;
        DataStoreSettings settings = this.currentDataStore.getSettings();
        ItemSendOptions itemSendOptions = new ItemSendOptions();
        if (settings == null) {
            return itemSendOptions;
        }
        DataStoreSettings.SendOptionPriority optionPriority = settings.getSendOptionPriority();
        DataStoreSettings.SendOptionSecurity optionSecurity = settings.getSendOptionSecurityClassification();
        DataStoreSettings.SendOptionReplyRequested optionReplyRequest = settings.getSendOptionReplyRequested();
        DataStoreSettings.SendOptionMimeEncoding optionMimeEncoding = settings.getSendOptionMimeEncoding();
        if (optionPriority != null) {
            itemSendOptions.setPriorityLocked(optionPriority.getPriorityLocked());
            itemSendOptions.setPriority(Priority.getPriority(optionPriority.getPriority()));
        }
        if (optionSecurity != null) {
            itemSendOptions.setSecurityLocked(optionSecurity.getSecurityLocked());
            itemSendOptions.setSecurity(Security.getSecurity(optionSecurity.getSecurityLevel()));
        }
        if (optionReplyRequest != null) {
            itemSendOptions.setReplyRequestLocked(optionReplyRequest.isReplyRequestedLocked());
            itemSendOptions.setReplyRequestDay(optionReplyRequest.getReplyWithinDays());
            itemSendOptions.setReplyRequested(optionReplyRequest.isReplyRequested());
            itemSendOptions.setReplyWhenConvenient(optionReplyRequest.isReplyWhenConvenient());
        }
        if (optionMimeEncoding != null) {
            itemSendOptions.setMimeEncodingType(MimeEncoding.getEncoding(optionMimeEncoding.getMimeEncoding()));
            itemSendOptions.setMimeLocked(optionMimeEncoding.isMimeEncodingLocked());
        }
        if ((notification = this.readNotification(ItemType.MAIL, 16384)) != null) {
            itemSendOptions.setRNMailOpened(notification);
        }
        if ((notification = this.readNotification(ItemType.MAIL, 32)) != null) {
            itemSendOptions.setRNMailDeleted(notification);
        }
        if ((notification = this.readNotification(ItemType.APPT, 1)) != null) {
            itemSendOptions.setRNAppAccepted(notification);
        }
        if ((notification = this.readNotification(ItemType.APPT, 32)) != null) {
            itemSendOptions.setRNAppDeclined(notification);
        }
        if ((notification = this.readNotification(ItemType.APPT, 16384)) != null) {
            itemSendOptions.setRNAppOpened(notification);
        }
        if ((notification = this.readNotification(ItemType.TODO, 1)) != null) {
            itemSendOptions.setRNTaskAccepted(notification);
        }
        if ((notification = this.readNotification(ItemType.TODO, 8)) != null) {
            itemSendOptions.setRNTaskCompleted(notification);
        }
        if ((notification = this.readNotification(ItemType.TODO, 32)) != null) {
            itemSendOptions.setRNTaskDeclined(notification);
        }
        if ((notification = this.readNotification(ItemType.TODO, 16384)) != null) {
            itemSendOptions.setRNTaskOpened(notification);
        }
        if ((notification = this.readNotification(ItemType.NOTE, 1)) != null) {
            itemSendOptions.setRNNoteAccepted(notification);
        }
        if ((notification = this.readNotification(ItemType.NOTE, 32)) != null) {
            itemSendOptions.setRNNoteDeclined(notification);
        }
        if ((notification = this.readNotification(ItemType.NOTE, 16384)) != null) {
            itemSendOptions.setRNNoteOpened(notification);
        }
        return itemSendOptions;
    }

    @Override
    public void modifyItemSendOptions(ItemSendOptions itemSendOptions) throws GWCommandException {
        Assertions.assertNotNull(itemSendOptions, "Can't modify items send options to null");
        DataStoreSettings settings = this.currentDataStore.getSettings();
        settings.setSendOptionPriority(itemSendOptions.getPriority().getValue());
        settings.setSendOptionSecurityClassification(itemSendOptions.getSecurity().getValue(), itemSendOptions.getSecurity().toString());
        settings.setSendOptionReplyRequested(itemSendOptions.isReplyRequested(), itemSendOptions.isReplyWhenConvenient(), itemSendOptions.getReplyRequestDay());
        settings.setSendOptionMimeEncoding(itemSendOptions.getMimeEncoding().getValue());
        settings.setSendOptionReturnNotification(ItemType.MAIL.getValue(), new int[]{16384, 32}, new boolean[]{itemSendOptions.getRNMailOpened().isMailNotify(), itemSendOptions.getRNMailDeleted().isMailNotify()}, new boolean[]{itemSendOptions.getRNMailOpened().isNotify(), itemSendOptions.getRNMailDeleted().isNotify()});
        settings.setSendOptionReturnNotification(ItemType.APPT.getValue(), new int[]{16384, 1, 32}, new boolean[]{itemSendOptions.getRNAppOpened().isMailNotify(), itemSendOptions.getRNAppAccepted().isMailNotify(), itemSendOptions.getRNAppDeclined().isMailNotify()}, new boolean[]{itemSendOptions.getRNAppOpened().isNotify(), itemSendOptions.getRNAppAccepted().isNotify(), itemSendOptions.getRNAppDeclined().isNotify()});
        settings.setSendOptionReturnNotification(ItemType.NOTE.getValue(), new int[]{16384, 1, 32}, new boolean[]{itemSendOptions.getRNNoteOpened().isMailNotify(), itemSendOptions.getRNNoteAccepted().isMailNotify(), itemSendOptions.getRNNoteDeclined().isMailNotify()}, new boolean[]{itemSendOptions.getRNNoteOpened().isNotify(), itemSendOptions.getRNNoteAccepted().isNotify(), itemSendOptions.getRNNoteDeclined().isNotify()});
        settings.setSendOptionReturnNotification(ItemType.TODO.getValue(), new int[]{16384, 1, 32, 8}, new boolean[]{itemSendOptions.getRNTaskOpened().isMailNotify(), itemSendOptions.getRNTaskAccepted().isMailNotify(), itemSendOptions.getRNTaskDeclined().isMailNotify(), itemSendOptions.getRNTaskCompleted().isMailNotify()}, new boolean[]{itemSendOptions.getRNTaskOpened().isNotify(), itemSendOptions.getRNTaskAccepted().isNotify(), itemSendOptions.getRNTaskDeclined().isNotify(), itemSendOptions.getRNTaskCompleted().isNotify()});
        settings.setSendOptionDelayDeliverDays(itemSendOptions.getDelayDeliverDays());
        settings.setSendOptionExpireDays(itemSendOptions.getExpireDays());
        settings.setSendOptionNotifyRecipients(itemSendOptions.isNotifyRecipients());
    }

    @Override
    public AbstractItem getEnclosedItem(GWAttachment theAttachment) throws GWCommandException {
        AbstractItem item = null;
        if (theAttachment instanceof GWItemAttachment) {
            GWItemAttachment itemAttachment = (GWItemAttachment)theAttachment;
            item = this.getGWItem(itemAttachment.getMessageAttachment());
        } else if (theAttachment.getNativeAttachment() instanceof IMessageAttachment) {
            IMessage message = ((IMessageAttachment)theAttachment.getNativeAttachment()).getMessage();
            item = this.getGWItem(message);
        }
        IAttachment nativeAttachment = theAttachment.getNativeAttachment();
        if (item != null) {
            item.setDisplayType(nativeAttachment.getDisplayType());
        }
        return item;
    }

    @Override
    public TableItem getTableItem(IItemList itemList, IItem theItem) throws GWCommandException {
        if (theItem instanceof IMessage) {
            return this.getItem(itemList, (IMessage)theItem);
        }
        if (theItem instanceof IFolder) {
            return this.getGWFolder((IFolder)theItem);
        }
        return new UnknownTableItem(theItem);
    }

    @Override
    public AbstractFolder getGWFolder(IFolder theFolder) {
        String folderID = String.valueOf(theFolder.getId());
        if (FoldersCache.containsFolder(folderID, this.currentUserInfo.getGuid()) && !folderID.equals("-1")) {
            return FoldersCache.getFolder(folderID, this.currentUserInfo.getGuid());
        }
        AbstractFolder folder = this.createGWFolder(theFolder);
        if (!folderID.equals("-1")) {
            FoldersCache.addFolder(folder, this.currentUserInfo.getGuid());
        }
        return folder;
    }

    @Override
    public AbstractItem getGWItem(IMessage theMessage) throws GWCommandException {
        int id = theMessage.getId();
        String itemID = String.valueOf(id);
        if (id != 0 && ItemsCache.containsItem(itemID, this.currentUserInfo.getGuid())) {
            AbstractItem item = ItemsCache.getItem(itemID, this.currentUserInfo.getGuid());
            item.clear();
            item.setNativeItem(theMessage);
            if (!ItemListsCache.containsDirty(this.getItemListForItem(item), this.currentUserInfo.getGuid())) {
                item.setProcessing(false);
            }
            return item;
        }
        AbstractItem item = GWItemFactory.gwObjectToItem(theMessage);
        ItemsCache.putItem(item, this.currentUserInfo.getGuid());
        return item;
    }

    @Override
    public AbstractItem getItem(IItemList itemList, IMessage message) throws GWCommandException {
        String itemID;
        int id = message.getId();
        if (id == 0) {
            id = message.getUID();
        }
        if ((itemID = String.valueOf(id)).equals("0")) {
            logger.warn((Object)"!!!!!      Item ID == 0        !!!!!");
        }
        if (ItemsCache.containsItem(itemID, this.currentUserInfo.getGuid())) {
            AbstractItem item = ItemsCache.getItem(itemID, this.currentUserInfo.getGuid());
            item.clear();
            item.setNativeItem(message);
            if (!ItemListsCache.containsDirty(itemList, this.currentUserInfo.getGuid())) {
                item.setProcessing(false);
            }
            return item;
        }
        AbstractItem item = GWItemFactory.gwObjectToItem(message);
        ItemsCache.putItem(item, this.currentUserInfo.getGuid());
        return item;
    }

    @Override
    public AbstractItem find(String theGID) throws GWCommandException {
        IItem item = this.currentDataStore.findItem(theGID);
        if (item == null) {
            return null;
        }
        if (item instanceof IMessage) {
            return this.getGWItem((IMessage)item);
        }
        logger.warn((Object)("Invalid object found using GID: [" + theGID + "]. Object: [" + item + ']'));
        return null;
    }

    @Override
    public boolean setArchiveLocation(String archiveLocation) {
        return this.currentDataStore.getSettings().setArchivePath(archiveLocation);
    }

    @Override
    public String getArchiveLocation() {
        if (this.currentDataStore.getSettings() == null) {
            return null;
        }
        return this.currentDataStore.getSettings().getArchivePath();
    }

    private static void clearStatics() {
        OptionManager.clearOptions();
    }

    @Override
    public String performProxy(ProxyHistoryEntry theHistoryEntry) throws EngineException {
        String currentGuid = this.currentUserInfo.getGuid();
        String histGuid = theHistoryEntry.getGuid();
        String newUserGuid = currentGuid != null && currentGuid.equals(histGuid) ? currentGuid : this.switchDataStore(engine.getProxyDataStore(theHistoryEntry));
        return newUserGuid;
    }

    private String switchDataStore(IDataStore dataStore) {
        EngineCommandManager.clearStatics();
        String newUserGuid = dataStore.isArchiveDB() ? ARCHIVE_DATA_STORE : (dataStore.isBackupDB() ? BACKUP_DATA_STORE : dataStore.getUserFields().getGuid());
        GWCommandManager.removeFrameRef(this.currentUserInfo.getGuid());
        GWCommandManager.addFrameRef(newUserGuid);
        if (instances.get(newUserGuid) == null) {
            instances.put(newUserGuid, new EngineCommandManager(dataStore));
        }
        return newUserGuid;
    }

    @Override
    public String switchToUserMode() {
        String userGuid = this.switchDataStore(userDataStore);
        return userGuid;
    }

    @Override
    public String switchToArchiveMode() throws GWCommandException {
        String path = this.getArchiveLocation();
        if (!Utils.fileExists(path)) {
            throw new GWCommandException("Archive folder : [" + path + "] can does not exists");
        }
        IDataStore tempDataStore = this.currentDataStore.openArchiveDB(true);
        if (tempDataStore == null || !tempDataStore.isArchiveDB()) {
            throw new GWCommandException("Engine failed to switch into Archive mode");
        }
        String userGuid = this.switchDataStore(tempDataStore);
        this.isProxyDataStore = false;
        return userGuid;
    }

    @Override
    public void switchOnlineDataStore() {
        this.currentDataStore = userDataStore;
        this.currentUserInfo = userInfo;
        this.isProxyDataStore = false;
    }

    @Override
    public boolean isArchive() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isArchiveDB();
    }

    @Override
    public boolean isOnlineDataStore() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isOnline();
    }

    @Override
    public boolean isCachingDataStore() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isCaching();
    }

    @Override
    public boolean archiveItems(List<AbstractItem> items) throws GWCommandException {
        if (!this.isArchive() && !Utils.checkArchivePath(this.currentUserInfo.getGuid())) {
            return false;
        }
        for (AbstractItem item : items) {
            try {
                if (!item.canArchive()) continue;
                item.getNativeItem().archive();
            }
            catch (EngineException e) {
                logger.error((Object)e, (Throwable)e);
                throw new GWCommandException("Engine error.", "Can't archive message. " + (Object)((Object)e), e);
            }
        }
        return true;
    }

    public static String getGWAPIJarVersion() {
        return engine.getGWAPIJarVersion();
    }

    public static boolean canSwitchCaching() {
        return engine.canSwitchMode(EngineMode.CACHING);
    }

    public static boolean canSwitchOnline() {
        return engine.canSwitchMode(EngineMode.ONLINE);
    }

    @Override
    public void syncDataStore() {
        logger.debug((Object)"syncDataStore entered");
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
            this.currentDataStore.sync();
        }
        logger.debug((Object)"syncDataStore exited");
    }

    @Override
    public void postItem(AbstractItem theItem, SendCallback theCallback, IDataStore dataStore) throws GWCommandException {
        logger.debug((Object)"postItem entered");
        IMessage nativeItem = this.prepareItemToSending(theItem);
        if (dataStore == null) {
            dataStore = this.getCurrentDataStore();
        }
        nativeItem.setSendingDataStore(dataStore);
        try {
            nativeItem.post(dataStore.getGroupWiseAccount(), theCallback);
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
        logger.debug((Object)"postItem exited");
    }

    private IMessage prepareItemToSending(AbstractItem theNewItem) {
        IMessage nativeItem = EngineCommandManager.setTextToNativeItem(theNewItem, false);
        theNewItem.setProcessing(true);
        ItemListsCache.addDirty(this.getItemListForItem(theNewItem), this.currentUserInfo.getGuid());
        EngineCommandManager.prepareNativeItem(theNewItem, nativeItem);
        return nativeItem;
    }

    public static void prepareNativeItem(AbstractItem theNewItem, IMessage nativeItem) {
        EngineCommandManager.setDistributionList(theNewItem, nativeItem);
        if (nativeItem instanceof IAppointment) {
            AppointmentItem appointmentItem = (AppointmentItem)theNewItem;
            IAppointment appointment = (IAppointment)nativeItem;
            EngineCommandManager.prepareAppointment(appointment, appointmentItem);
        } else if (nativeItem instanceof ITask) {
            TaskItem taskItem = (TaskItem)theNewItem;
            ITask task = (ITask)nativeItem;
            EngineCommandManager.prepareTask(taskItem, task);
        } else if (nativeItem instanceof INote) {
            ReminderNote reminderNote = (ReminderNote)theNewItem;
            INote note = (INote)nativeItem;
            EngineCommandManager.prepareNote(reminderNote, note);
        } else if (nativeItem instanceof IPhoneMessage) {
            // empty if block
        }
    }

    public static IMessage setTextToNativeItem(AbstractItem theNewItem, boolean forAutoSave) {
        MessageBody message = theNewItem.getMessage();
        Object nativeItem = theNewItem.getNativeItem();
        String messageText = message.getMessage();
        if (!"".equals(messageText)) {
            if (forAutoSave) {
                nativeItem.setBodyTextForAutoSave(messageText);
            } else {
                nativeItem.setBodyTextForSend(messageText);
            }
        }
        return nativeItem;
    }

    private static void prepareNote(ReminderNote theReminderNote, INote theNote) {
        theNote.setAutoDate(theReminderNote.getStartDates(), 0L);
    }

    private static void prepareTask(TaskItem taskItem, ITask task) {
        logger.debug((Object)":: prepareTask entered");
        logger.debug((Object)(":: task start date: [" + taskItem.getStartDate() + ']'));
        logger.debug((Object)(":: task end date: [" + taskItem.getEndDate() + ']'));
        Date[] startDates = taskItem.getStartDates();
        if (startDates.length == 1) {
            task.setAutoDate(startDates, 0L);
            task.setDueDate(taskItem.getEndDate());
        } else {
            long duration = taskItem.getDuration() / 1000L;
            logger.debug((Object)("duration (in seconds): " + duration));
            task.setAutoDate(startDates, duration);
        }
        logger.debug((Object)(":: native task date: [" + task.getDate() + ']'));
        logger.debug((Object)":: prepareTask exited");
    }

    private static void prepareAppointment(IAppointment theAppointment, AppointmentItem theAppointmentItem) {
        logger.debug((Object)":: prepareAppointment entered");
        theAppointment.setPlace(theAppointmentItem.getLocation());
        Date[] startDates = theAppointmentItem.getStartDates();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(":: appointment start dates: [" + startDates + ']'));
            logger.debug((Object)(":: appointment start date0: [" + startDates[0] + ']'));
            logger.debug((Object)(":: appointment end date (it is not set to native appintment): " + theAppointmentItem.getEndDate()));
            logger.debug((Object)(":: appointment duration, ms: " + theAppointmentItem.getDuration()));
        }
        long duration = EngineUtils.timeToFlaimTime((long)theAppointmentItem.getDuration());
        theAppointment.setAutoDate(startDates, duration);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(":: native appointment date: " + theAppointment.getDate()));
            logger.debug((Object)(":: native appointment end date: " + theAppointment.getEndDate()));
            logger.debug((Object)(":: native appointment duration, s: " + theAppointment.getDuration()));
            logger.debug((Object)":: prepareAppointment exited");
        }
    }

    private static void setDistributionList(AbstractItem theNewItem, IMessage theNativeItem) {
        DistributionList newDistributionList = new DistributionList();
        List<IRecipient> recipientsList = theNewItem.getRecipientsList();
        int nSize = recipientsList.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = recipientsList.get(i);
            newDistributionList.addRecipient(recipient.getNativeRecipient());
        }
        theNativeItem.setDistributionList(newDistributionList);
    }

    @Override
    public void modifyItem(AbstractItem theItem, SendCallback theCallback) throws UnresolvedAddressException {
        logger.debug((Object)"modifyItem entered");
        IMessage nativeItem = this.prepareItemToSending(theItem);
        nativeItem.setDistributionList(null);
        try {
            nativeItem.modify(theCallback);
        }
        catch (UnresolvedAddressException e) {
            throw e;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
        }
        logger.debug((Object)"modifyItem exited");
    }

    public static AbstractAddressBook getContactsFolderAddressBook() {
        com.novell.gw.ab.PersonalAddressBook addressBook = ((IContactsFolder)userDataStore.getSystemFolder(FolderType.CONTACTS)).getAddressBook(userDataStore.getAddressBookManager());
        if (addressBook != null) {
            return AddressBookItemsFactory.createAddressBook((AddressBook)addressBook);
        }
        return null;
    }

    public static AbstractAddressBook getContactsFolderAddressBook(IPanelDisplaySettings ds) {
        IFolder nativeFolder = ds.getPanelAddressBookFolder();
        if (nativeFolder == null) {
            throw new IllegalArgumentException("address book folder is null");
        }
        AddressBookManager addressBookManager = EngineCommandManager.getAddressBookManager();
        com.novell.gw.ab.PersonalAddressBook addressBook = ((IContactsFolder)nativeFolder).getAddressBook(addressBookManager);
        if (addressBook != null) {
            return AddressBookItemsFactory.createAddressBook((AddressBook)addressBook);
        }
        return null;
    }

    public static AbstractAddressBook getContactAddressBook(IContact contact) {
        AddressBook addressBook = userDataStore.getAddressBookManager().getAddressBook(contact.getNativeContact().getBookId());
        return AddressBookItemsFactory.createAddressBook(addressBook);
    }

    public static AbstractAddressBook getAddressBook(String ID) {
        AddressBook addressBook = userDataStore.getAddressBookManager().getAddressBook(Integer.parseInt(ID));
        return AddressBookItemsFactory.createAddressBook(addressBook);
    }

    public static List<AbstractAddressBook> getEditableAddressBooks() {
        ArrayList<AbstractAddressBook> editableAddressBooks = new ArrayList<AbstractAddressBook>();
        for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
            if (addressBook == null || addressBook.isReadOnly()) continue;
            editableAddressBooks.add(addressBook);
        }
        return editableAddressBooks;
    }

    @Override
    public void setCachingPath(String thePath) {
        engine.setPathToCache(thePath);
    }

    public static AddressBookManager getAddressBookManager() {
        AddressBookManager manager = userDataStore.getAddressBookManager();
        if (manager == null) {
            throw new NullPointerException("address book manager obtained from data store is null");
        }
        return manager;
    }

    public static EngineCallBackListener getCallBackListener() {
        return callback;
    }

    @Override
    public AbstractItem getNextItem(IItemList itemList, AbstractItem item) {
        int size;
        if (itemList == null) {
            return null;
        }
        Object nativeItem = item.getNativeItem();
        int index = itemList.indexOf((IItem)nativeItem);
        if (index < 0) {
            index = EngineCommandManager.getIndexForItem(itemList, nativeItem);
        }
        if (index >= (size = itemList.getSize()) - 1 || index < 0) {
            return null;
        }
        while (index < size - 1) {
            IItem nativeNextItem;
            if ((nativeNextItem = itemList.getItemAt(++index)) instanceof IGroupHeader || nativeNextItem instanceof IFolder) continue;
            return this.getItemAt(itemList, index);
        }
        return null;
    }

    private static int getIndexForItem(IItemList itemList, IItem nativeItem) {
        for (int i = 0; i < itemList.getSize(); ++i) {
            IItem item = itemList.getItemAt(i);
            if (!item.equals(nativeItem) && item.getId() != nativeItem.getId()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractItem getPrevItem(IItemList itemList, AbstractItem item) {
        if (itemList == null) {
            return null;
        }
        Object nativeItem = item.getNativeItem();
        int index = itemList.indexOf((IItem)nativeItem);
        if (index <= 0 || index > itemList.getSize() - 1) {
            return null;
        }
        while (index > 0) {
            IItem nativeNextItem;
            if ((nativeNextItem = itemList.getItemAt(--index)) instanceof IGroupHeader || nativeNextItem instanceof IFolder) continue;
            return this.getItemAt(itemList, index);
        }
        return null;
    }

    private AbstractItem getItemAt(IItemList itemList, int theIndex) {
        IItem resultItem = itemList.getItemAt(theIndex);
        try {
            TableItem tableItem = this.getTableItem(itemList, resultItem);
            if (tableItem instanceof AbstractItem) {
                return (AbstractItem)tableItem;
            }
        }
        catch (GWCommandException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    private void replaceExistingSubfolders(IDataStore dataStore, String folderName) {
        IFolder[] folders;
        for (IFolder folder : folders = dataStore.getCalendarFolders()) {
            if (!folder.getName().equals(folderName)) continue;
            folder.deleteItems();
            break;
        }
    }

    public void importCalendar(String filepath, String calendarName, String calendarDescription, boolean replaceExisting) {
        IDataStore dataStore = this.getCurrentDataStore();
        if (calendarName != null && calendarName.length() > 0) {
            if (!dataStore.isCalendarFolderNameAlreadyExist(calendarName)) {
                dataStore.importIcalFile(filepath, calendarName, calendarDescription, true);
            } else {
                if (replaceExisting) {
                    this.replaceExistingSubfolders(dataStore, calendarName);
                }
                dataStore.importIcalFile(filepath, calendarName, calendarDescription, false);
            }
        }
    }

    @Override
    @Deprecated
    public IItemList getItemListForItem(AbstractItem theItem) {
        Object nativeItem = theItem.getNativeItem();
        AbstractFolder theFolder = this.getGWFolder(nativeItem.getViewFolder());
        IItemList list = theFolder.getItemList();
        return list;
    }

    public static AccountSettings getAccountSettings() {
        return userDataStore.getAccountSettings();
    }

    public static Account[] getAccounts() {
        return userDataStore.getAccounts();
    }

    public static Account[] getMailAccounts() {
        ArrayList<Account> mailAccounts = new ArrayList<Account>();
        for (Account account : userDataStore.getAccounts()) {
            int type = account.getType();
            if (type != 2 && type != 1 && type != 3) continue;
            mailAccounts.add(account);
        }
        return mailAccounts.toArray(new Account[mailAccounts.size()]);
    }

    public static Account[] getNewsAccounts() {
        ArrayList<Account> newsAccounts = new ArrayList<Account>();
        for (Account account : userDataStore.getAccounts()) {
            if (account.getType() != 4) continue;
            newsAccounts.add(account);
        }
        return newsAccounts.toArray(new Account[newsAccounts.size()]);
    }

    private Notification readNotification(ItemType itemType, int status) {
        DataStoreSettings.SendOptionNotification on = null;
        DataStoreSettings settings = this.currentDataStore.getSettings();
        if (settings != null) {
            on = settings.getSendOptionReturnNotification(itemType.getValue(), status);
        }
        return Notification.getNotification(on);
    }

    @Override
    public ProxyAccessList getProxyAccessList() {
        return this.currentDataStore.getProxyAccessList();
    }

    public static ProxyHistoryList getProxyHistoryList() {
        return userDataStore.getProxyHistoryList();
    }

    @Override
    public NotifySubscribeList getNotifySubscribeList() {
        return userDataStore.getNotifySubscribeList();
    }

    public static void relogin() throws EngineException, GWCommandException {
        IDataStore reloginDataStore = engine.relogin();
        if (reloginDataStore == null) {
            throw new GWCommandException("Engine failed to relogin");
        }
        userDataStore = reloginDataStore;
        userInfo = EngineCommandManager.createUserInfo(userDataStore);
        instances.put(userInfo.getGuid(), new EngineCommandManager(userDataStore));
    }

    public static void setOnlinePassword(String theOldPass, String theNewPass) {
        logger.debug((Object)"changeOnlinePassword entered");
        userDataStore.setOnlineMailboxPassword(theOldPass, theNewPass);
        userInfo.setPassword("");
        logger.debug((Object)"changeOnlinePassword exited");
    }

    @Override
    public AbstractItem composeNewItem(Class theClass) throws GWCommandException {
        return this.composeNewItem(theClass, false, null);
    }

    @Override
    public AbstractItem composeNewItem(Class theItemClass, boolean posted, AbstractFolder theFolder) throws GWCommandException {
        AbstractItem resultItem = null;
        IMessage nativeItem = null;
        try {
            if (AppointmentItem.class.equals((Object)theItemClass)) {
                nativeItem = theFolder == null ? APIMessageWrapperManager.createAppointment(this.currentDataStore) : APIMessageWrapperManager.createAppointment(this.currentDataStore, theFolder.getNativeFolder());
                MessageUtils.prepareNewAppointment(nativeItem);
                resultItem = GWItemFactory.gwObjectToItem(nativeItem);
            } else if (ReminderNote.class.equals((Object)theItemClass)) {
                nativeItem = theFolder == null ? APIMessageWrapperManager.createNote(this.currentDataStore) : APIMessageWrapperManager.createNote(this.currentDataStore, theFolder.getNativeFolder());
                resultItem = new ReminderNote((INote)nativeItem);
            } else if (TaskItem.class.equals((Object)theItemClass)) {
                nativeItem = theFolder == null ? APIMessageWrapperManager.createTask(this.currentDataStore) : APIMessageWrapperManager.createTask(this.currentDataStore, theFolder.getNativeFolder());
                resultItem = new TaskItem((ITask)nativeItem);
            } else if (DocumentItem.class.equals((Object)theItemClass)) {
                nativeItem = APIMessageWrapperManager.createDocumentReference(this.currentDataStore);
                resultItem = new DocumentItem((IDocumentReference)nativeItem);
            } else if (MailItem.class.equals((Object)theItemClass)) {
                nativeItem = theFolder == null ? APIMessageWrapperManager.createMail(this.currentDataStore) : APIMessageWrapperManager.createMail(this.currentDataStore, theFolder.getNativeFolder());
                resultItem = new MailItem((IMail)nativeItem);
            } else if (PhoneItem.class.equals((Object)theItemClass)) {
                nativeItem = theFolder == null ? APIMessageWrapperManager.createPhoneMessage(this.currentDataStore) : APIMessageWrapperManager.createPhoneMessage(this.currentDataStore, theFolder.getNativeFolder());
                resultItem = new PhoneItem((IPhoneMessage)nativeItem);
            } else {
                throw new GWCommandException("Operation for given object type [" + theItemClass.getName() + "]is not supported");
            }
            nativeItem.setPostedViewName(posted);
        }
        catch (EngineException e) {
            if (e.getErrorCode() == 53343) {
                logger.warn((Object)"new item NOT created - storage limit reached");
                throw new ItemNotCreatedException(e);
            }
            throw new GWCommandException(e);
        }
        return resultItem;
    }

    @Override
    public QueryFolder find(ItemListFilter filter) {
        return (QueryFolder)this.createGWFolder(this.currentDataStore.find(filter));
    }

    public static boolean canExit() {
        return engine.canDispose();
    }

    @Override
    public AbstractItem getNextUnreadItem(IItemList itemList, AbstractItem theItem) {
        Object nativeItem = theItem.getNativeItem();
        int index = itemList.indexOf((IItem)nativeItem);
        int nSize = itemList.getSize();
        for (int i = ++index; i < nSize; ++i) {
            IMessage message;
            IItem item = itemList.getItemAt(i);
            if (!(item instanceof IMessage) || GWItemFactory.isMessageRead(message = (IMessage)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    @Override
    public AbstractItem getPrevUnreadItem(IItemList itemList, AbstractItem theItem) {
        Object nativeItem = theItem.getNativeItem();
        int index = itemList.indexOf((IItem)nativeItem);
        for (int i = --index; i >= 0; --i) {
            IMessage message;
            IItem item = itemList.getItemAt(i);
            if (!(item instanceof IMessage) || GWItemFactory.isMessageRead(message = (IMessage)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    @Override
    public TableItem getFirstItem(IItemListComponentDataModel dataModel) {
        AbstractFolder folder = dataModel.getAbstractFolder();
        boolean isQuickViewerVisible = this.getAppearanceSettings().isQuickViewerVisible() || folder.getDisplaySettings().isQuickViewerVisible();
        boolean selectUnred = folder.isSelectFirstUnreadItemState();
        IItemList itemList = dataModel.getItemList();
        if (itemList == null) {
            return null;
        }
        int index = -1;
        if (selectUnred) {
            index = itemList.getFirstUnreadItemIndex(isQuickViewerVisible);
        }
        int size = itemList.getSize();
        if (index < 0 || index >= size) {
            index = 0;
        }
        try {
            IItem item = null;
            while (index >= 0 && index < size && !((item = itemList.getItemAt(index)) instanceof IMessage)) {
                ++index;
            }
            logger.debug((Object)("index: " + index));
            logger.debug((Object)("size: " + size));
            if (item != null) {
                return this.getTableItem(itemList, item);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    @Override
    public AbstractItem getLastUnreadItem(IItemList itemList) {
        for (int i = itemList.getSize() - 1; i >= 0; --i) {
            IMessage message;
            IItem item = itemList.getItemAt(i);
            if (!(item instanceof IMessage) || GWItemFactory.isMessageRead(message = (IMessage)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    public static void setNCCSearchOrder(AddressBook[] theAddressBooks) {
        userDataStore.getAddressBookManager().setSearchOrder(theAddressBooks);
    }

    public static AddressBook[] getNCCSearchOrder() {
        return userDataStore.getAddressBookManager().getSearchOrder();
    }

    @Override
    public boolean isProxyDataStore() {
        return this.isProxyDataStore;
    }

    @Override
    public void saveDraft(AbstractItem theItem, String where, SendCallback theCallback) throws UnresolvedAddressException {
        IMessage nativeItem = this.prepareItemToSending(theItem);
        nativeItem.saveDraft(where, theCallback);
        theItem.setSaved(true);
    }

    @Override
    public String getProxyUserName() {
        String name = this.currentDataStore.getUserFullName();
        if (name == null || "".equals(name)) {
            name = this.currentDataStore.getUserId();
        }
        return name;
    }

    @Override
    public IDataStore getCurrentDataStore() {
        return this.currentDataStore;
    }

    @Override
    public boolean isJunkMailMasterEnabled() {
        return this.currentDataStore.getJunkMail().isJunkMailMasterEnabled();
    }

    @Override
    public JunkMailSettings getJunkMailSettings() {
        return this.currentDataStore.getJunkMail().getSettings();
    }

    @Override
    public JunkMailListManager getJunkMailListManager() throws EngineException {
        return this.currentDataStore.getJunkMail().getListManager();
    }

    @Override
    public void setJunkMailSettings(JunkMailSettings theSettings) throws GWCommandException {
        try {
            this.currentDataStore.getJunkMail().setSettings(theSettings);
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    @Override
    public Rule createRule() {
        return new Rule(this.currentDataStore.getNativeDataStore());
    }

    public static String getResourceString(int key) {
        return engine.getResourceString(key);
    }

    @Override
    public boolean performBackupOnDB(boolean forceBackup, boolean exiting) {
        return this.currentDataStore.performBackupOnDB(forceBackup, exiting);
    }

    @Override
    public String openBackupDB() throws GWCommandException {
        if (instances.get(BACKUP_DATA_STORE) == null) {
            IDataStore dataStore = this.currentDataStore.openBackupDB();
            if (dataStore != null) {
                return this.switchDataStore(dataStore);
            }
            throw new GWCommandException("Engine failed to switch into backup mode");
        }
        return this.switchDataStore(((EngineCommandManager)EngineCommandManager.instances.get((Object)BACKUP_DATA_STORE)).currentDataStore);
    }

    @Override
    public boolean isBackupDB() {
        return this.currentDataStore.isBackupDB();
    }

    @Override
    public DataStoreSettings getDataStoreSettings() {
        return this.currentDataStore.getSettings();
    }

    @Override
    public Enumeration getDisplaySettingsEnumeration(DataStoreDisplaySettingsSubtype subType) {
        if (this.isProxyDataStore) {
            return userDataStore.getDisplaySettingsEnumeration(subType);
        }
        return this.currentDataStore.getDisplaySettingsEnumeration(subType);
    }

    @Override
    public Filter createRuleFilter() {
        return new Filter(this.currentDataStore.getNativeDataStore(), true);
    }

    @Override
    public AbstractFolder findFolderInCurrentDataStore(AbstractFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (folder instanceof QueryFolder || folder instanceof ContactsFolder) {
            return folder;
        }
        IFolder result = userDataStore.findFolder(folder.getNativeFolder(), this.isProxyDataStore ? userDataStore : this.currentDataStore);
        return this.getGWFolder(result);
    }

    @Override
    public GWSecurityPasswordOptions getSecurityPasswordOptions() {
        DataStoreSettings.SecurityPasswordOptions nativeOptions = this.currentDataStore.getSettings().getSecurityPasswordOptions();
        GWSecurityPasswordOptions options = new GWSecurityPasswordOptions(nativeOptions.isCASASSOAvailable(), nativeOptions.isCASASSOSet(), nativeOptions.isRememberPasswordSet());
        logger.debug((Object)("options = " + options));
        return options;
    }

    @Override
    public boolean canClearPassword() {
        return this.currentDataStore.getSettings().canClearPassword();
    }

    @Override
    public boolean clearPassword(String currentPassword) throws GWCommandException {
        boolean result = false;
        try {
            result = this.currentDataStore.getSettings().clearPassword(currentPassword);
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
        return result;
    }

    @Override
    public boolean validatePassword(String password) {
        return this.currentDataStore.getSettings().validatePassword(password);
    }

    @Override
    public boolean validateOnlineMailboxPassword(String password) {
        if (!this.currentDataStore.isCaching()) {
            throw new IllegalStateException("DataStore is not in caching mode");
        }
        return this.currentDataStore.validateOnlineMailboxPassword(password);
    }

    @Override
    public boolean isPasswordSet() {
        return this.currentDataStore.getSettings().isPasswordSet();
    }

    @Override
    public List<IPanelDisplaySettings> getNativePanelTemplateSettings() {
        int nCount = this.currentDataStore.getPanelTemplateSettingsCount();
        ArrayList<IPanelDisplaySettings> templateSettings = new ArrayList<IPanelDisplaySettings>(nCount);
        for (int i = 0; i < nCount; ++i) {
            templateSettings.add(this.currentDataStore.getPanelTemplateSettings(i));
        }
        return templateSettings;
    }

    @Override
    public final List<String> getPanelTemplateNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IPanelDisplaySettings settings : this.getNativePanelTemplateSettings()) {
            names.add(settings.getPanelName());
        }
        return names;
    }

    @Override
    public IDataStore getProxyDataStore(ProxyHistoryEntry proxyHistoryEntry) throws EngineException {
        return engine.getProxyDataStore(proxyHistoryEntry);
    }

    @Override
    public void sendItem(AbstractItem newItem, Account account, IDataStore dataStore, SendCallback callback) throws GWCommandException, UnresolvedAddressException {
        if (newItem == null) {
            throw new IllegalArgumentException("newItem is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        logger.debug((Object)"sendItem entered");
        try {
            IMessage nativeItem = this.prepareItemToSending(newItem);
            nativeItem.setSendingDataStore(dataStore);
            nativeItem.send(account, CallbackManager.getInstance().createCallbackProxy(callback));
        }
        catch (UnresolvedAddressException e) {
            throw e;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
        logger.debug((Object)"sendItem exited");
    }

    @Override
    public AppearanceSettings getAppearanceSettings() {
        return new AppearanceSettings(this);
    }

    @Override
    public boolean canUsePopAndImapAccounts() {
        return userDataStore.isCaching() || userDataStore.isOnline() && userDataStore.canDoPopAndImapAccounts();
    }

    public static Account getUserGroupWiseAccount() {
        return userDataStore.getGroupWiseAccount();
    }

    static {
        foldersChangeListener = new FoldersChangeListener();
    }
}

