/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.AddressBookSharedList;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.MessageSuggestedBodyFormat;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.folder.IJunkMailFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.ISuggestedBody;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CabinetFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.ImapFolder;
import com.novell.gw.jclient.bl.om.folders.JunkMailFolder;
import com.novell.gw.jclient.bl.om.folders.NntpFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.folders.NormalFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.RSSFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SharedFolder;
import com.novell.gw.jclient.bl.om.folders.SharedRefFolder;
import com.novell.gw.jclient.bl.om.folders.SharedRefSubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SharedSubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UniversalFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import com.novell.gw.jclient.bl.om.folders.WorkinProgressFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWEngineUtils {
    private static Logger logger = Logger.getLogger(GWEngineUtils.class);

    public static long EngineTimeAttrToNormal(Object theTimeAttribute) {
        try {
            return EngineUtils.flaimTimeToTime((long)((Long)theTimeAttribute));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static Class getFolderClass(IFolder folder) {
        Class result;
        FolderType folderType = folder.getType();
        if (folder.isSharedFolder()) {
            if (folder.isCalendarChildFolder()) {
                return SharedSubCalendarFolder.class;
            }
            if (!folder.getType().equals((Object)FolderType.UNIVERSAL)) {
                return SharedFolder.class;
            }
        } else {
            if (folder.isSharedFolderReference()) {
                if (folder.isCalendarChildFolder()) {
                    return SharedRefSubCalendarFolder.class;
                }
                return SharedRefFolder.class;
            }
            if (folder instanceof IJunkMailFolder) {
                return JunkMailFolder.class;
            }
            if (folder.isCalendarChildFolder()) {
                return SubCalendarFolder.class;
            }
            if (folder.isContactsFolder()) {
                return ContactsFolder.class;
            }
            if (folder.isRssRootFolder() || folder.isRssAggregatorFolder() || folder.isRssSubscribeFolder()) {
                return RSSFolder.class;
            }
        }
        switch (folderType) {
            case NORMAL: {
                result = NormalFolder.class;
                break;
            }
            case QUERY: {
                result = QueryFolder.class;
                break;
            }
            case USER: {
                result = UserFolder.class;
                break;
            }
            case UNIVERSAL: {
                result = UniversalFolder.class;
                break;
            }
            case TRASH: {
                result = TrashFolder.class;
                break;
            }
            case CALENDAR: {
                result = CalendarFolder.class;
                break;
            }
            case CABINET: {
                result = CabinetFolder.class;
                break;
            }
            case WORK_IN_PROGRESS: {
                result = WorkinProgressFolder.class;
                break;
            }
            case DOCUMENTS: {
                result = DocumentFolder.class;
                break;
            }
            case OUTBOX: {
                result = SentItemsFolder.class;
                break;
            }
            case CHECKLIST: {
                result = CheckListFolder.class;
                break;
            }
            case CONTACTS: {
                result = ContactsFolder.class;
                break;
            }
            case NNTP_SERVER: {
                result = NntpFolder.class;
                break;
            }
            case IMAP: {
                result = ImapFolder.class;
                break;
            }
            case NNTP_NEWSGROUP: {
                result = NntpSubFolder.class;
                break;
            }
            default: {
                logger.info((Object)("ERROR!!!  UNKNOWN FOLDER TYPE: " + (Object)((Object)folderType) + ", UNKNOWN_FOLDER_NAME: '" + folder.getName() + "'"));
                result = NormalFolder.class;
            }
        }
        return result;
    }

    public static IItem[] getMessagesFromGWItems(List<TableItem> tableItems) {
        ArrayList<IItem> list = new ArrayList<IItem>(tableItems.size());
        for (TableItem tableItem : tableItems) {
            if (tableItem == null) continue;
            list.add(tableItem.getNativeObject());
        }
        return list.toArray(new IItem[list.size()]);
    }

    public static Filter createFilter(ItemListFilter itemListFilter, IDataStore dataStore) {
        if (itemListFilter == null) {
            throw new IllegalArgumentException("itemListFilter is null");
        }
        if (dataStore == null) {
            throw new IllegalArgumentException("dataStore is null");
        }
        AbstractFilter filter = null;
        if (itemListFilter.canShowAsSimple(dataStore.getNativeDataStore())) {
            logger.debug((Object)"CustomFilter");
            filter = new CustomFilter(itemListFilter.getFromText(), itemListFilter.getToCcText(), itemListFilter.getSubjectText(), itemListFilter.getMessage(), APIWrapperManager.getCategoryList(itemListFilter.getCategories(dataStore.getNativeDataStore())));
        } else {
            logger.debug((Object)"AdvancedFilter");
            filter = new AdvancedFilter(itemListFilter);
        }
        return filter;
    }

    public static void restoreItems(IItemList itemList) {
        if (itemList != null) {
            itemList.restoreSelectedItems();
        }
    }

    public static void deleteSentItem(IItemList itemList, AbstractItem item, int thePromptRetractMode) {
        if (item != null && itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(thePromptRetractMode);
            itemList.deleteItem((IItem)item.getNativeItem());
        }
    }

    public static void deleteSentItems(IItemList itemList, int promptRetractMode) {
        if (itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(promptRetractMode);
            itemList.deleteSelectedItems();
        }
    }

    public static boolean isItemsSent(List<AbstractItem> items) {
        for (AbstractItem item : items) {
            if (item.isSentItem()) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteItem(IItemList itemList, AbstractItem item) {
        if (item != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(-1);
            if (itemList != null) {
                return itemList.deleteItem((IItem)item.getNativeItem());
            }
            return item.getNativeItem().delete();
        }
        return false;
    }

    public static boolean deleteItems(IItemList itemList) {
        if (itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(-1);
            return itemList.deleteSelectedItems();
        }
        return false;
    }

    public static void emptyItem(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            itemList.purgeItem((IItem)item.getNativeItem());
        }
    }

    public static void emptyItems(IItemList itemList) {
        if (itemList != null) {
            itemList.purgeSelectedItems();
        }
    }

    public static boolean deleteAndEmptyFolder(IItemList itemList, AbstractFolder folder) {
        if (folder != null && itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(-1);
            return itemList.deleteAndEmptyItem(folder.getNativeFolder());
        }
        return false;
    }

    public static boolean deleteAndEmptyItem(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(-1);
            return itemList.deleteAndEmptyItem((IItem)item.getNativeItem());
        }
        return false;
    }

    public static boolean deleteAndEmptyItems(IItemList itemList) {
        if (itemList != null) {
            EngineCommandManager.getCallBackListener().setPromtRetractMode(-1);
            return itemList.deleteAndEmptySelectedItems();
        }
        return false;
    }

    public static void undeleteItem(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            itemList.undeleteItem((IItem)item.getNativeItem());
        }
    }

    public static void undeleteItems(IItemList itemList) {
        if (itemList != null) {
            itemList.undeleteSelectedItems();
        }
    }

    public static void markReadLater(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            itemList.markItemReadLater((IItem)item.getNativeItem());
        }
    }

    public static void markReadLater(IItemList itemList) {
        if (itemList != null) {
            itemList.markSelectedItemsReadLater();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void markItemsRead(IItemList itemList) {
        if (itemList != null) {
            long time = new Date().getTime();
            itemList.markSelectedItemsRead();
            long time2 = new Date().getTime();
            logger.debug((Object)("MARK READ OPERATION TAKEN            " + (time2 - time) / 1000L + " SECONDS"));
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static void markItemRead(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            itemList.markItemRead((IItem)item.getNativeItem());
        }
    }

    public static void markItemPrivate(IItemList itemList, AbstractItem item) {
        if (item != null && itemList != null) {
            itemList.markItemPrivate((IItem)item.getNativeItem());
        }
    }

    public static void markItemsPrivate(IItemList itemList) {
        if (itemList != null) {
            itemList.markSelectedItemsPrivate();
        }
    }

    public static boolean isItemsPrivate(List<AbstractItem> items) {
        for (AbstractItem item : items) {
            if (item.isPrivate()) continue;
            return false;
        }
        return true;
    }

    public static boolean areItemsStatusCompleted(List<AbstractItem> items) {
        boolean areItemsStatusCompleted;
        block1: {
            areItemsStatusCompleted = false;
            if (items == null || items.size() <= 0) break block1;
            areItemsStatusCompleted = true;
            for (AbstractItem item : items) {
                if (!(areItemsStatusCompleted &= item.isStatusCompleted())) break;
            }
        }
        return areItemsStatusCompleted;
    }

    public static boolean canCompleteItems(List<AbstractItem> items) {
        boolean canCompleteItems;
        block1: {
            canCompleteItems = false;
            if (items == null || items.size() <= 0) break block1;
            canCompleteItems = true;
            for (AbstractItem item : items) {
                if (!(canCompleteItems &= item.canComplete())) break;
            }
        }
        return canCompleteItems;
    }

    public static AbstractItem composeReplyItem(AbstractItem theGWItem, int style, boolean withMessage, boolean withAttachments, String partialText) throws GWCommandException {
        try {
            Object nativeItem = theGWItem.getNativeItem();
            IMessage replyMessage = partialText == null ? nativeItem.createReply(style, withMessage, withAttachments) : nativeItem.createReply(style, withMessage, withAttachments, partialText);
            AbstractItem newItem = GWItemFactory.gwObjectToItem(replyMessage);
            newItem.setIgnoreMessageTypeOnCompose(true);
            GWEngineUtils.setupSuggestedBody(replyMessage, newItem);
            if (withMessage) {
                newItem.setReplyFwdOriginalSenderDisplayNameText(theGWItem.getSender().getDisplayText());
            }
            return newItem;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    public static AbstractItem composeForwardItem(AbstractItem item, boolean asAttachment, String partialText) throws GWCommandException {
        AbstractItem newItem;
        Object nativeItem = item.getNativeItem();
        try {
            if (asAttachment) {
                IMessage forwardMessage = nativeItem.createForward();
                if (!nativeItem.isRead() && nativeItem.canMarkRead()) {
                    nativeItem.markRead();
                }
                newItem = GWItemFactory.gwObjectToItem(forwardMessage);
                GWEngineUtils.setupSuggestedBody(forwardMessage, newItem);
            } else {
                IMessage forwardMessage = nativeItem.createSimpleForward(partialText);
                newItem = GWItemFactory.gwObjectToItem(forwardMessage);
                GWEngineUtils.setupSuggestedBody(forwardMessage, newItem);
                newItem.setReplyFwdOriginalSenderDisplayNameText(item.getSender().getDisplayText());
            }
            newItem.setIgnoreMessageTypeOnCompose(true);
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
        return newItem;
    }

    public static String validateSuggestedBody(ISuggestedBody suggestedBody) {
        String result;
        if (suggestedBody == null) {
            throw new IllegalArgumentException("suggestedBody is null");
        }
        if (suggestedBody.getFormat() == MessageSuggestedBodyFormat.HTML) {
            result = HTMLUtils.replaceTags(suggestedBody.getText(), "STRONG", "B");
            result = HTMLUtils.replaceTags(result, "EM", "I");
            result = HTMLUtils.fixSpacesBTWUTFCharCodes(result);
        } else {
            boolean replyInsertAtBottom = EngineCommandManager.getAccountSettings().getPlainTextReplyFormat().isReplyInsertAtBottom();
            StringBuilder res = new StringBuilder(suggestedBody.getText());
            if (res.length() > 1 && replyInsertAtBottom) {
                res.insert(res.length() - 1, "\\par \\par ");
            }
            result = res.toString();
        }
        return result;
    }

    public static AbstractItem composeResendItem(AbstractItem theGWItem, int resendRetractOption) throws GWCommandException {
        INote resendNote;
        Object nativeItem = theGWItem.getNativeItem();
        IMessage resendMessage = nativeItem.createResend(resendRetractOption);
        if (resendMessage == null) {
            return null;
        }
        AbstractItem newItem = GWItemFactory.gwObjectToItem(resendMessage);
        if (newItem instanceof AbstractCalendarItem && resendMessage instanceof INote && (resendNote = (INote)resendMessage).isAutodate()) {
            GWEngineUtils.setAutoDateInfo(resendNote, (AbstractCalendarItem)newItem);
        }
        newItem.setIgnoreMessageTypeOnCompose(true);
        GWEngineUtils.setupSuggestedBody(resendMessage, newItem);
        return newItem;
    }

    public static AbstractItem composeDelegateItem(AbstractCalendarItem theGWItem) throws GWCommandException {
        try {
            INote note = (INote)theGWItem.getNativeItem();
            INote delegateNote = note.delegate();
            AbstractItem newItem = GWItemFactory.gwObjectToItem(delegateNote);
            if (newItem instanceof AbstractCalendarItem && delegateNote.isAutodate()) {
                GWEngineUtils.setAutoDateInfo(delegateNote, (AbstractCalendarItem)newItem);
            }
            newItem.setIgnoreMessageTypeOnCompose(true);
            GWEngineUtils.setupSuggestedBody(delegateNote, newItem);
            return newItem;
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)e), e);
        }
    }

    private static void setupSuggestedBody(IMessage supplier, AbstractItem consumer) {
        ISuggestedBody suggestedBody = supplier.getSuggestedBody();
        if (suggestedBody != null) {
            String validatedBody = GWEngineUtils.validateSuggestedBody(suggestedBody);
            if (suggestedBody.getFormat() == MessageSuggestedBodyFormat.HTML) {
                consumer.getMessage().setHtmlText(validatedBody);
            } else {
                consumer.getMessage().setRtfText(validatedBody);
            }
        }
    }

    private static void setAutoDateInfo(INote newNativeItem, AbstractCalendarItem newItem) {
        Date[] startDates = newNativeItem.getAutoDate();
        if (startDates != null) {
            newItem.setStartDates(startDates);
            if (newItem instanceof AppointmentItem) {
                long duration = EngineUtils.flaimTimeToTime((long)((IAppointment)newNativeItem).getDuration());
                Date newEndDate = new Date(startDates[0].getTime() + duration);
                newItem.setEndDate(newEndDate);
            }
        }
    }

    public static void saveAttachment(GWAttachment theAttachment) throws GWCommandException {
        GWEngineUtils.saveAttachment(theAttachment, true);
    }

    public static void saveAttachment(GWAttachment theAttachment, boolean storeInCache) throws GWCommandException {
        try {
            String filePath = ControlsUtils.getAttachmentFilePath(theAttachment).getAbsolutePath();
            if (!storeInCache && new File(filePath).exists()) {
                theAttachment.setLocalFilePath(filePath);
                return;
            }
            GWEngineUtils.saveAttachment(theAttachment, filePath, storeInCache);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new GWCommandException(e);
        }
    }

    public static void saveAttachment(GWAttachment theAttachment, String theFilePath) throws GWCommandException {
        GWEngineUtils.saveAttachment(theAttachment, theFilePath, true);
    }

    public static void saveAttachment(GWAttachment attachment, String theFilePath, boolean storeInCache) throws GWCommandException {
        boolean bRet;
        File file = new File(theFilePath);
        if (storeInCache && file.exists() && !file.canWrite()) {
            file.delete();
        }
        if (!(bRet = attachment.getNativeAttachment().saveToFile(theFilePath, storeInCache))) {
            String[] saArgs = new String[]{theFilePath};
            String sMsg = StringResources.formatString(StringResources.SAVE_ATTACHMENT_FAILED, saArgs);
            throw new GWCommandException(sMsg);
        }
        attachment.setLocalFile(true);
        attachment.setLocalFilePath(theFilePath);
    }

    public static IContact createContact(com.novell.gw.jclient.bl.om.directory.PersonalAddressBook theAddressBook, ContactType contactType) {
        PersonalAddressBook nativeAddressBook = (PersonalAddressBook)theAddressBook.getNativeAddressBook();
        return APIAbWrapperManager.getContact(nativeAddressBook.createContact(contactType.getValue()));
    }

    private static void deleteContact(com.novell.gw.jclient.bl.om.directory.PersonalAddressBook theAddressBook, IContact theContact) throws EngineException {
        PersonalAddressBook addressBook = (PersonalAddressBook)theAddressBook.getNativeAddressBook();
        addressBook.deleteContact(theContact.getNativeContact());
    }

    public static boolean deleteContacts(List contacts, Component component) throws EngineException {
        String message = contacts.size() > 1 ? StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ITEMS : StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ITEM;
        int result = JOptionPane.showConfirmDialog(component, message, StringResources.NOVELL_GROUPWISE, 0);
        if (result == 0) {
            int nSize = contacts.size();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)contacts.get(i);
                AbstractAddressBook ab = EngineCommandManager.getContactAddressBook(contact);
                if (!(ab instanceof com.novell.gw.jclient.bl.om.directory.PersonalAddressBook)) continue;
                GWEngineUtils.deleteContact((com.novell.gw.jclient.bl.om.directory.PersonalAddressBook)ab, contact);
            }
            return true;
        }
        return false;
    }

    public static boolean shareAddressBook(com.novell.gw.jclient.bl.om.directory.PersonalAddressBook theAddressBook, AddressBookSharedList theSharedList) {
        return ((PersonalAddressBook)theAddressBook.getNativeAddressBook()).setSharedList(theSharedList);
    }

    public static String createNameForNewFolder(IFolder parentFolder, boolean calendar) {
        String complexName;
        String simpleName = calendar ? StringResources.NEW_CALENDAR : StringResources.NEW_FOLDER;
        String string = complexName = calendar ? StringResources.DEFAULT_NEW_CALENDAR_FOLDER_NAME : StringResources.DEFAULT_NEW_FOLDER_NAME;
        if (!GWEngineUtils.containsFolder(parentFolder, simpleName)) {
            return simpleName;
        }
        int i = 1;
        String result;
        while (GWEngineUtils.containsFolder(parentFolder, result = StringResources.formatString(complexName, Integer.toString(i)))) {
            ++i;
        }
        return result;
    }

    public static String createNameForNewContactsFolder() {
        if (!GWEngineUtils.doesAddressBookExist(StringResources.NEW_CONTACTS)) {
            return StringResources.NEW_CONTACTS;
        }
        int i = 1;
        String result;
        while (GWEngineUtils.doesAddressBookExist(result = StringResources.formatString(StringResources.DEFAULT_NEW_CONTACTS_FOLDER_NAME, Integer.toString(i)))) {
            ++i;
        }
        return result;
    }

    public static boolean doesAddressBookExist(String name) {
        AddressBookManager mgr = EngineCommandManager.getAddressBookManager();
        Iterator iterator = mgr.getPersonalAddressBooksIterator();
        while (iterator.hasNext()) {
            PersonalAddressBook book = (PersonalAddressBook)iterator.next();
            String strBookName = book.getName();
            if (!name.equals(strBookName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFolder(IFolder parentFolder, String name) {
        for (IFolder folder : parentFolder.getSubFolders()) {
            if (!name.equals(folder.getName())) continue;
            return true;
        }
        return false;
    }
}

