/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl;

import com.appframework.mvc.GlobalCommand;
import com.novell.gw.engine.DataStore;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.notify.dialogs.options.SettingsPanelModel;
import com.novell.gw.jclient.application.notify.enums.MessagePriority;
import com.novell.gw.jclient.application.notify.enums.MessageType;
import com.novell.gw.jclient.application.notify.enums.NotificationType;
import com.novell.gw.jclient.application.notify.enums.ReturnStatus;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.NotifyTypeConverter;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.NotificationItem;
import com.novell.gw.jclient.bl.om.options.NotifierOptions;
import com.novell.gw.notification.Notify;
import com.novell.gw.notification.NotifyItem;
import com.novell.gw.notification.NotifyListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyProxy
extends GWNotify {
    private static Logger logger = Logger.getLogger(NotifyProxy.class);
    private Notify notify;

    public NotifyProxy() {
        String userGuid = EngineCommandManager.getUserGuid();
        IDataStore dataStore = GWCommandManager.getInstance(userGuid).getCurrentDataStore();
        this.notify = Notify.getInstance((DataStore)dataStore.getNativeDataStore());
    }

    public void clear() {
        this.notify.dispose();
        this.notify = null;
    }

    @Override
    public boolean setNotifyFolders(List<AbstractFolder> folders) {
        int nSize = folders.size();
        IFolder[] nativeFolders = new IFolder[nSize];
        for (int i = 0; i < nSize; ++i) {
            nativeFolders[i] = folders.get(i).getNativeFolder();
        }
        return this.notify.setNotifyFolders(APIFolderWrapperManager.getNativeFolderArray(nativeFolders));
    }

    @Override
    public List<AbstractFolder> getNotifyFolders() {
        IFolder[] nativeFolders = APIFolderWrapperManager.getFolderArray(this.notify.getNotifyFolders());
        ArrayList<AbstractFolder> folders = new ArrayList<AbstractFolder>(nativeFolders.length);
        String userGuid = EngineCommandManager.getUserGuid();
        int nLen = nativeFolders.length;
        for (int i = 0; i < nLen; ++i) {
            folders.add(i, GWCommandManager.getInstance(userGuid).getGWFolder(nativeFolders[i]));
        }
        return folders;
    }

    @Override
    public List<AbstractFolder> getDefaultNotifyFolders() {
        IFolder[] nativeFolders = APIFolderWrapperManager.getFolderArray(this.notify.getNotifyFolders(true));
        ArrayList<AbstractFolder> folders = new ArrayList<AbstractFolder>(nativeFolders.length);
        String userGuid = EngineCommandManager.getUserGuid();
        int nLen = nativeFolders.length;
        for (int i = 0; i < nLen; ++i) {
            folders.add(i, GWCommandManager.getInstance(userGuid).getGWFolder(nativeFolders[i]));
        }
        return folders;
    }

    @Override
    public List<NotificationItem> getNotificationItems() {
        NotifyItem[] nativeItems = this.notify.getList();
        ArrayList<NotificationItem> items = new ArrayList<NotificationItem>(nativeItems.length);
        for (NotifyItem nativeItem : nativeItems) {
            NotificationItem item = new NotificationItem(nativeItem);
            items.add(item);
        }
        return items;
    }

    @Override
    public int getPollInterval() {
        return this.notify.getPollInterval();
    }

    @Override
    public int getDefaultPollInterval() {
        return this.notify.getPollInterval(true);
    }

    @Override
    public boolean isPollIntervalLocked() {
        return this.notify.isPollIntervalLocked();
    }

    @Override
    public boolean setPollInterval(int minutes) {
        return this.notify.setPollInterval(minutes);
    }

    @Override
    public boolean deleteNotificationItem(NotificationItem item) {
        return this.notify.deleteItem(item.getNativeItem());
    }

    @Override
    public void clearAllNotificationItems() {
        this.notify.clearAllListItems();
    }

    @Override
    public void clearNotificationItem(NotificationItem item) {
        this.notify.clearListItem(item.getNativeItem());
    }

    @Override
    public AbstractItem readNotificationItem(NotificationItem item) {
        IItem nativeItem = APIWrapperManager.getItem(this.notify.readItem(item.getNativeItem()));
        if (!(nativeItem instanceof IMessage)) {
            throw new IllegalStateException("nativeItem was supposed to be a Message instance, but is " + nativeItem);
        }
        String userGuid = EngineCommandManager.getUserGuid();
        AbstractItem wrapedItem = null;
        try {
            wrapedItem = GWCommandManager.getInstance(userGuid).getGWItem((IMessage)nativeItem);
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        return wrapedItem;
    }

    @Override
    public int getDefaultNotifyDialogTimeout() {
        return this.notify.getDialogTimeout(true);
    }

    @Override
    public int getNotifyDialogTimeout() {
        return this.notify.getDialogTimeout();
    }

    @Override
    public void setNotifyDialogTimeout(int timeout) {
        this.notify.setDialogTimeout(timeout);
    }

    @Override
    public SettingsPanelModel getAlarmSettingsPanelModel() {
        boolean showDialog = this.notify.isShowDialogOnAlarm();
        boolean playSound = this.notify.isPlaySoundOnAlarm();
        boolean launchProgram = this.notify.isLaunchProgramOnAlarm();
        String soundFile = this.notify.getSoundForAlarm();
        String programFile = this.notify.getLaunchProgramForAlarm();
        SettingsPanelModel model = new SettingsPanelModel(showDialog, playSound, launchProgram, soundFile, programFile);
        return model;
    }

    @Override
    public SettingsPanelModel getDefaultAlarmSettingsPanelModel() {
        boolean showDialog = this.notify.isShowDialogOnAlarm(true);
        boolean playSound = this.notify.isPlaySoundOnAlarm(true);
        boolean launchProgram = this.notify.isLaunchProgramOnAlarm(true);
        String soundFile = this.notify.getSoundForAlarm(true);
        String programFile = this.notify.getLaunchProgramForAlarm(true);
        SettingsPanelModel model = new SettingsPanelModel(showDialog, playSound, launchProgram, soundFile, programFile);
        return model;
    }

    @Override
    public void setAlarmSettingsPanelModel(SettingsPanelModel model) {
        logger.debug((Object)("model to save: " + model));
        this.notify.setShowDialogOnAlarm(model.isShowDialog());
        this.notify.setPlaySoundOnAlarm(model.isPlaySound());
        this.notify.setLaunchProgramOnAlarm(model.isLaunchProgram());
        this.notify.setSoundForAlarm(model.getSoundFilePath());
        this.notify.setLaunchProgramForAlarm(model.getProgramFilePath());
    }

    @Override
    public boolean isDefaultSameSettingsForAllNewItems() {
        return this.notify.isSameSettingsForAllNewItems(true);
    }

    @Override
    public boolean isSameSettingsForAllNewItems() {
        return this.notify.isSameSettingsForAllNewItems();
    }

    @Override
    public void setSameSettingsForAllNewItems(boolean sameSettings) {
        this.notify.setSameSettingsForAllNewItems(sameSettings);
    }

    @Override
    public SettingsPanelModel getDefaultNewItemSettingsPanelModel(MessageType type, MessagePriority priority) {
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToNewItemNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertMessagePriorityToStatusType(priority);
        SettingsPanelModel model = this.getDefaultSettingsPanelModel(category, subCategory);
        logger.debug((Object)("type: " + (Object)((Object)type) + ", priority: " + (Object)((Object)priority)));
        logger.debug((Object)("default model: " + model));
        return model;
    }

    @Override
    public SettingsPanelModel getNewItemSettingsPanelModel(MessageType type, MessagePriority priority) {
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToNewItemNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertMessagePriorityToStatusType(priority);
        SettingsPanelModel model = this.getSettingsPanelModel(category, subCategory);
        logger.debug((Object)("type: " + (Object)((Object)type) + ", priority: " + (Object)((Object)priority)));
        logger.debug((Object)("model: " + model));
        return model;
    }

    @Override
    public void setNewItemSettingsPanelModel(SettingsPanelModel model, MessageType type, MessagePriority priority) {
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToNewItemNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertMessagePriorityToStatusType(priority);
        this.setSettingsPanelModel(model, category, subCategory);
    }

    private SettingsPanelModel getSettingsPanelModel(NotifyItem.NotifyType category, NotifyItem.StatusType subCategory) {
        boolean showDialog = this.notify.isShowDialogOnNewItem(category, subCategory);
        boolean playSound = this.notify.isPlaySoundOnNewItem(category, subCategory);
        boolean launchProgram = this.notify.isLaunchProgramOnNewItem(category, subCategory);
        String soundFile = this.notify.getSoundForNewItem(category, subCategory);
        String programFile = this.notify.getLaunchProgramForNewItem(category, subCategory);
        SettingsPanelModel model = new SettingsPanelModel(showDialog, playSound, launchProgram, soundFile, programFile);
        return model;
    }

    private SettingsPanelModel getDefaultSettingsPanelModel(NotifyItem.NotifyType category, NotifyItem.StatusType subCategory) {
        boolean showDialog = this.notify.isShowDialogOnNewItem(category, subCategory, true);
        boolean playSound = this.notify.isPlaySoundOnNewItem(category, subCategory, true);
        boolean launchProgram = this.notify.isLaunchProgramOnNewItem(category, subCategory, true);
        String soundFile = this.notify.getSoundForNewItem(category, subCategory, true);
        String programFile = this.notify.getLaunchProgramForNewItem(category, subCategory, true);
        SettingsPanelModel model = new SettingsPanelModel(showDialog, playSound, launchProgram, soundFile, programFile);
        return model;
    }

    private void setSettingsPanelModel(SettingsPanelModel model, NotifyItem.NotifyType category, NotifyItem.StatusType subCategory) {
        logger.debug((Object)("category: " + category + ", subCategory: " + subCategory));
        logger.debug((Object)("model to set: " + model));
        this.notify.setShowDialogOnNewItem(category, subCategory, model.isShowDialog());
        this.notify.setPlaySoundOnNewItem(category, subCategory, model.isPlaySound());
        this.notify.setLaunchProgramOnNewItem(category, subCategory, model.isLaunchProgram());
        this.notify.setSoundForNewItem(category, subCategory, model.getSoundFilePath());
        this.notify.setLaunchProgramForNewItem(category, subCategory, model.getProgramFilePath());
    }

    @Override
    public boolean isDefaultSameSettingsForAllStatus() {
        return this.notify.isSameSettingsForAllStatus(true);
    }

    @Override
    public boolean isSameSettingsForAllStatus() {
        return this.notify.isSameSettingsForAllStatus();
    }

    @Override
    public void setSameSettingsForAllStatus(boolean sameSettings) {
        this.notify.setSameSettingsForAllStatus(sameSettings);
    }

    @Override
    public SettingsPanelModel getDefaultStatusSettingsPanelModel(MessageType type, ReturnStatus status) {
        if (!this.isStatusSettingsPanelModelAllowed(type, status)) {
            return null;
        }
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToStatusNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertReturnStatusToStatusType(status);
        SettingsPanelModel model = this.getDefaultSettingsPanelModel(category, subCategory);
        logger.debug((Object)("type: " + (Object)((Object)type) + ", status: " + (Object)((Object)status)));
        logger.debug((Object)("default model: " + model));
        return model;
    }

    @Override
    public SettingsPanelModel getStatusSettingsPanelModel(MessageType type, ReturnStatus status) {
        if (!this.isStatusSettingsPanelModelAllowed(type, status)) {
            return null;
        }
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToStatusNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertReturnStatusToStatusType(status);
        SettingsPanelModel model = this.getSettingsPanelModel(category, subCategory);
        logger.debug((Object)("type: " + (Object)((Object)type) + ", status: " + (Object)((Object)status)));
        logger.debug((Object)("model: " + model));
        return model;
    }

    @Override
    public void setStatusSettingsPanelModel(SettingsPanelModel model, MessageType type, ReturnStatus status) {
        if (model == null) {
            return;
        }
        NotifyItem.NotifyType category = NotifyTypeConverter.convertMessageTypeToStatusNotifyType(type);
        NotifyItem.StatusType subCategory = NotifyTypeConverter.convertReturnStatusToStatusType(status);
        this.setSettingsPanelModel(model, category, subCategory);
    }

    private boolean isStatusSettingsPanelModelAllowed(MessageType type, ReturnStatus status) {
        if (ReturnStatus.OPENED.equals((Object)status) || ReturnStatus.DELETED.equals((Object)status)) {
            return true;
        }
        if (type.equals((Object)MessageType.ANY)) {
            return true;
        }
        if (type.equals((Object)MessageType.MAIL_MESSEGE)) {
            return false;
        }
        if (type.equals((Object)MessageType.APPOINTMENT)) {
            return status.equals((Object)ReturnStatus.ACCEPTED);
        }
        if (type.equals((Object)MessageType.TASK)) {
            return true;
        }
        if (type.equals((Object)MessageType.NOTE)) {
            return false;
        }
        throw new IllegalStateException("unhandled combination: " + (Object)((Object)type) + ", " + (Object)((Object)status));
    }

    @Override
    public void addNotifyListener(NotifyListener listener) {
        this.notify.addNotifyListener(listener);
    }

    @Override
    public void removeNotifyListener(NotifyListener listener) {
        this.notify.removeNotifyListener(listener);
    }

    @Override
    public int getNumberOfItems(NotificationType notificationType) {
        int count = 0;
        switch (notificationType) {
            case ALARM: {
                count = this.notify.getNumAlarms();
                break;
            }
            case APPOINTMENT: {
                count = this.notify.getNumAppointments();
                break;
            }
            case MESSAGE: {
                count = this.notify.getNumMessages();
                break;
            }
            case RETURN_NOTIFICATION: {
                count = this.notify.getNumReturnStatus();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected notification type encountered: " + (Object)((Object)notificationType));
            }
        }
        return count;
    }

    @Override
    public void setNotificationsEnabled(boolean enabled) {
        logger.debug((Object)("state on notifications enablement is: " + (enabled ? "ON" : "OFF")));
        NotifierOptions options = OptionManager.getInstance().getNotifierOptions();
        options.setNotificationEnabled(enabled);
        OptionManager.getInstance().setNotifierOptions(options);
        this.notify.enableNotifications(enabled);
        GWClient.getGwClientActionList().processCommand(new GlobalCommand(1740, enabled));
    }

    @Override
    public void snoozeItem(NotificationItem item, int snoozeInterval) {
        this.notify.snoozeItem(item.getNativeItem(), snoozeInterval);
    }
}

