/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.impl.cache;

import com.appframework.utils.Assertions;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.UniversalFolder;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class FoldersCache {
    private static Logger logger = Logger.getLogger(FoldersCache.class);
    private static volatile Hashtable cache = new Hashtable();
    private static volatile AbstractFolder root;
    private static volatile Map cache1;
    private static volatile Hashtable rootFolders;

    public static synchronized boolean containsFolder(String theFolderID, String userGuid) {
        return FoldersCache.getItemList(userGuid).containsKey(theFolderID);
    }

    public static synchronized boolean containsFolder(Class theFolderClass, String userGuid) {
        return FoldersCache.getFolder(theFolderClass, userGuid) != null;
    }

    public static synchronized void clear() {
        cache1.clear();
        rootFolders.clear();
    }

    public static synchronized void clear(String userGuid) {
        FoldersCache.getItemList(userGuid).clear();
        cache1.remove(userGuid);
        rootFolders.remove(userGuid);
    }

    private static synchronized Hashtable getItemList(String userGuid) {
        Hashtable folders = (Hashtable)cache1.get(userGuid);
        if (folders == null) {
            folders = new Hashtable();
            cache1.put(userGuid, folders);
        }
        return folders;
    }

    public static synchronized AbstractFolder getFolder(Class theFolderClass, String userGuid) {
        Collection folders = FoldersCache.getItemList(userGuid).values();
        for (Object folder : folders) {
            AbstractFolder theFolder = (AbstractFolder)folder;
            if (!theFolder.getClass().isAssignableFrom(theFolderClass)) continue;
            return theFolder;
        }
        return null;
    }

    public static synchronized AbstractFolder getFolder(String theFolderID, String userGuid) {
        return (AbstractFolder)FoldersCache.getItemList(userGuid).get(theFolderID);
    }

    public static synchronized void addFolder(AbstractFolder theFolder, String userGuid) {
        String folderID = theFolder.getID();
        if (FoldersCache.getItemList(userGuid).contains(folderID)) {
            Assertions.assertIllegalState("Cache already contains folder with ID [" + folderID + "], dupplicated Folder name = [" + theFolder.getName() + ']');
        } else {
            FoldersCache.getItemList(userGuid).put(folderID, theFolder);
        }
    }

    public static synchronized void removeFolder(AbstractFolder theFolder, String userGuid) {
        FoldersCache.getItemList(userGuid).remove(theFolder.getID());
    }

    public static boolean containsRootFolder(String userGuid) {
        return rootFolders.get(userGuid) != null;
    }

    public static AbstractFolder getRootFolder(String userGuid) {
        return (AbstractFolder)rootFolders.get(userGuid);
    }

    public static UniversalFolder getMailboxFolder(String userGuid) {
        return (UniversalFolder)FoldersCache.getFolder(UniversalFolder.class, userGuid);
    }

    public static void putRootFolder(AbstractFolder theRootFolder, String userGuid) {
        rootFolders.put(userGuid, theRootFolder);
    }

    public static int getCount(String userGuid) {
        return FoldersCache.getItemList(userGuid).size();
    }

    static {
        cache1 = new Hashtable();
        rootFolders = new Hashtable();
    }
}

