/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.folders;

import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.NormalFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolderColorChangeListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class SubCalendarFolder
extends NormalFolder {
    private static Logger logger = Logger.getLogger(CalendarFolder.class);
    public static final int ICON_WIDTH = 12;
    public static final int ICON_HEIGHT = 12;
    protected BufferedImage colorSquare = new BufferedImage(12, 12, 1);
    protected ImageIcon imageIcon = null;
    private SubCalendarFolderColorChangeListener colorChangeListener = new SubCalendarFolderColorChangeListener(this);

    public SubCalendarFolder() {
        this.getMainGWFoldersTreeColorChooserButton().addPropertyChangeListener(this.colorChangeListener);
    }

    public SubCalendarFolder(String theID, String theName) {
        super(theID, theName);
        this.getMainGWFoldersTreeColorChooserButton().addPropertyChangeListener(this.colorChangeListener);
    }

    public String getType() {
        return "CalendarFolder";
    }

    public String getTypeString() {
        return StringResources.PERSONAL_FOLDER;
    }

    public boolean canHaveChildren() {
        return false;
    }

    public void setColor(Color color) {
        logger.debug((Object)(">>>>>>>> color: " + color + " (" + System.identityHashCode(this) + ')'));
        this.getNativeFolder().setCalendarColor(color);
        this.refreshIcon();
    }

    public Color getColor() {
        return this.getNativeFolder().getCalendarColor();
    }

    public void setSubCalendarShown(boolean b) {
        this.getNativeFolder().setSubCalendarShown(b);
        try {
            CalendarFolder calendarFolder = EngineCommandManager.getInstance(this.getUserGuid()).getCalendarFolder();
            GWClient.getApplication().processCommand(new GlobalCommand(2080, calendarFolder));
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void refreshIcon() {
        this.imageIcon = null;
        this.getColorSquare();
    }

    public ImageIcon getColorSquare() {
        if (this.imageIcon == null) {
            Graphics2D big = this.colorSquare.createGraphics();
            this.paintColorSquare(big);
            this.imageIcon = new ImageIcon(this.colorSquare);
        }
        return this.imageIcon;
    }

    protected void paintColorSquare(Graphics2D big) {
        Color color = this.getColor();
        if (color == null) {
            color = AppointmentAcceptLevel.BUSY.getColor();
        }
        big.setColor(color);
        big.fillRect(0, 0, 12, 12);
    }

    private ColorChooserButton getMainGWFoldersTreeColorChooserButton() {
        return MainGWFoldersTree.colorChooser;
    }

    protected void finalize() throws Throwable {
        ColorChooserButton colorChooserButton = this.getMainGWFoldersTreeColorChooserButton();
        if (colorChooserButton != null) {
            colorChooserButton.removePropertyChangeListener(this.colorChangeListener);
        }
        this.colorChangeListener = null;
        super.finalize();
    }
}

