/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.components.htmleditor.RTFUtils;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.Assertions;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.enums.MessageSentItemStatus;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.IMessageAttachment;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTip;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.Sender;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItem<T extends IMessage>
implements TableItem,
Serializable {
    private static Logger logger = Logger.getLogger(AbstractItem.class);
    public static final int SUBTYPE_REPLY_REQUESTED = 105;
    protected T nativeItem;
    protected String sharedFolderName;
    protected MessageBody message;
    protected List<GWAttachment> attachments;
    private ArrayList<IRecipient> recipientsList = null;
    private List<String> listSummaryValues = new ArrayList<String>();
    private boolean isHTMLMessageComposition = false;
    private String replyFwdOriginalSenderDisplayNameText;
    private boolean saved = false;
    private boolean processing = false;
    private String displayType = StringResources.MESSAGE_ATTACHMENT;
    int j = 0;
    private IItem[] thisItem = new IItem[1];
    IViewDisplaySettings lastDisplaySettings;
    private boolean ignoreMessageTypeOnCompose = false;

    protected AbstractItem(T theNativeItem) {
        Assertions.assertNotNull(theNativeItem, "NativeItem can not be NULL");
        this.nativeItem = theNativeItem;
        this.message = new MessageBody(this);
    }

    protected AbstractItem() {
    }

    public String getSummaryValue(int i, IViewDisplaySettings displaySettings) {
        if (displaySettings == null) {
            throw new IllegalArgumentException("displaySettings is null");
        }
        if (!this.nativeItem.isPseudoItem()) {
            if (this.listSummaryValues.isEmpty() || displaySettings != this.lastDisplaySettings) {
                this.initSummaryValue(displaySettings);
            }
            if (i >= 0 && i < this.listSummaryValues.size()) {
                return this.listSummaryValues.get(i);
            }
        } else {
            return "Pseudo";
        }
        return "";
    }

    private void initSummaryValue(IViewDisplaySettings displaySettings) {
        if (displaySettings == null) {
            throw new IllegalArgumentException("displaySettings is null");
        }
        if (this.nativeItem.isPseudoItem()) {
            return;
        }
        if (this.listSummaryValues.isEmpty() || displaySettings != this.lastDisplaySettings) {
            this.listSummaryValues.clear();
            int n = 4;
            for (int i = 0; i < n; ++i) {
                String sumValue = this.nativeItem.getSummaryValue(i, this.nativeItem.getFolder(), displaySettings);
                this.listSummaryValues.add(sumValue);
            }
        }
        this.lastDisplaySettings = displaySettings;
    }

    public boolean isDeleted() {
        return this.nativeItem.isDeleted();
    }

    public long getDueDate() {
        long dueDate = 0L;
        Date date = this.nativeItem.getDueDate();
        if (date != null) {
            dueDate = date.getTime();
        }
        return dueDate;
    }

    public boolean hasBodyText() {
        return this.nativeItem.hasBodyText();
    }

    public void setDueDate(long theDueDate) {
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public String getID() {
        return String.valueOf(this.nativeItem.getId());
    }

    public String getGID() {
        return this.nativeItem.getGID();
    }

    public int getPriority() {
        return this.nativeItem.getPriority();
    }

    public String getPriorityName() {
        switch (this.getPriority()) {
            case 1: {
                return StringResources.LOW;
            }
            case 2: {
                return StringResources.NORMAL;
            }
            case 4: {
                return StringResources.HIGH;
            }
        }
        return "";
    }

    public void setPriority(int thePriority) {
        this.nativeItem.setPriority(thePriority);
    }

    public Sender getSender() {
        return new Sender(this.nativeItem.getFromText(), this.nativeItem.getSenderEmailAddress());
    }

    public String getSenderID() {
        return this.nativeItem.getSenderID();
    }

    public String getTo() {
        List<IRecipient> recipients = this.getRecipients(RecipientCopyType.getTo());
        return ControlsUtils.recipientsToString(recipients);
    }

    public String getCc() {
        List<IRecipient> recipients = this.getRecipients(RecipientCopyType.getCc());
        return ControlsUtils.recipientsToString(recipients);
    }

    public boolean getSendOptionConcealSubject() {
        return this.nativeItem.getSendOptionConcealSubject();
    }

    @Override
    public String getSubject() {
        String subject = this.getPersonalizeSubject();
        if (subject == null || subject.length() == 0) {
            subject = this.nativeItem.getSubject();
        }
        return subject == null ? "" : subject;
    }

    public void setSubject(String theSubject) {
        this.nativeItem.setSubject(theSubject);
    }

    public String getSharedFolderName() {
        return this.sharedFolderName;
    }

    public void setSharedFolderName(String theSharedFolderName) {
        this.sharedFolderName = theSharedFolderName;
    }

    public boolean isSentItemRead() {
        if (this.isSentItem()) {
            int openedTotals = this.nativeItem.getOpenTotals();
            return openedTotals > 0;
        }
        return false;
    }

    public boolean isStatusRead() {
        return GWItemFactory.isMessageRead(this.nativeItem);
    }

    public boolean isStatusCompleted() {
        return this.nativeItem.isCompleted();
    }

    public boolean isPrivate() {
        return this.nativeItem.isPrivate();
    }

    public boolean isReceived() {
        return this.nativeItem.getBoxType() == 1;
    }

    public Date getDate() {
        return this.nativeItem.getDate();
    }

    public boolean hasPaperClipAttachments() {
        return this.nativeItem.hasPaperclipAttachments();
    }

    public MessageBody getMessage() {
        return this.message;
    }

    public void setMessage(MessageBody theMessage) {
        this.message = theMessage;
    }

    public MimeEncoding getMimeEncoding() {
        return MimeEncoding.getEncoding(this.nativeItem.getMimeEncoding());
    }

    public boolean setMimeEncoding(MimeEncoding mimeEncoding) {
        return this.nativeItem.setMimeEncoding(mimeEncoding.getValue());
    }

    public List<GWAttachment> getAttachments() {
        if (this.attachments == null) {
            this.initAttachments();
        }
        return this.attachments;
    }

    public void setAttachments(List<GWAttachment> attachments) {
        if (attachments == null) {
            this.attachments = new ArrayList<GWAttachment>();
        } else {
            this.attachments = attachments;
            for (int i = 0; i < attachments.size(); ++i) {
                this.attachments.get(i).setGwItem(this);
            }
        }
    }

    public int getSecurity() {
        return this.nativeItem.getSecurity();
    }

    public String toString() {
        return this.getSubject();
    }

    public IFolder getFolder() {
        return this.nativeItem.getFolder();
    }

    public String getPersonalizeSubject() {
        return this.nativeItem.getPersonalizeSubject();
    }

    public String getPersonalizeNote() {
        return this.nativeItem.getPersonalizeNotes();
    }

    public void updatePersonalizeData(String pSubject, String pNotes, ICategoryList c) {
        logger.debug((Object)("Subject: " + (pSubject == null ? "null" : '\"' + pSubject + '\"')));
        logger.debug((Object)("Notes: " + (pNotes == null ? "null" : '\"' + pNotes + '\"')));
        if (c != null) {
            ICategoryList freshList = APIFactory.getAPIUtils().getCategories(this.getArray());
            logger.debug((Object)("Old Categories = " + freshList));
            logger.debug((Object)("New Categories = " + c));
            this.nativeItem.updatePersonalizeData(pSubject, pNotes, CategoryUtils.createValidCategoryList(freshList, c));
        } else {
            this.nativeItem.updatePersonalizeData(pSubject, pNotes, null);
        }
    }

    public String getFolderName() {
        return this.nativeItem.getFolder().getName();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public MessageSentItemStatus getSentItemStatus() {
        return this.nativeItem.getSentItemStatus();
    }

    public boolean isSentItem() {
        return this.nativeItem.getBoxType() == 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractItem)) {
            return false;
        }
        return ((AbstractItem)obj).getID().equals(this.getID());
    }

    public synchronized void setRecipients(List<IRecipient> theRecipientsList) {
        if (this.recipientsList != null) {
            this.recipientsList.clear();
        } else {
            this.recipientsList = new ArrayList(theRecipientsList.size());
        }
        this.recipientsList.addAll(theRecipientsList);
    }

    public String getBc() {
        List<IRecipient> recipients = this.getRecipients(RecipientCopyType.getBc());
        return ControlsUtils.recipientsToString(recipients);
    }

    public List<IRecipient> getToRecipients() {
        return this.getRecipients(RecipientCopyType.getTo());
    }

    public List<IRecipient> getCcRecipients() {
        return this.getRecipients(RecipientCopyType.getCc());
    }

    public List<IRecipient> getBcRecipients() {
        return this.getRecipients(RecipientCopyType.getBc());
    }

    private List<IRecipient> getRecipients(RecipientCopyType type) {
        int n = this.getRecipients().size();
        ArrayList<IRecipient> result = new ArrayList<IRecipient>(n);
        for (int i = 0; i < n; ++i) {
            IRecipient recipient = this.getRecipients().get(i);
            if (!recipient.getCopyType().hasRecipientCopyType(type)) continue;
            result.add(recipient);
        }
        return Collections.unmodifiableList(result);
    }

    public void setComposeItemSendOptions(ComposeItemSendOptions composeItemSendOptions) {
        if (composeItemSendOptions != null) {
            ICategoryList oldCategories;
            this.nativeItem.setPriority(composeItemSendOptions.getPriority().getValue());
            this.nativeItem.setSecurity(composeItemSendOptions.getSecurity().getValue());
            this.nativeItem.setSendOptionExpireDays(composeItemSendOptions.getExpireDays());
            this.nativeItem.setSendOptionDelayDeliverInfo(composeItemSendOptions.getDelayDeliverInfo());
            this.nativeItem.setSendOptionNotifyRecipients(composeItemSendOptions.isNotifyRecipients());
            ICategoryList newCategories = composeItemSendOptions.getCategories();
            if (newCategories == null) {
                newCategories = APIWrapperManager.createCategoryList(GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore(), this.getArray());
            }
            if ((oldCategories = APIFactory.getAPIUtils().getCategories(new IItem[]{this.nativeItem})) == null) {
                this.nativeItem.setCategories(newCategories);
            } else {
                this.nativeItem.setCategories(CategoryUtils.createValidCategoryList(oldCategories, newCategories));
            }
            if (composeItemSendOptions.isReplyRequested()) {
                if (composeItemSendOptions.isReplyWhenConvenient()) {
                    this.nativeItem.setReplyWhenConvenient(true);
                } else {
                    this.nativeItem.setReplyWithinDays(composeItemSendOptions.getReplyRequestDay());
                }
            } else {
                this.nativeItem.setReplyRequested(false);
            }
            this.nativeItem.setNotifyWhenOpened(composeItemSendOptions.getRNWhenOpened().getValue());
            this.nativeItem.setNotifyWhenDeleted(composeItemSendOptions.getRNWhenDeleted().getValue());
            this.nativeItem.setMimeEncoding(composeItemSendOptions.getMimeEncoding().getValue());
        }
    }

    public ComposeItemSendOptions getComposeItemSendOptions(ComposeItemSendOptions ciso) {
        if (ciso != null) {
            ciso.setPriority(Priority.getPriority(this.nativeItem.getPriority()));
            ciso.setSecurity(Security.getSecurity(this.nativeItem.getSecurity()));
            ICategoryList c = this.getCategories();
            if (c == null) {
                c = APIWrapperManager.createCategoryList(GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore(), this.getArray());
            }
            ciso.setCategories(c);
            ciso.setReplyRequested(this.nativeItem.isReplyRequested());
            if (ciso.isReplyRequested() && this.nativeItem.isReplyWithinDays()) {
                ciso.setReplyRequestDay(this.nativeItem.getReplyRequestDays());
                ciso.setReplyWhenConvenient(false);
            }
            ciso.setRNWhenOpened(AbstractItem.getNotification(this.nativeItem.getNotifyWhenOpened()));
            ciso.setRNWhenDeleted(AbstractItem.getNotification(this.nativeItem.getNotifyWhenDeleted()));
            ciso.setMimeEncodingType(MimeEncoding.getEncoding(this.nativeItem.getMimeEncoding()));
        }
        return ciso;
    }

    public void appendSignature(String theSignature) {
        if (theSignature != null && theSignature.length() != 0) {
            StringBuffer sb;
            String valueToInsert;
            String message = this.getMessage().getMessage();
            int position = -1;
            AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
            if (this.replyFwdOriginalSenderDisplayNameText != null) {
                if (this.isHTMLMessageComposition) {
                    AccountSettings.HTMLReplyFormat htmlReplyFormat = accountSettings.getHTMLReplyFormat();
                    position = htmlReplyFormat.getReplyType() != 0 && htmlReplyFormat.isReplyInsertAtBottom() ? Math.max(message.indexOf("</body>"), message.indexOf("</BODY>")) : message.indexOf("&gt;&gt;&gt;", position);
                    valueToInsert = HTMLUtils.normalizeSignatureForHTML(theSignature);
                } else {
                    AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
                    if (plainTextReplyFormat.getReplyType() != 0 && plainTextReplyFormat.isReplyInsertAtBottom()) {
                        this.message.setRtfText(RTFUtils.getRtfSignature(theSignature, message, true));
                        return;
                    }
                    position = message.indexOf("\\par\n>>>");
                    if (position < 0) {
                        position = message.lastIndexOf(125);
                    }
                    valueToInsert = "\\par\\par " + theSignature.replaceAll("\n", "\\\\par ") + "\\par";
                }
            } else if (this.isHTMLMessageComposition) {
                position = Math.max(message.indexOf("</body>"), message.indexOf("</BODY>"));
                valueToInsert = HTMLUtils.normalizeSignatureForHTML(theSignature);
            } else {
                this.message.setRtfText(RTFUtils.getRtfSignature(theSignature, message, true));
                return;
            }
            if (message.length() == 0 && valueToInsert != null && this.isHTMLMessageComposition) {
                this.message.setHtmlText("<html><body>" + valueToInsert + "</body></html>");
                return;
            }
            if (position >= 0 && valueToInsert != null && position <= (sb = new StringBuffer(message)).length()) {
                if (this.isHTMLMessageComposition) {
                    sb.insert(position, valueToInsert);
                    this.message.setHtmlText(sb.toString());
                } else {
                    this.message.setRtfText(RTFUtils.getRtfSignature(theSignature, message, this.replyFwdOriginalSenderDisplayNameText == null));
                }
            }
        }
    }

    public boolean isHTMLMessageComposition() {
        return this.isHTMLMessageComposition;
    }

    public void setHTMLMessageComposition(boolean b) {
        this.isHTMLMessageComposition = b;
    }

    private void initAttachments() {
        ArrayList<GWAttachment> gwAttachments = new ArrayList<GWAttachment>();
        try {
            IAttachment[] attachments;
            for (IAttachment attachment : attachments = this.nativeItem.getAttachments()) {
                if (attachment == null) continue;
                gwAttachments.add(AbstractItem.createAttachmentFromgwAttachment(attachment));
            }
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
        this.setAttachments(gwAttachments);
    }

    private static GWAttachment createAttachmentFromgwAttachment(IAttachment theGwAttachment) {
        return new GWAttachment(theGwAttachment);
    }

    public String getHTMLBodyTextFile() {
        return this.nativeItem.saveBodyHtmlToTempFile();
    }

    private synchronized List<IRecipient> getRecipients() {
        if (this.recipientsList == null) {
            this.initRecipientsList();
        }
        return this.recipientsList;
    }

    public synchronized List<IRecipient> getRecipientsList() {
        return new ArrayList<IRecipient>(this.getRecipients());
    }

    private synchronized void initRecipientsList() {
        DistributionList distributionList = this.nativeItem.getDistributionList();
        int iSize = distributionList.getSize();
        this.recipientsList = new ArrayList(iSize);
        for (int i = 0; i < iSize; ++i) {
            IRecipient recipient = APIAbWrapperManager.getRecipient(distributionList.getRecipient(i));
            this.recipientsList.add(recipient);
        }
    }

    public boolean isHTMLMessage() {
        return this.nativeItem.isHTMLMessage();
    }

    public static int getSubType() {
        return -1;
    }

    public int getBoxType() {
        return this.nativeItem.getBoxType();
    }

    public DistributionList getDistributionList() {
        return this.nativeItem.getDistributionList();
    }

    public boolean canDoInfo() {
        return this.nativeItem.canDoInfo();
    }

    public boolean canOpen() {
        return this.nativeItem.canOpen();
    }

    public boolean canSave() {
        return this.nativeItem.canSave();
    }

    public boolean canPrint() {
        return this.nativeItem.canPrint();
    }

    public boolean canAccept() {
        return this.nativeItem.canAccept();
    }

    public boolean canDelete() {
        return this.nativeItem.canDelete();
    }

    public boolean canForward() {
        return this.nativeItem.canForward();
    }

    public boolean canDecline() {
        return this.nativeItem.canDecline();
    }

    public boolean canReply() {
        return this.nativeItem.canReply();
    }

    public boolean canResend() {
        return this.nativeItem.canResend();
    }

    public boolean canComplete() {
        return this.nativeItem.canComplete();
    }

    public boolean canMarkReadLater() {
        return this.nativeItem.canMarkReadLater();
    }

    public boolean canUnDelete() {
        return this.nativeItem.canUndelete();
    }

    public boolean canEmpty() {
        return this.nativeItem.canEmpty();
    }

    public boolean canMarkRead() {
        return this.nativeItem.canMarkRead();
    }

    public boolean canDeleteAndEmpty() {
        return this.nativeItem.canDeleteAndEmpty();
    }

    public void setNativeItem(T theNativeItem) {
        if (this.nativeItem == theNativeItem) {
            return;
        }
        boolean personalizeSubjectChanged = MessageUtils.isPersonalizeSubjectDifferent(theNativeItem, this.nativeItem);
        this.nativeItem = theNativeItem;
        if (personalizeSubjectChanged) {
            this.listSummaryValues.clear();
        }
    }

    public T getNativeItem() {
        return this.nativeItem;
    }

    @Override
    public IItem getNativeObject() {
        return this.nativeItem;
    }

    public boolean canDelegate() {
        return this.nativeItem.canDelegate();
    }

    public boolean isPersonal() {
        return this.nativeItem.isPersonal();
    }

    public synchronized void clear() {
        this.clearAttachments();
        this.recipientsList = null;
    }

    public boolean isDelegated() {
        return this.nativeItem instanceof INote && ((INote)this.nativeItem).isDelegated();
    }

    public boolean isForwarded() {
        return this.nativeItem.isForwarded();
    }

    public boolean isReplied() {
        return this.nativeItem.isRepliedTo();
    }

    public AbstractFolder getViewFolder(String userGuid) {
        return GWCommandManager.getInstance(userGuid).getGWFolder(this.nativeItem.getViewFolder());
    }

    public boolean hasSourceAttachment() {
        this.initAttachments();
        return this.nativeItem.hasSourceAttachment();
    }

    public boolean isDraft() {
        return this.nativeItem.isDraft();
    }

    public void setReplyFwdOriginalSenderDisplayNameText(String replyFwdOriginalSenderDisplayNameText) {
        this.replyFwdOriginalSenderDisplayNameText = replyFwdOriginalSenderDisplayNameText;
    }

    public int getTransferOptions(TransferItems theTransferData) {
        return this.nativeItem.getTransferOptions(theTransferData);
    }

    public boolean hasExtendedAttachments() {
        if (!this.hasPaperClipAttachments()) {
            for (GWAttachment attachment : this.getAttachments()) {
                if (attachment.isSystemAttachment()) continue;
                return true;
            }
        }
        return this.hasPaperClipAttachments();
    }

    public boolean canMarkPrivate() {
        return this.nativeItem.canMarkPrivate();
    }

    public void setSaved(boolean b) {
        this.saved = b;
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected static Notification getNotification(int notification) {
        boolean mail = notification == 1 || notification == 3;
        boolean notify = notification == 2 || notification == 3;
        return Notification.getNotification(mail, notify, false);
    }

    public void clearAttachments() {
        this.attachments = null;
    }

    public boolean addAttachment(AbstractItem theItem) {
        this.clearAttachments();
        return this.nativeItem.addAttachment((IMessage)theItem.nativeItem);
    }

    public boolean addAttachment(String theFileName) {
        this.clearAttachments();
        return this.nativeItem.addAttachment(theFileName);
    }

    public boolean deleteAttachment(GWAttachment theAttachment) {
        this.clearAttachments();
        return this.nativeItem.deleteAttachment(theAttachment.getNativeAttachment());
    }

    public void deleteAttachment(AbstractItem theAttachment) {
        this.clearAttachments();
        IAttachment[] attachments = this.nativeItem.getAttachments();
        int nCount = attachments.length;
        for (int i = 0; i < nCount; ++i) {
            IMessageAttachment messageAttachment;
            IAttachment attachment = attachments[i];
            if (!(attachment instanceof IMessageAttachment) || (messageAttachment = (IMessageAttachment)attachment).getMessage().getId() != theAttachment.nativeItem.getId()) continue;
            this.nativeItem.deleteAttachment(i);
        }
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setProcessing(boolean theProcessing) {
        this.processing = theProcessing;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public boolean isIMAPDeleted() {
        return this.nativeItem.isIMAPDeleted();
    }

    public boolean canReplyToOriginalTopic() {
        return this.nativeItem.canReplyToOriginalTopic();
    }

    public boolean transfer(TransferAttachments transferData, int actionMoveIntoFolder) {
        return this.nativeItem.transfer(transferData, actionMoveIntoFolder);
    }

    public boolean restore() {
        return this.nativeItem.restore();
    }

    public void markOpen() throws EngineException {
        this.nativeItem.markOpen();
    }

    public void markComplete(boolean completted) throws EngineException {
        this.nativeItem.markComplete(completted);
    }

    public boolean isReplyRequested() {
        return this.nativeItem.isReplyRequested();
    }

    public boolean isInChecklist() {
        return this.nativeItem.isInChecklist();
    }

    public boolean canShowInChecklist() {
        return this.nativeItem.canShowInChecklist();
    }

    public void showInChecklist(boolean b) {
        this.nativeItem.showInChecklist(b);
    }

    public boolean isChecklistDummyItem() {
        return this.nativeItem.isChecklistDummyItem();
    }

    public boolean canArchive() {
        return this.nativeItem.canArchive();
    }

    public ICategoryList getCategories() {
        return this.nativeItem.getCategories();
    }

    public void setCategories(ICategoryList categories) {
        this.nativeItem.setCategories(categories);
    }

    public IItem[] getArray() {
        this.thisItem[0] = this.nativeItem;
        return this.thisItem;
    }

    public void autoSave() {
        IMessage nativeItem = EngineCommandManager.setTextToNativeItem(this, true);
        EngineCommandManager.prepareNativeItem(this, nativeItem);
        nativeItem.autoSave();
    }

    public boolean hasCalendarDisplayColor() {
        return CategoryUtils.getPrimaryBackgroundColor(this.getCategories()) != null;
    }

    public Color getCalendarDisplayColor() {
        Color color = CategoryUtils.getPrimaryBackgroundColor(this.getCategories());
        if (color != null) {
            return color;
        }
        color = this.getFolder().getCalendarColor();
        if (color != null) {
            return color;
        }
        return Color.WHITE;
    }

    public Color getCalendarDisplayFinalGradientColor() {
        Color color = this.getCalendarDisplayColor();
        int max = Math.max(color.getBlue(), color.getGreen());
        max = Math.max(max, color.getRed());
        int min = Math.min(color.getBlue(), color.getGreen());
        int lum = (max + (min = Math.min(min, color.getRed()))) / 2;
        if (lum + lum * 60 / 100 < 240) {
            int g;
            int r;
            lum += lum * 60 / 100;
            int b = color.getBlue() + lum * 9 / 10;
            if (b > 255) {
                b = 255;
            }
            if ((r = color.getRed() + lum * 9 / 10) > 255) {
                r = 255;
            }
            if ((g = color.getGreen() + lum * 9 / 10) > 255) {
                g = 255;
            }
            return new Color(r, g, b);
        }
        return Color.WHITE;
    }

    public String getToolTipText() {
        return GWToolTip.getString(this);
    }

    public boolean isIgnoreMessageTypeOnCompose() {
        return this.ignoreMessageTypeOnCompose;
    }

    public void setIgnoreMessageTypeOnCompose(boolean ignoreMessageTypeOnCompose) {
        this.ignoreMessageTypeOnCompose = ignoreMessageTypeOnCompose;
    }

    public void setUserEnabledImages(boolean b) {
        this.nativeItem.setUserEnabledImages(b);
        this.getMessage().reload();
    }
}

