/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.util.Calendar;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskItem
extends AbstractCalendarItem<ITask> {
    private static Logger logger = Logger.getLogger(TaskItem.class);
    private long dateTaskAssigned;

    public TaskItem(ITask theNativeItem) {
        super(theNativeItem);
        if (this.endDate != null) {
            GWCalendarUtils.clearTime(this.endDate);
        }
        if (this.startDates != null) {
            for (Calendar date : this.startDates) {
                if (date == null) continue;
                GWCalendarUtils.clearTime(date);
            }
        }
    }

    protected TaskItem() {
        if (this.endDate != null) {
            GWCalendarUtils.clearTime(this.endDate);
        }
        if (this.startDates != null) {
            for (Calendar date : this.startDates) {
                if (date == null) continue;
                GWCalendarUtils.clearTime(date);
            }
        }
    }

    public String getTaskPriority() {
        int priority;
        ITask task = (ITask)this.getNativeItem();
        StringBuilder sb = new StringBuilder();
        char category = task.getTaskCategory();
        if (category != '\u0000') {
            sb.append(category);
        }
        if ((priority = task.getTaskPriority()) != 0) {
            sb.append(priority);
        }
        return sb.toString();
    }

    public void setTaskPriority(String taskPriority) {
        char category = 'A';
        int priority = 1;
        if (taskPriority != null && taskPriority.length() != 0) {
            boolean hasCategory = false;
            boolean hasPriority = false;
            StringBuilder sb = new StringBuilder();
            char[] arr$ = taskPriority.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character character = Character.valueOf(arr$[i$]);
                if (Character.isLetter(character.charValue())) {
                    if (!hasCategory) {
                        hasCategory = true;
                        category = character.charValue();
                    }
                    if (hasPriority) break;
                }
                if (hasCategory && Character.isDigit(character.charValue())) {
                    hasPriority = true;
                    sb.append(character);
                }
                if (sb.length() == 4) break;
            }
            if (hasCategory) {
                if (hasPriority) {
                    priority = sb.length() == 4 ? 999 : Integer.valueOf(sb.toString());
                }
            } else {
                int length = taskPriority.length();
                int neededLength = length > 3 ? 3 : length;
                priority = Integer.valueOf(taskPriority.substring(0, neededLength));
            }
        }
        ITask task = (ITask)this.getNativeItem();
        logger.debug((Object)("setTaskPriority(" + priority + "): " + task.setTaskPriority(priority)));
        logger.debug((Object)("setTaskCategory(" + category + "): " + task.setTaskCategory(category)));
    }

    public long getDateTaskAssigned() {
        return this.dateTaskAssigned;
    }

    public void setDateTaskAssigned(long theDateTaskAssigned) {
        this.dateTaskAssigned = theDateTaskAssigned;
    }

    @Override
    public void setComposeItemSendOptions(ComposeItemSendOptions options) {
        super.setComposeItemSendOptions(options);
        if (options != null && this.nativeItem instanceof ITask) {
            ((ITask)this.nativeItem).setNotifyWhenCompleted(options.getRNWhenCompleted().getValue());
        }
    }

    @Override
    public ComposeItemSendOptions getComposeItemSendOptions(ComposeItemSendOptions ciso) {
        if ((ciso = super.getComposeItemSendOptions(ciso)) != null) {
            ciso.setRNWhenCompleted(TaskItem.getNotification(((ITask)this.nativeItem).getNotifyWhenCompleted()));
        }
        return ciso;
    }

    @Override
    public String getType() {
        return "Task";
    }
}

