/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

public class TimeDuration
implements Cloneable {
    private int startMinutes;
    private int endMinutes;

    public TimeDuration(int theSartMinutes, int theEndMinuted) {
        this.startMinutes = theSartMinutes;
        this.endMinutes = theEndMinuted;
    }

    public void updateStartMinutes(int theStartMinutes) {
        this.endMinutes = theStartMinutes + this.getDuration();
        this.startMinutes = theStartMinutes;
        if (this.endMinutes > 1439) {
            this.endMinutes = 1439;
        }
    }

    public int getStartMinutes() {
        return this.startMinutes;
    }

    public int getEndMinutes() {
        return this.endMinutes;
    }

    public int getDuration() {
        return this.endMinutes - this.startMinutes;
    }

    public int getDays() {
        int mins = this.getDuration();
        return mins / 1440;
    }

    public int getHours() {
        int mins = this.getDuration();
        return mins % 1440 / 60;
    }

    public int getMinutes() {
        int mins = this.getDuration();
        return mins % 1440 % 60;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeDuration) {
            TimeDuration duration = (TimeDuration)obj;
            return duration.startMinutes == this.startMinutes && duration.endMinutes == this.endMinutes;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.startMinutes + this.endMinutes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TimeDuration.class.getSimpleName());
        builder.append('[');
        builder.append(this.startMinutes);
        builder.append(" - ");
        builder.append(this.endMinutes);
        builder.append(" (");
        builder.append(this.startMinutes / 60);
        builder.append(':');
        builder.append(this.startMinutes % 60);
        builder.append(" - ");
        builder.append(this.endMinutes / 60);
        builder.append(':');
        builder.append(this.endMinutes % 60);
        builder.append(", duration: ");
        builder.append(this.getDays());
        builder.append(" days, ");
        builder.append(this.getHours());
        builder.append(" hours, ");
        builder.append(this.getMinutes());
        builder.append(" minutes");
        builder.append(")]");
        return builder.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateDuration(int theDuration) {
        this.endMinutes = this.startMinutes + theDuration;
        if (this.endMinutes > 1439) {
            this.endMinutes = 1439;
        }
    }
}

