/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.frames.options.compose.dateAndTime.DateAndTimeElement;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.options.GWTimeZoneOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DateTimeOptions
extends Options {
    private static final Logger logger = Logger.getLogger(DateTimeOptions.class);
    private String dateFormat;
    private String fileInfoFormat;
    private String mainWindowFormat;
    private String propertiesFormat;
    private String timeFormat;
    private String longDateFormat;
    private String shortDateFormat;
    private DataStoreSettings dataStoreSettings = null;
    public static final String allHelp = "<html>\n<body bgcolor=\"#FFFFFF\">\n<table summary=\"\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" bgcolor=\"#FFFFFF\">\n\n\t<tr><th bgcolor=\"#ccccff\">Symbol</th><th bgcolor=\"#ccccff\">Meaning</th><th bgcolor=\"#ccccff\">Presentation</th><th bgcolor=\"#ccccff\">Example</th></tr>\n\n\t<tr bgcolor=\"#FFFFFF\"><td>G</td> <td>era designator</td> <td>Text</td> <td>AD</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">y</td> <td bgcolor=\"#eeeeff\">year</td><td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">1996</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>M</td> <td>month in year</td> <td>Text &amp; Number</td><td>July &amp; 07</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">d</td> <td bgcolor=\"#eeeeff\">day in month</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">10</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>h</td> <td>hour in am/pm (1-12)</td> <td>Number</td> <td>12</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">H</td> <td bgcolor=\"#eeeeff\">hour in day (0-23)</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">0</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>m</td> <td>minute in hour</td> <td>Number</td><td>30</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">s</td> <td bgcolor=\"#eeeeff\">second in minute</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">55</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>S</td> <td>millisecond</td> <td>Number</td> <td>978</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">E</td> <td bgcolor=\"#eeeeff\">day in week</td> <td bgcolor=\"#eeeeff\">Text</td> <td bgcolor=\"#eeeeff\">Tuesday</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>D</td> <td>day in year</td> <td>Number</td> <td>189</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">F</td> <td bgcolor=\"#eeeeff\">day of week in month</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">2 (2nd Wed in July)</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>w</td> <td>week in year</td> <td>Number</td> <td>27</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">W</td> <td bgcolor=\"#eeeeff\">week in month</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">2</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>a</td> <td>am/pm marker</td> <td>Text</td> <td>PM</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">k</td> <td bgcolor=\"#eeeeff\">hour in day (1-24)</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">24</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>K</td> <td>hour in am/pm (0-11)</td> <td>Number</td> <td>0</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">z</td> <td bgcolor=\"#eeeeff\">time zone</td> <td bgcolor=\"#eeeeff\">Text</td> <td bgcolor=\"#eeeeff\">Pacific Standard Time</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>'</td> <td>escape for text</td> <td>Delimiter</td> <td>(none)</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">'</td> <td bgcolor=\"#eeeeff\">single quote</td> <td bgcolor=\"#eeeeff\">Literal</td> <td bgcolor=\"#eeeeff\">'</td>\n\n</TABLE>\n</body>\n</html>";
    public static final String timeHelp = "<html>\n<body bgcolor=\"#FFFFFF\">\n<table summary=\"\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" bgcolor=\"#FFFFFF\">\n\n\t<tr><th bgcolor=\"#ccccff\">Symbol</th><th bgcolor=\"#ccccff\">Meaning</th><th bgcolor=\"#ccccff\">Presentation</th><th bgcolor=\"#ccccff\">Example</th></tr>\n\n\t<tr bgcolor=\"#FFFFFF\"><td>h</td> <td>hour in am/pm (1-12)</td> <td>Number</td> <td>12</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">H</td> <td bgcolor=\"#eeeeff\">hour in day (0-23)</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">0</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>m</td> <td>minute in hour</td> <td>Number</td><td>30</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">s</td> <td bgcolor=\"#eeeeff\">second in minute</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">55</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>S</td> <td>millisecond</td> <td>Number</td> <td>978</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">E</td> <td bgcolor=\"#eeeeff\">day in week</td> <td bgcolor=\"#eeeeff\">Text</td> <td bgcolor=\"#eeeeff\">Tuesday</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>a</td> <td>am/pm marker</td> <td>Text</td> <td>PM</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">k</td> <td bgcolor=\"#eeeeff\">hour in day (1-24)</td> <td bgcolor=\"#eeeeff\">Number</td> <td bgcolor=\"#eeeeff\">24</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>K</td> <td>hour in am/pm (0-11)</td> <td>Number</td> <td>0</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">z</td> <td bgcolor=\"#eeeeff\">time zone</td> <td bgcolor=\"#eeeeff\">Text</td> <td bgcolor=\"#eeeeff\">Pacific Standard Time</td></tr>\n\t<tr bgcolor=\"#FFFFFF\"><td>'</td> <td>escape for text</td> <td>Delimiter</td> <td>(none)</td></tr>\n\t<tr><td bgcolor=\"#eeeeff\">'</td> <td bgcolor=\"#eeeeff\">single quote</td> <td bgcolor=\"#eeeeff\">Literal</td> <td bgcolor=\"#eeeeff\">'</td>\n\n</TABLE>\n</body>\n</html>";
    private GWTimeZoneOptions gwTimeZoneOptions = new GWTimeZoneOptions();
    private static final String DAY_HEADER_PANEL_FORMAT = "dd MMM yyyy (E)";
    private String workstationTimeZoneLabel = "";
    private String alternateTimeZoneLabel = "";

    public final String getID() {
        return "Date & Time options";
    }

    public String getAlternateTimeZoneLabel() {
        return this.alternateTimeZoneLabel;
    }

    public void setAlternateTimeZoneLabel(String alternateTimeZoneLabel) {
        this.alternateTimeZoneLabel = alternateTimeZoneLabel;
    }

    public String getWorkstationTimeZoneLabel() {
        return this.workstationTimeZoneLabel;
    }

    public void setWorkstationTimeZoneLabel(String workstationTimeZoneLabel) {
        this.workstationTimeZoneLabel = workstationTimeZoneLabel;
    }

    public TimeZone getTimeZone() {
        return this.gwTimeZoneOptions.getSelectedTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.gwTimeZoneOptions.setSelectedTimeZone(timeZone);
    }

    public TimeZone getAlternateTimeZone() {
        return this.gwTimeZoneOptions.getAlternateTimeZone();
    }

    public void setAlternateTimeZone(TimeZone alternateTimeZone) {
        this.gwTimeZoneOptions.setAlternateTimeZone(alternateTimeZone);
    }

    public final GWTimeZoneOptions getTimeZoneOptions() {
        return this.gwTimeZoneOptions;
    }

    public final void setTimeZoneOptions(GWTimeZoneOptions theGWTimeZoneOptions) {
        this.gwTimeZoneOptions = theGWTimeZoneOptions;
    }

    public final DateTimeOptions clone() {
        DateTimeOptions dateTimeOptions = new DateTimeOptions();
        dateTimeOptions.dataStoreSettings = this.dataStoreSettings;
        dateTimeOptions.dateFormat = this.dateFormat;
        dateTimeOptions.fileInfoFormat = this.fileInfoFormat;
        dateTimeOptions.mainWindowFormat = this.mainWindowFormat;
        dateTimeOptions.propertiesFormat = this.propertiesFormat;
        dateTimeOptions.timeFormat = this.timeFormat;
        dateTimeOptions.longDateFormat = this.longDateFormat;
        dateTimeOptions.shortDateFormat = this.shortDateFormat;
        dateTimeOptions.gwTimeZoneOptions = this.gwTimeZoneOptions;
        return dateTimeOptions;
    }

    public String getTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.timeFormat, Locale.getDefault());
        String result = formatter.format(date);
        return result;
    }

    public String getGeneralDateString(Date date) {
        return DateAndTimeFormattingUtils.formatDate(date, this.dateFormat);
    }

    public String getMainWindowString(Date date) {
        return DateAndTimeFormattingUtils.formatDate(date, this.mainWindowFormat);
    }

    public String getPropertiesString(Date date) {
        return DateAndTimeFormattingUtils.formatDate(date, this.propertiesFormat);
    }

    public String getDayHeaderPanelString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DAY_HEADER_PANEL_FORMAT, Locale.getDefault());
        return dateFormat.format(date);
    }

    public static String getZoneAsGMTString(String theTimeZone) {
        Pattern strMatch = Pattern.compile("[\\(GMT]+[^\\)*]+[\\)]\\s*([\\w*]+)");
        Matcher m = strMatch.matcher(theTimeZone);
        if (m.find()) {
            String serverZona = m.group(1);
            if (serverZona.equals("Brasilia")) {
                serverZona = "DeNoronha";
            } else if (serverZona.equals("Greenland")) {
                serverZona = "South_Georgia";
            } else if (serverZona.equals("Mid")) {
                serverZona = "Scoresbysund";
            } else if (serverZona.equals("Greenwich")) {
                serverZona = "London";
            } else if (serverZona.equals("West")) {
                serverZona = "Addis_Ababa";
            } else if (serverZona.equals("Abu")) {
                serverZona = "Muscat";
            } else if (serverZona.equals("Islamabad")) {
                serverZona = "Kabul";
            } else if (serverZona.equals("Ekaterinburg")) {
                serverZona = "Yekaterinburg";
            } else if (serverZona.equals("Kathmandu")) {
                serverZona = "Katmandu";
            } else if (serverZona.equals("Astana")) {
                serverZona = "Dushanbe";
            } else if (serverZona.equals("Sri")) {
                serverZona = "Chagos";
            } else if (serverZona.equals("Beijing")) {
                serverZona = "Chongqing";
            } else if (serverZona.equals("Osaka")) {
                serverZona = "Tokyo";
            } else if (serverZona.equals("Nuku")) {
                serverZona = "Nauru";
            }
            String[] tz = TimeZone.getAvailableIDs();
            int x = -1;
            int k = tz.length;
            for (int j = 0; j < k; ++j) {
                if (tz[j].indexOf(serverZona) <= 0) continue;
                x = j;
                break;
            }
            if (x > 0) {
                return tz[x];
            }
            if (serverZona.equals("Eniwetok")) {
                return "Etc/GMT+12";
            }
        }
        return "error";
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        if (!DateAndTimeFormattingUtils.isFormatValid(timeFormat)) {
            throw new IllegalArgumentException("invalid format: " + timeFormat);
        }
        this.timeFormat = timeFormat;
    }

    public String getLongDateFormat() {
        return this.longDateFormat;
    }

    public void setLongDateFormat(String longDateFormat) {
        if (!DateAndTimeFormattingUtils.isFormatValid(longDateFormat)) {
            throw new IllegalArgumentException("invalid format: " + longDateFormat);
        }
        this.longDateFormat = longDateFormat;
    }

    public String getShortDateFormat() {
        return this.shortDateFormat;
    }

    public void setShortDateFormat(String shortDateFormat) {
        if (!DateAndTimeFormattingUtils.isFormatValid(shortDateFormat)) {
            throw new IllegalArgumentException("invalid format: " + shortDateFormat);
        }
        this.shortDateFormat = shortDateFormat;
    }

    public String getFileInfoFormat() {
        return this.fileInfoFormat;
    }

    public void setFileInfoFormat(String fileInfoFormat) {
        this.fileInfoFormat = fileInfoFormat;
    }

    public String getMainWindowFormat() {
        return this.mainWindowFormat;
    }

    public void setMainWindowFormat(String mainWindowFormat) {
        this.mainWindowFormat = mainWindowFormat;
    }

    public String getPropertiesFormat() {
        return this.propertiesFormat;
    }

    public void setPropertiesFormat(String propertiesFormat) {
        this.propertiesFormat = propertiesFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isDataStoreSettingsRead() {
        return this.dataStoreSettings != null;
    }

    public void readFromDataStoreSettings() {
        if (this.isDataStoreSettingsRead()) {
            throw new IllegalArgumentException("DataStoreSettings are read already");
        }
        this.dataStoreSettings = EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings();
        this.dateFormat = (String)this.dataStoreSettings.getDateTimeFormatDateDefault().getValue();
        this.fileInfoFormat = (String)this.dataStoreSettings.getDateTimeFormatFileInfoDefault().getValue();
        this.mainWindowFormat = (String)this.dataStoreSettings.getDateTimeFormatMainWindowDefault().getValue();
        this.propertiesFormat = (String)this.dataStoreSettings.getDateTimeFormatPropertiesDefault().getValue();
        this.timeFormat = (String)this.dataStoreSettings.getDateTimeFormatTimeDefault().getValue();
        if (DateAndTimeFormattingUtils.isShortDateFormat(this.dateFormat)) {
            this.shortDateFormat = this.dateFormat;
            if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.fileInfoFormat, this.timeFormat, this.shortDateFormat, null).containsElement(DateAndTimeElement.LONG_DATE)) {
                this.longDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.fileInfoFormat, this.timeFormat);
            } else if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.mainWindowFormat, this.timeFormat, this.shortDateFormat, null).containsElement(DateAndTimeElement.LONG_DATE)) {
                this.longDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.mainWindowFormat, this.timeFormat);
            } else if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.propertiesFormat, this.timeFormat, this.shortDateFormat, null).containsElement(DateAndTimeElement.LONG_DATE)) {
                this.longDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.propertiesFormat, this.timeFormat);
            } else if (this.longDateFormat == null) {
                this.longDateFormat = StringResources.LONG_DATE_TYPE_3;
            }
        } else {
            this.longDateFormat = this.dateFormat;
            if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.fileInfoFormat, this.timeFormat, null, this.longDateFormat).containsElement(DateAndTimeElement.SHORT_DATE)) {
                this.shortDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.fileInfoFormat, this.timeFormat);
            } else if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.mainWindowFormat, this.timeFormat, null, this.longDateFormat).containsElement(DateAndTimeElement.SHORT_DATE)) {
                this.shortDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.mainWindowFormat, this.timeFormat);
            } else if (DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.propertiesFormat, this.timeFormat, null, this.longDateFormat).containsElement(DateAndTimeElement.SHORT_DATE)) {
                this.shortDateFormat = DateAndTimeFormattingUtils.extractDateFormatFromDateTimeFormat(this.propertiesFormat, this.timeFormat);
            } else if (this.shortDateFormat == null) {
                this.shortDateFormat = StringResources.SHORT_DATE_TYPE_1;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"DateAndTimeOption read from DataStoreSettings:");
            this.printDebugInfo();
        }
    }

    public void writeToDataStoreSettings() {
        if (!this.isDataStoreSettingsRead()) {
            throw new IllegalStateException("DataStoreSettings are not read yet");
        }
        if (!this.dataStoreSettings.setDateTimeFormatTimeDefault(this.timeFormat)) {
            logger.debug((Object)("error in saving date : " + this.timeFormat));
        }
        if (!this.dataStoreSettings.setDateTimeFormatDateDefault(this.dateFormat)) {
            logger.debug((Object)("error in saving date : " + this.dateFormat));
        }
        if (!this.dataStoreSettings.setDateTimeFormatInfoDefault(this.fileInfoFormat)) {
            logger.debug((Object)("error in saving date : " + this.fileInfoFormat));
        }
        if (!this.dataStoreSettings.setDateTimeFormatMainWindowDefault(this.mainWindowFormat)) {
            logger.debug((Object)("error in saving date : " + this.mainWindowFormat));
        }
        if (!this.dataStoreSettings.setDateTimeFormatPropertiesDefault(this.propertiesFormat)) {
            logger.debug((Object)("error in saving date : " + this.propertiesFormat));
        }
        this.dataStoreSettings.syncWithDatabase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"DateAndTimeOption written to DataStoreSettings:");
            this.printDebugInfo();
        }
    }

    private void printDebugInfo() {
        logger.debug((Object)("this.dateFormat: " + this.dateFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.dateFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.fileInfoFormat: " + this.fileInfoFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.fileInfoFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.mainWindowFormat: " + this.mainWindowFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.mainWindowFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.propertiesFormat: " + this.propertiesFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.propertiesFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.timeFormat: " + this.timeFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.timeFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.longDateFormat: " + this.longDateFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.longDateFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
        logger.debug((Object)("this.shortDateFormat: " + this.shortDateFormat + '(' + (Object)((Object)DateAndTimeFormattingUtils.convertStringToDateAndTimeFormat(this.shortDateFormat, this.timeFormat, this.longDateFormat, this.shortDateFormat)) + ')'));
    }
}

