/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.appframework.components.htmleditor.ProxyConfiguration;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentView;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.UIColorOptions;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentOptions
extends Options {
    private UIColorOptions colorOptions;
    private int attachmentIconSizeID = 1;
    private Boolean headerAligned;
    private Boolean hideSystemAttachments;
    private boolean proxyEnabled = false;
    private boolean proxyAutoConfigured = true;
    private String proxyAutoConfigurationUrl = "";
    private String proxyManualConfigurationServer = "";
    private int proxyManualConfigurationPort = 0;
    private List<String> proxyBypassAddressList = new ArrayList<String>();

    public EnvironmentOptions() {
        this.colorOptions = new UIColorOptions();
    }

    @Override
    public String getID() {
        return "Environment options";
    }

    public UIColorOptions getColorOptions() {
        return this.colorOptions;
    }

    public int getAttachmentIconSizeID() {
        return this.attachmentIconSizeID;
    }

    public void setAttachmentIconSizeID(int theID) {
        this.attachmentIconSizeID = theID == 0 || theID == 1 || theID == 2 || theID == 3 ? theID : 1;
    }

    public void setHeaderAligned(Boolean theHeaderAligned) {
        this.headerAligned = theHeaderAligned;
    }

    public Boolean isHeaderAligned() {
        return this.headerAligned != null ? this.headerAligned : true;
    }

    public Boolean isHideSystemAttachments() {
        return this.hideSystemAttachments != null ? this.hideSystemAttachments : EmbededParentView.DEFAULT_HIDE_SYSTEM_ATTACHMENTS;
    }

    public void setHideSystemAttachments(boolean theHideSystemAttachments) {
        this.hideSystemAttachments = theHideSystemAttachments;
    }

    public void saveToProperties(SortedProperties properties) {
        properties.put((Object)"env.header.aligned", this.headerAligned);
        properties.put((Object)"env.hide_sys_att", this.hideSystemAttachments);
        properties.put((Object)"env.attachment_icon_size", this.attachmentIconSizeID);
        if (this.colorOptions != null) {
            properties.put((Object)"env.colors.inactive_selection.foreground", this.colorOptions.getInactiveSelectionForeground());
            properties.put((Object)"env.colors.inactive_selection.background", this.colorOptions.getInactiveSelectionBackground());
        }
    }

    public boolean isProxyAutoConfigured() {
        return this.proxyAutoConfigured;
    }

    public void setProxyAutoConfigured(boolean proxyAutoConfigured) {
        this.proxyAutoConfigured = proxyAutoConfigured;
    }

    public String getProxyAutoConfigurationUrl() {
        return this.proxyAutoConfigurationUrl;
    }

    public void setProxyAutoConfigurationUrl(String proxyAutoConfigurationUrl) {
        this.proxyAutoConfigurationUrl = proxyAutoConfigurationUrl;
    }

    public List<String> getProxyBypassAddressList() {
        return this.proxyBypassAddressList;
    }

    public void setProxyBypassAddressList(List<String> proxyBypassAddressList) {
        this.proxyBypassAddressList = proxyBypassAddressList;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public int getProxyManualConfigurationPort() {
        return this.proxyManualConfigurationPort;
    }

    public void setProxyManualConfigurationPort(int proxyManualConfigurationPort) {
        this.proxyManualConfigurationPort = proxyManualConfigurationPort;
    }

    public String getProxyManualConfigurationServer() {
        return this.proxyManualConfigurationServer;
    }

    public void setProxyManualConfigurationServer(String proxyManualConfigurationServer) {
        this.proxyManualConfigurationServer = proxyManualConfigurationServer;
    }

    public ProxyConfiguration getProxyConfiguration() {
        ProxyConfiguration configuration = new ProxyConfiguration();
        configuration.setProxyEnabled(this.proxyEnabled);
        configuration.setProxyAutoConfigured(this.proxyAutoConfigured);
        configuration.setProxyAutoConfigurationUrl(this.proxyAutoConfigurationUrl);
        configuration.setProxyManualConfigurationServer(this.proxyManualConfigurationServer);
        configuration.setProxyManualConfigurationPort(this.proxyManualConfigurationPort);
        ArrayList<String> bypassAddresses = new ArrayList<String>();
        for (String address : this.proxyBypassAddressList) {
            bypassAddresses.add(address);
        }
        configuration.setProxyBypassAddressList(bypassAddresses);
        return configuration;
    }

    @Override
    public Object clone() {
        EnvironmentOptions clone = new EnvironmentOptions();
        clone.colorOptions = this.colorOptions;
        clone.attachmentIconSizeID = this.attachmentIconSizeID;
        clone.headerAligned = this.headerAligned;
        clone.hideSystemAttachments = this.hideSystemAttachments;
        clone.proxyEnabled = this.proxyEnabled;
        clone.proxyAutoConfigured = this.proxyAutoConfigured;
        clone.proxyAutoConfigurationUrl = this.proxyAutoConfigurationUrl;
        clone.proxyManualConfigurationServer = this.proxyManualConfigurationServer;
        clone.proxyManualConfigurationPort = this.proxyManualConfigurationPort;
        clone.proxyBypassAddressList = new ArrayList<String>();
        clone.proxyBypassAddressList.addAll(this.proxyBypassAddressList);
        return clone;
    }
}

