/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options;

import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.bl.om.options.Options;

public class GeneralOptions
extends Options {
    private static final int MIN_ITEMS_COUNT = 25;
    private boolean showDeleteConfirmation = false;
    private boolean showSmartToolTip = false;
    private boolean isLocal = true;
    private int itemsCount = 25;
    private Language[] availableLanguages;
    private Language interfaceLanguage = new Language("en", "");
    private String selectedAddressBookID;
    private String selectedAddressSelectorBookID;
    private String WebRendererVersion;
    private int itemDeleteKey = 127;
    private boolean disableNameCompletion = false;
    private boolean disableQuickInfo = false;

    public String getID() {
        return "General options";
    }

    public boolean isDeleteConfirmationAllowed() {
        return this.showDeleteConfirmation;
    }

    public void setDeletionConfirmation(boolean b) {
        this.showDeleteConfirmation = b;
    }

    public boolean isSmartToolTipEnabled() {
        return this.showSmartToolTip;
    }

    public void setSmartToolTipEnabled(boolean enable) {
        this.showSmartToolTip = enable;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean b) {
        this.isLocal = b;
    }

    public int getItemsCount() {
        return this.itemsCount;
    }

    public void setItemsCount(int theItemsCount) {
        this.itemsCount = theItemsCount < 25 ? 25 : theItemsCount;
    }

    public static int getMinItemsCount() {
        return 25;
    }

    public void setAvailableLanguages(Language[] theLanguages) {
        this.availableLanguages = theLanguages;
    }

    public Language[] getAvailableLanguages() {
        Language[] languages;
        if (this.availableLanguages != null) {
            languages = new Language[this.availableLanguages.length];
            System.arraycopy(this.availableLanguages, 0, languages, 0, this.availableLanguages.length);
        } else {
            languages = new Language[]{};
        }
        return languages;
    }

    public void setInterfaceLanguage(Language theLanguage) {
        this.interfaceLanguage = theLanguage;
    }

    public Language getInterfaceLanguage() {
        return this.interfaceLanguage;
    }

    public String getSelectedAddressBookID() {
        return this.selectedAddressBookID;
    }

    public void setSelectedAddressBookID(String selectedAddressBookID) {
        this.selectedAddressBookID = selectedAddressBookID;
    }

    public String getSelectedAddressSelectorBookID() {
        return this.selectedAddressSelectorBookID;
    }

    public void setSelectedAddressSelectorBookID(String selectedAddressSelectorBookID) {
        this.selectedAddressSelectorBookID = selectedAddressSelectorBookID;
    }

    public Object clone() {
        GeneralOptions go = new GeneralOptions();
        go.showDeleteConfirmation = this.showDeleteConfirmation;
        go.showSmartToolTip = this.showSmartToolTip;
        go.isLocal = this.isLocal;
        go.itemsCount = this.itemsCount;
        go.selectedAddressBookID = this.selectedAddressBookID;
        go.selectedAddressSelectorBookID = this.selectedAddressSelectorBookID;
        go.interfaceLanguage = new Language(this.interfaceLanguage.getCode(), this.interfaceLanguage.getDisplayName());
        if (this.availableLanguages != null) {
            int length = this.availableLanguages.length;
            go.availableLanguages = new Language[length];
            System.arraycopy(this.availableLanguages, 0, go.availableLanguages, 0, length);
        }
        go.WebRendererVersion = this.WebRendererVersion;
        go.itemDeleteKey = this.itemDeleteKey;
        return go;
    }

    public String getWebRendererVersion() {
        return this.WebRendererVersion;
    }

    public void setWebRendererVersion(String webRendererVersion) {
        this.WebRendererVersion = webRendererVersion;
    }

    public int getItemDeleteKey() {
        return this.itemDeleteKey;
    }

    public void setItemDeleteKey(int itemDeleteKey) {
        this.itemDeleteKey = itemDeleteKey;
    }

    public boolean isDisabledNameCompletion() {
        return this.disableNameCompletion;
    }

    public void setDisabledNameCompletion(boolean disableNameCompletion) {
        this.disableNameCompletion = disableNameCompletion;
    }

    public boolean isDisableQuickInfo() {
        return this.disableQuickInfo;
    }

    public void setDisableQuickInfo(boolean disableQuickInfo) {
        this.disableQuickInfo = disableQuickInfo;
    }
}

