/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.UIColorOptions;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.SortedProperties;
import java.awt.Color;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentOptionsProperties
extends OptionsProperties<EnvironmentOptions> {
    private static Logger logger = Logger.getLogger(EnvironmentOptionsProperties.class);
    private static final String PREFIX = "env.";
    private static final String COLORS = "env.colors.";
    public static final String INACTIVE_SEL_FOREGR = "env.colors.inactive_selection.foreground";
    public static final String INACTIVE_SEL_BACKGR = "env.colors.inactive_selection.background";
    public static final String ATTACHMENT_ICON_SIZE = "env.attachment_icon_size";
    public static final String HEADER_ALIGNED = "env.header.aligned";
    public static final String HIDE_SYSTEM_ATTACHMENTS = "env.hide_sys_att";
    public static final String WEB_PROXY_PREFIX = "env.web_proxy.";
    public static final String PROXY_ENAMBED = "env.web_proxy.enabled";
    public static final String AUTO_CONFIGURED = "env.web_proxy.auto_configuration";
    public static final String AUTO_CONFIGURATION_URL = "env.web_proxy.auto_configuration_url";
    public static final String MANUAL_CONFIGURATION_SERVER = "env.web_proxy.manual_configuration_server";
    public static final String MANUAL_CONFIGURATION_PORT = "env.web_proxy.manual_configuration_port";
    public static final String BYPASS_ADDRESS_LIST = "env.web_proxy.bypass_address_list";

    @Override
    public Options readOptions(Properties theProperties) {
        EnvironmentOptions eo = new EnvironmentOptions();
        String value = theProperties.getProperty(ATTACHMENT_ICON_SIZE);
        if (value != null) {
            try {
                eo.setAttachmentIconSizeID(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(HEADER_ALIGNED)) != null) {
            try {
                eo.setHeaderAligned(EnvironmentOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(HIDE_SYSTEM_ATTACHMENTS)) != null) {
            try {
                eo.setHideSystemAttachments(EnvironmentOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        UIColorOptions co = eo.getColorOptions();
        value = theProperties.getProperty(INACTIVE_SEL_BACKGR);
        if (value != null) {
            try {
                co.setInactiveSelectionBackground(new Color(Integer.parseInt(value)));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(INACTIVE_SEL_FOREGR)) != null) {
            try {
                co.setInactiveSelectionForeground(new Color(Integer.parseInt(value)));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(PROXY_ENAMBED)) != null) {
            try {
                eo.setProxyEnabled(EnvironmentOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(AUTO_CONFIGURED)) != null) {
            try {
                eo.setProxyAutoConfigured(EnvironmentOptionsProperties.readBoolean(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(AUTO_CONFIGURATION_URL)) != null) {
            try {
                eo.setProxyAutoConfigurationUrl(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(MANUAL_CONFIGURATION_SERVER)) != null) {
            try {
                eo.setProxyManualConfigurationServer(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(MANUAL_CONFIGURATION_PORT)) != null) {
            try {
                eo.setProxyManualConfigurationPort(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((value = theProperties.getProperty(BYPASS_ADDRESS_LIST)) != null) {
            try {
                eo.setProxyBypassAddressList(EnvironmentOptionsProperties.readStringList(value, ","));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return eo;
    }

    @Override
    public Properties createProperties(EnvironmentOptions options) {
        EnvironmentProperties properties = new EnvironmentProperties();
        options.saveToProperties(properties);
        properties.put((Object)PROXY_ENAMBED, options.isProxyEnabled());
        properties.put((Object)AUTO_CONFIGURED, options.isProxyAutoConfigured());
        properties.put((Object)AUTO_CONFIGURATION_URL, options.getProxyAutoConfigurationUrl());
        properties.put((Object)MANUAL_CONFIGURATION_SERVER, options.getProxyManualConfigurationServer());
        properties.put((Object)MANUAL_CONFIGURATION_PORT, options.getProxyManualConfigurationPort());
        try {
            properties.put((Object)BYPASS_ADDRESS_LIST, this.writeStringList(options.getProxyBypassAddressList(), ","));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return properties;
    }

    protected static class EnvironmentProperties
    extends SortedProperties {
        protected EnvironmentProperties() {
        }

        public synchronized Object put(Object key, Object value) {
            if (value instanceof Color) {
                super.put(key, ((Color)value).getRGB());
                return null;
            }
            return super.put(key, value);
        }
    }
}

