/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.options.properties;

import com.novell.gw.jclient.bl.om.options.Options;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionsProperties<T extends Options> {
    public abstract Options readOptions(Properties var1);

    public abstract Properties createProperties(T var1);

    protected static boolean readBoolean(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        throw new IllegalArgumentException("For input string \"" + s + '\"');
    }

    protected static List<String> readStringList(String string, String delimiter) {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter is null");
        }
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("delimiter is empty");
        }
        return Arrays.asList(string.split(delimiter));
    }

    protected String writeStringList(List<String> list, String delimiter) {
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter is null");
        }
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException("delimiter is empty");
        }
        StringBuilder builder = new StringBuilder();
        boolean firstElement = true;
        for (String string : list) {
            if (!firstElement) {
                builder.append(delimiter);
            }
            if (string.contains(delimiter)) {
                throw new IllegalArgumentException("delimiter (" + delimiter + ") found in string: " + string);
            }
            builder.append(string);
            firstElement = false;
        }
        return builder.toString();
    }
}

