/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.search;

import com.appframework.cache.IdentifiedObject;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.search.AbstractItemCondition;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateCondition
extends AbstractItemCondition {
    private static Logger logger = Logger.getLogger(DateCondition.class);
    private long searchDate;
    private static final long day = 86400000L;

    public DateCondition(int theSearchConditionField, long theSearchDate) {
        super(theSearchConditionField);
        this.searchDate = theSearchDate;
    }

    public boolean check(IdentifiedObject theItem) {
        if (this.searchDate == 0L) {
            return false;
        }
        if (!(theItem instanceof AbstractItem)) {
            return false;
        }
        switch (this.conditionSign) {
            case 2: {
                if (((AbstractItem)theItem).getDate().getTime() < this.searchDate || ((AbstractItem)theItem).getDate().getTime() >= this.searchDate + 86400000L) break;
                return true;
            }
            case 3: {
                if (((AbstractItem)theItem).getDate().getTime() >= this.searchDate && ((AbstractItem)theItem).getDate().getTime() < this.searchDate + 86400000L) break;
                return true;
            }
            case 6: {
                if (this.searchDate < ((AbstractItem)theItem).getDate().getTime()) break;
                return true;
            }
            case 7: {
                if (this.searchDate >= ((AbstractItem)theItem).getDate().getTime()) break;
                return true;
            }
        }
        return false;
    }

    public Date getDate() {
        return new Date(this.searchDate);
    }
}

