/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.store;

import com.appframework.utils.UIUtils;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.store.GWItemFormatSerializer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PdfSerializer
extends GWItemFormatSerializer {
    private static Logger logger = Logger.getLogger(PdfSerializer.class);

    public PdfSerializer(AbstractItem theItem) {
        super(theItem);
    }

    protected String addTitleValue(String title, String value) {
        StringBuffer result = new StringBuffer();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            result.append(title);
            result.append(' ');
            result.append(value);
        } else {
            result.append(value);
            result.append(' ');
            result.append(title);
        }
        return result.toString();
    }

    public void save(String theFile) throws GWException {
        this.theMessage = this.getItemHeader(this.theItem, true);
        if (this.theItem.getMessage() != null) {
            this.theMessage = this.theMessage + this.theItem.getMessage().getPlainText();
        }
        this.theMessage = this.getAdditionalItemHeader(this.theItem, true, true, true, true) + this.theMessage;
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(theFile));
            document.open();
            document.add((Element)new Paragraph(this.theMessage));
        }
        catch (DocumentException de) {
            logger.debug((Object)"Document exception");
            throw new GWException(StringResources.CANT_EXPORT_TO_FILE);
        }
        catch (FileNotFoundException fnf) {
            logger.debug((Object)"File not found");
            throw new GWException(StringResources.CANT_WRITE_TO_FILE);
        }
        document.close();
    }
}

