/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CharChecker;
import azcheck.engine.CompiledTLex;
import azcheck.engine.CompositeTLex;
import azcheck.engine.DictionaryManager;
import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableTLex;
import azcheck.engine.EditableWord;
import azcheck.engine.SpellException;
import azcheck.engine.SuggestionBox;
import azcheck.engine.Suggestions;
import azcheck.engine.TLex;
import azcheck.util.CharSequence;
import azcheck.util.Logger;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpellChecker {
    public static final int ERR_NONE = 0;
    public static final int ERR_REPLACE = 1;
    public static final int ERR_UNKNOWN_WORD = 2;
    public static final int ERR_WRONG_CAP = 3;
    public static final int ERR_DUPLICATE = 4;
    public static final int ERR_PUNCTUATION = 5;
    public static final String TEMPORARY_DICT = "<temporary>";
    public static final String PERSONAL_DICT = "<personal>";
    public static final int SELECT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = -1;
    public static final int SAVE = 2;
    public static final int FORCE_DEFAULT = 3;
    public static final int FORCE_MAX = 5;
    public static final int FORCE_FASTER = 2;
    private boolean ignoreCase_ = false;
    private boolean ignoreMixedCase_ = false;
    private boolean ignoreDigits_ = true;
    private boolean ignoreURL_ = true;
    private boolean ignoreDuplicates_ = false;
    private boolean checkPunctuation_ = false;
    private boolean allowCompound_ = true;
    private boolean allowPrefixes_ = true;
    private boolean allowFileExt_ = true;
    private boolean autoReplace_ = true;
    private int suggestionForce_ = 3;
    private int suggestionLimit_ = 15;
    protected CharSequence inputSeq_;
    protected int inputSeqLen_;
    protected int wCursor_;
    protected int wLength_ = -1;
    private boolean boSentence_ = false;
    private int prevWordLength_;
    private char[] prevWord_ = new char[256];
    protected DictionaryManager dictManager_;
    protected DictionaryManagerItem[] languages_ = null;
    protected Vector langPool_ = new Vector();
    protected Lang curLang_;
    protected String prefsLang_ = null;
    protected String personalPath_ = null;
    protected EditableTLex fileExtensions_ = new EditableTLex("ext", null);
    protected Logger logger;
    private static final String LANG_MARK = "%L%";
    private static final String NO_LANGUAGE = "no language selected";
    private static final String[] CommonExtensions = new String[]{"asp", "au", "avi", "bat", "bin", "bmp", "c", "cab", "cc", "class", "com", "cpp", "css", "dat", "deb", "dll", "doc", "dtd", "dvi", "eps", "exe", "frm", "gif", "gz", "h", "hlp", "hh", "hpp", "htm", "html", "ini", "jar", "java", "jpe", "jpeg", "jpg", "js", "jsp", "latex", "mid", "mif", "mov", "mp2", "mp3", "mpe", "mpeg", "mpg", "pdf", "php", "png", "ppm", "ppt", "ps", "qt", "ra", "rf", "rgb", "rtf", "sgm", "sgml", "sh", "sys", "tar", "tcl", "tex", "tgz", "tif", "tiff", "txt", "wav", "xls", "xml", "xhtml", "vb", "vba", "z", "zip"};
    private static String urlChars1 = ".?:~";
    private static String urlChars2 = "/\\@_#";
    private static String puncts = ".,:;!?";
    private static String sentenceFinal = ".!?";

    public SpellChecker(String string) throws IOException {
        this.dictManager_ = new DictionaryManager(string);
        this.init();
    }

    public SpellChecker(DictionaryManager dictionaryManager) {
        this.dictManager_ = dictionaryManager;
        this.init();
    }

    public SpellChecker(SpellChecker spellChecker) {
        this.dictManager_ = spellChecker.getDictionaryManager();
        this.init();
        Properties properties = new Properties();
        spellChecker.saveOptions(properties);
        this.loadOptions(properties);
    }

    public SpellChecker() {
        this.dictManager_ = null;
        this.init();
    }

    public void setInput(CharSequence charSequence) {
        this.inputSeq_ = charSequence;
        this.inputSeqLen_ = charSequence.length();
        this.wCursor_ = 0;
        this.wLength_ = 0;
        this.prevWordLength_ = 0;
        this.boSentence_ = false;
    }

    public void setInput(String string) {
        this.setInput(new StringCharSeq(string));
    }

    public CharSequence getInput() {
        return this.inputSeq_;
    }

    public int checkNext() throws SpellException {
        this.wCursor_ += this.wLength_;
        int n = this.wCursor_;
        CharChecker charChecker = this.getCharChecker();
        while (this.wCursor_ < this.inputSeqLen_) {
            char c = this.inputSeq_.charAt(this.wCursor_);
            if (!charChecker.isWordStart(c)) {
                if (!Character.isWhitespace(c)) {
                    this.prevWordLength_ = 0;
                }
            } else {
                int n2;
                if (!this.punctuationOK(n, this.wCursor_)) {
                    return 5;
                }
                for (n2 = this.wCursor_ + 1; n2 < this.inputSeqLen_ && charChecker.isWordChar(this.inputSeq_.charAt(n2)); ++n2) {
                }
                while (n2 > this.wCursor_ && !charChecker.isWordEnd(this.inputSeq_.charAt(n2 - 1))) {
                    --n2;
                }
                this.wLength_ = n2 - this.wCursor_;
                if (this.wLength_ > 0 && this.wLength_ <= 256) {
                    int n3 = this.checkWord(this.inputSeq_, this.wCursor_, this.wLength_);
                    if (n3 != 0) {
                        return n3;
                    }
                    if (!this.ignoreDuplicates_) {
                        int n4 = this.wLength_;
                        if (this.prevWordLength_ == this.wLength_) {
                            while (--n4 >= 0 && this.inputSeq_.charAt(this.wCursor_ + n4) == this.prevWord_[n4]) {
                            }
                        }
                        for (int i = 0; i < this.wLength_; ++i) {
                            this.prevWord_[i] = this.inputSeq_.charAt(this.wCursor_ + i);
                        }
                        this.prevWordLength_ = this.wLength_;
                        if (n4 < 0) {
                            return 4;
                        }
                    }
                    this.boSentence_ = false;
                    n = n2;
                    this.wCursor_ = n2 - 1;
                }
            }
            ++this.wCursor_;
        }
        if (!this.punctuationOK(n, this.wCursor_)) {
            return 5;
        }
        return 0;
    }

    public int getPosition() {
        return this.wCursor_;
    }

    public String getWord() {
        char[] cArray = new char[this.wLength_];
        for (int i = 0; i < this.wLength_; ++i) {
            cArray[i] = this.inputSeq_.charAt(this.wCursor_ + i);
        }
        return new String(cArray);
    }

    public int checkWord(String string) throws SpellException {
        StringCharSeq stringCharSeq = new StringCharSeq(string);
        this.setInput(stringCharSeq);
        this.wLength_ = string.length();
        return this.checkWord(stringCharSeq, 0, this.wLength_);
    }

    public int checkWord(CharSequence charSequence, int n, int n2) throws SpellException {
        int n3;
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        if (n2 <= 1) {
            return 0;
        }
        byte by = TLex.capType(charSequence, n, n2);
        if (by == 3 && this.ignoreMixedCase_) {
            return 0;
        }
        if (this.ignoreDigits_) {
            n3 = n + n2;
            while (--n3 >= n && !Character.isDigit(charSequence.charAt(n3))) {
            }
            if (n3 >= n) {
                return 0;
            }
        }
        if (this.ignoreURL_ && this.looksLikeURL(charSequence, n, n2)) {
            return 0;
        }
        if (this.allowFileExt_) {
            n3 = n2;
            while (--n3 >= 0 && charSequence.charAt(n + n3) != '.') {
            }
            try {
                if (++n3 > 0 && this.fileExtensions_.lookup(charSequence, n + n3, n2 - n3) != null) {
                    return 0;
                }
            }
            catch (SpellException spellException) {
                // empty catch block
            }
        }
        if (this.autoReplace_ && this.curLang_.getReplacement(charSequence, n, n2) != null) {
            return 1;
        }
        n3 = this.curLang_.simpleSearch(charSequence, n, n2);
        if (n3 < 0) {
            if (this.curLang_.compoundSearch(charSequence, n, n2, this.allowCompound_, this.allowPrefixes_)) {
                return 0;
            }
            return 2;
        }
        if (!this.ignoreCase_ && (by < TLex.getWordType(n3) || this.boSentence_ && by == 0)) {
            return 3;
        }
        return 0;
    }

    public Suggestions getSuggestions() throws SpellException {
        return this.getSuggestions(this.inputSeq_, this.wCursor_, this.wLength_);
    }

    public Suggestions getSuggestions(String string) throws SpellException {
        return this.getSuggestions(new StringCharSeq(string), 0, string.length());
    }

    public Suggestions getSuggestions(CharSequence charSequence, int n, int n2) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        SuggestionBox suggestionBox = new SuggestionBox();
        suggestionBox.setWord(charSequence, n, n2);
        if (this.boSentence_) {
            suggestionBox.mustCapitalize();
        }
        if (n2 == 2 && this.isPunct(charSequence.charAt(n + 1))) {
            if (charSequence.charAt(n) != ' ') {
                suggestionBox.add(new String(new char[]{charSequence.charAt(n)}), 1);
            }
            suggestionBox.add(new String(new char[]{charSequence.charAt(n + 1)}), 1);
        } else {
            this.curLang_.approximateSearch(charSequence, n, n2, suggestionBox, this.suggestionForce_);
        }
        suggestionBox.selectBestSuggestions(this.suggestionLimit_);
        return suggestionBox;
    }

    public void learnWord(String string, String string2) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnWord(string, string2);
    }

    public void learnSuggestion(String string, String string2, String string3) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnSuggestion(string, string2, string3);
    }

    public void learnBannedWord(String string, String string2) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnBannedWord(string, string2);
    }

    public void learnAutoReplacement(String string, String string2, String string3) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.autoReplacement(string, string2, string3);
    }

    public String getReplacement(String string) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getReplacement(new StringCharSeq(string), 0, string.length());
    }

    public void setDictionaryPath(String string) throws IOException {
        this.dictManager_.setAccessPath(string);
    }

    public void addDictionaryPaths(String string) throws IOException {
        this.dictManager_.addAccessPaths(string);
    }

    public DictionaryManager getDictionaryManager() {
        return this.dictManager_;
    }

    public void setDictionaryManager(DictionaryManager dictionaryManager) {
        this.dictManager_ = dictionaryManager;
    }

    public DictionaryManagerItem[] listLanguages() throws IOException {
        return this.dictManager_.listLanguages();
    }

    public void setSelectedLanguage(String string) throws IOException, SpellException {
        if (this.curLang_ != null && this.curLang_.name.equals(string)) {
            return;
        }
        if (this.curLang_ != null) {
            this.curLang_.close();
        }
        this.curLang_ = this.findLanguage(DictionaryManager.getLanguage(string), true);
        if (this.curLang_.members_.size() == 0) {
            this.curLang_.loadDictionary(string);
        } else {
            this.curLang_.open();
        }
    }

    public String getPrefsLang_() {
        return this.prefsLang_;
    }

    public String getSelectedLanguage() {
        if (this.curLang_ == null) {
            return null;
        }
        return this.curLang_.name;
    }

    public DictionaryManagerItem getSelectedLanguageInfo() throws IOException {
        if (this.curLang_ == null) {
            return null;
        }
        return this.dictManager_.getLanguageInfo(this.curLang_.name);
    }

    public String getCopyright() {
        TLex tLex = this.curLang_ == null ? null : this.curLang_.getMember(0);
        if (tLex == null) {
            return null;
        }
        return tLex.getCopyright();
    }

    public void clearLanguageDictionaries() throws IOException, SpellException {
        if (this.curLang_ != null) {
            this.curLang_.clear(true);
        }
    }

    public void selectDictionary(String string) throws IOException, SpellException {
        if (this.curLang_ != null) {
            if (string.equals(this.curLang_.name)) {
                return;
            }
            this.curLang_.close();
        }
        this.curLang_ = this.findLanguage(DictionaryManager.getLanguage(string), true);
        this.curLang_.clear(false);
        this.curLang_.loadDictionary(string);
    }

    public void setPersonalDictionaryPath(String string) {
        this.personalPath_ = string;
    }

    public void savePersonalDictionaries() throws IOException {
        if (this.personalPath_ != null) {
            int n = this.langPool_.size();
            while (--n >= 0) {
                ((Lang)this.langPool_.elementAt(n)).savePDict(true);
            }
        }
    }

    public String[] listEditableDictionaries() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        String[] stringArray = new String[this.curLang_.eDicts_.size()];
        for (int i = 0; i < this.curLang_.eDicts_.size(); ++i) {
            stringArray[i] = ((EditableTLex)this.curLang_.eDicts_.get(i)).getLocation().toString();
        }
        return stringArray;
    }

    public boolean manageEditableDictionary(String string, int n) throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.manageEditableDictionary(string, n);
    }

    public EditableWord[] getEditableWords() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getEditableWords();
    }

    public void changeWord(EditableWord editableWord) throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.changeWord(editableWord);
    }

    public CharChecker getCharChecker() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getMember(0);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase_;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase_ = bl;
    }

    public boolean getIgnoreMixedCase() {
        return this.ignoreMixedCase_;
    }

    public void setIgnoreMixedCase(boolean bl) {
        this.ignoreMixedCase_ = bl;
    }

    public boolean getIgnoreDigits() {
        return this.ignoreDigits_;
    }

    public void setIgnoreDigits(boolean bl) {
        this.ignoreDigits_ = bl;
    }

    public boolean getIgnoreURL() {
        return this.ignoreURL_;
    }

    public void setIgnoreURL(boolean bl) {
        this.ignoreURL_ = bl;
    }

    public boolean getIgnoreDuplicates() {
        return this.ignoreDuplicates_;
    }

    public void setIgnoreDuplicates(boolean bl) {
        this.ignoreDuplicates_ = bl;
    }

    public boolean getCheckPunctuation() {
        return this.checkPunctuation_;
    }

    public void setCheckPunctuation(boolean bl) {
        this.checkPunctuation_ = bl;
    }

    public boolean getAutoReplace() {
        return this.autoReplace_;
    }

    public void setAutoReplace(boolean bl) {
        this.autoReplace_ = bl;
    }

    public int getSuggestionForce() {
        return this.suggestionForce_;
    }

    public void setSuggestionForce(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException();
        }
        this.suggestionForce_ = n;
    }

    public int getSuggestionLimit() {
        return this.suggestionLimit_;
    }

    public void setSuggestionLimit(int n) {
        this.suggestionLimit_ = n;
    }

    public boolean getAllowCompound() {
        return this.allowCompound_;
    }

    public void setAllowCompound(boolean bl) {
        this.allowCompound_ = bl;
    }

    public boolean getAllowPrefixes() {
        return this.allowPrefixes_;
    }

    public void setAllowPrefixes(boolean bl) {
        this.allowPrefixes_ = bl;
    }

    public boolean getAllowFileExtensions() {
        return this.allowFileExt_;
    }

    public void setAllowFileExtensions(boolean bl) {
        this.allowFileExt_ = bl;
    }

    public void addFileExtension(String string) {
        if (string.charAt(0) == '.') {
            string = string.substring(1);
        }
        try {
            this.fileExtensions_.addWord(string, (byte)1, null);
        }
        catch (SpellException spellException) {
            // empty catch block
        }
    }

    public void loadOptions(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            try {
                if (string.equals("azcheck.IgnoreCase")) {
                    this.ignoreCase_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.IgnoreMixedCase")) {
                    this.ignoreMixedCase_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.IgnoreDigits")) {
                    this.ignoreDigits_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.IgnoreURL")) {
                    this.ignoreURL_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.IgnoreDuplicates")) {
                    this.ignoreDuplicates_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.CheckPunctuation")) {
                    this.checkPunctuation_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.AllowCompound")) {
                    this.allowCompound_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.AllowPrefixes")) {
                    this.allowPrefixes_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.AllowFileExtensions")) {
                    this.allowFileExt_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.AutoReplace")) {
                    this.autoReplace_ = string2.equals("true");
                    continue;
                }
                if (string.equals("azcheck.SuggestionForce")) {
                    this.suggestionForce_ = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("azcheck.SuggestionLimit")) {
                    this.suggestionLimit_ = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equals("azcheck.Language")) continue;
                this.setSelectedLanguage(string2);
                this.prefsLang_ = string2;
            }
            catch (Exception exception) {}
        }
    }

    public void saveOptions(Properties properties) {
        properties.setProperty("azcheck.IgnoreCase", this.ignoreCase_ ? "true" : "false");
        properties.setProperty("azcheck.IgnoreMixedCase", this.ignoreMixedCase_ ? "true" : "false");
        properties.setProperty("azcheck.IgnoreDigits", this.ignoreDigits_ ? "true" : "false");
        properties.setProperty("azcheck.IgnoreURL", this.ignoreURL_ ? "true" : "false");
        properties.setProperty("azcheck.IgnoreDuplicates", this.ignoreDuplicates_ ? "true" : "false");
        properties.setProperty("azcheck.CheckPunctuation", this.checkPunctuation_ ? "true" : "false");
        properties.setProperty("azcheck.AllowCompound", this.allowCompound_ ? "true" : "false");
        properties.setProperty("azcheck.AllowPrefixes", this.allowPrefixes_ ? "true" : "false");
        properties.setProperty("azcheck.AllowFileExtensions", this.allowFileExt_ ? "true" : "false");
        properties.setProperty("azcheck.AutoReplace", this.autoReplace_ ? "true" : "false");
        properties.setProperty("azcheck.SuggestionForce", "" + this.suggestionForce_);
        properties.setProperty("azcheck.SuggestionLimit", "" + this.suggestionLimit_);
        properties.setProperty("azcheck.Language", this.curLang_ == null ? "" : this.curLang_.name);
    }

    private void init() {
        int n = CommonExtensions.length;
        while (--n >= 0) {
            this.addFileExtension(CommonExtensions[n]);
        }
    }

    Lang findLanguage(String string, boolean bl) throws IOException {
        this.languages_ = this.dictManager_.listLanguages();
        int n = this.languages_.length;
        while (--n >= 0 && !this.languages_[n].name.equals(string)) {
        }
        if (n < 0) {
            string = "unknown";
        }
        Lang lang = null;
        int n2 = this.langPool_.size();
        while (--n2 >= 0) {
            lang = (Lang)this.langPool_.get(n2);
            if (!lang.name.equals(string)) continue;
            return lang;
        }
        if (bl) {
            lang = new Lang(string);
            this.langPool_.addElement(lang);
            if (n >= 0 && this.languages_[n].encoding != null) {
                lang.encoding = this.languages_[n].encoding;
            }
        }
        return lang;
    }

    boolean looksLikeURL(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(n + i);
            if (urlChars1.indexOf(c) >= 0) {
                ++n3;
                continue;
            }
            if (urlChars2.indexOf(c) < 0) continue;
            ++n4;
        }
        return n3 > 1 || n4 > 0;
    }

    private boolean isPunct(char c) {
        return puncts.indexOf(c) >= 0;
    }

    boolean punctuationOK(int n, int n2) {
        this.boSentence_ = false;
        char c = '\u0000';
        for (int i = n; i < n2; ++i) {
            char c2 = this.inputSeq_.charAt(i);
            boolean bl = Character.isWhitespace(c2);
            if (sentenceFinal.indexOf(c2) >= 0) {
                this.boSentence_ = true;
            } else if (!bl) {
                this.boSentence_ = false;
            }
            if (this.checkPunctuation_ && !bl && this.isPunct(c2)) {
                if (c == ' ') {
                    this.wCursor_ = i - 1;
                    this.wLength_ = 2;
                    return false;
                }
                if (this.isPunct(c)) {
                    if (c == '.' && c2 == '.' && i + 1 < n2 && this.inputSeq_.charAt(i + 1) == '.') {
                        ++i;
                    } else {
                        this.wCursor_ = i - 1;
                        this.wLength_ = 2;
                        return false;
                    }
                }
            }
            c = c2;
        }
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.dictManager_ != null) {
            this.dictManager_.logger = logger;
        }
    }

    private void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }

    class Lang
    extends CompositeTLex {
        String name;
        String encoding;
        Vector eDicts_;
        int currentEdit_;

        Lang(String string) {
            super(string);
            this.encoding = "UTF8";
            this.eDicts_ = new Vector();
            this.currentEdit_ = -1;
            this.name = string;
        }

        void approximateSearch(CharSequence charSequence, int n, int n2, SuggestionBox suggestionBox, int n3) throws SpellException {
            super.approximateSearch(charSequence, n, n2, suggestionBox, n3);
            if (n3 <= 0) {
                return;
            }
            for (int i = 0; i < this.eDicts_.size(); ++i) {
                EditableTLex.Entry entry = ((EditableTLex)this.eDicts_.get(i)).lookup(charSequence, n, n2);
                if (entry == null || entry.type != 2) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(entry.value, "\t");
                while (stringTokenizer.hasMoreTokens()) {
                    suggestionBox.add(stringTokenizer.nextToken(), 0);
                }
            }
        }

        void learnWord(String string, String string2) throws SpellException {
            EditableTLex editableTLex = this.getEditableDict(string2);
            if (editableTLex == null) {
                throw new SpellException("no such dictionary: " + string2);
            }
            editableTLex.addWord(string, (byte)0, null);
        }

        void learnSuggestion(String string, String string2, String string3) throws SpellException {
            EditableTLex editableTLex = this.getEditableDict(string3);
            if (editableTLex == null) {
                throw new SpellException("no such dictionary: " + string3);
            }
            editableTLex.addWord(string, (byte)2, string2);
        }

        void learnBannedWord(String string, String string2) throws SpellException {
            EditableTLex editableTLex = this.getEditableDict(string2);
            if (editableTLex == null) {
                throw new SpellException("no such dictionary: " + string2);
            }
            editableTLex.addWord(string, (byte)3, null);
        }

        void autoReplacement(String string, String string2, String string3) throws SpellException {
            EditableTLex editableTLex = this.getEditableDict(string3);
            if (editableTLex == null) {
                throw new SpellException("no such dictionary: " + string3);
            }
            editableTLex.addWord(string, (byte)1, string2);
        }

        String getReplacement(CharSequence charSequence, int n, int n2) {
            for (int i = 0; i < this.eDicts_.size(); ++i) {
                try {
                    EditableTLex.Entry entry = ((EditableTLex)this.eDicts_.get(i)).lookup(charSequence, n, n2);
                    if (entry == null || entry.type != 1) continue;
                    return entry.value;
                }
                catch (SpellException spellException) {
                    return null;
                }
            }
            return null;
        }

        TLex loadDictionary(String string) throws IOException, SpellException {
            EditableTLex editableTLex;
            TLex tLex = SpellChecker.this.dictManager_.load(string, this.getMember(0));
            if (tLex instanceof EditableTLex) {
                this.eDicts_.add(tLex);
            }
            this.addMember(tLex);
            if (this.getEditableDict(SpellChecker.TEMPORARY_DICT) == null) {
                editableTLex = new EditableTLex(SpellChecker.TEMPORARY_DICT, tLex);
                this.addMember(editableTLex);
                this.eDicts_.add(editableTLex);
            }
            if (SpellChecker.this.personalPath_ != null && this.getEditableDict(SpellChecker.PERSONAL_DICT) == null) {
                editableTLex = new EditableTLex(SpellChecker.PERSONAL_DICT, tLex);
                this.eDicts_.add(editableTLex);
                this.addMember(editableTLex);
                this.readEditableDict(editableTLex, this.instantiatePDPath(), true);
            }
            return tLex;
        }

        void close() {
            for (int i = 0; i < this.members_.size(); ++i) {
                TLex tLex = (TLex)this.members_.get(i);
                if (!(tLex instanceof CompiledTLex)) continue;
                SpellChecker.this.dictManager_.releaseCompiledDictionary(tLex.getLocation());
                try {
                    ((CompiledTLex)tLex).setReader(null);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        void open() throws SpellException, IOException {
            for (int i = 0; i < this.members_.size(); ++i) {
                TLex tLex = (TLex)this.members_.get(i);
                if (!(tLex instanceof CompiledTLex)) continue;
                SpellChecker.this.dictManager_.reloadCompiledDictionary((CompiledTLex)tLex);
            }
        }

        void clear(boolean bl) throws IOException {
            this.savePDict(true);
            this.close();
            if (bl) {
                this.eDicts_.setSize(0);
            }
            this.members_.removeAllElements();
            if (!bl) {
                for (int i = 0; i < this.eDicts_.size(); ++i) {
                    this.members_.add(this.eDicts_.get(i));
                }
            }
        }

        EditableTLex getEditableDict(String string) {
            for (int i = 0; i < this.eDicts_.size(); ++i) {
                EditableTLex editableTLex = (EditableTLex)this.eDicts_.get(i);
                if (!string.equals(editableTLex.getLocation())) continue;
                return editableTLex;
            }
            return null;
        }

        boolean manageEditableDictionary(String string, int n) {
            if (string == null) {
                return false;
            }
            int n2 = this.eDicts_.size();
            while (--n2 >= 0 && !string.equals(((EditableTLex)this.eDicts_.get(n2)).getLocation())) {
            }
            switch (n) {
                case 0: {
                    if (n2 < 0) {
                        return false;
                    }
                    this.currentEdit_ = n2;
                    break;
                }
                case 1: {
                    try {
                        TLex tLex = SpellChecker.this.dictManager_.load(new URL("file:" + string), this.getMember(0));
                        if (!(tLex instanceof EditableTLex)) {
                            return false;
                        }
                        tLex.setLocation(string);
                        this.currentEdit_ = this.eDicts_.size();
                        this.eDicts_.add(tLex);
                        this.addMember(tLex);
                        break;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                case 2: {
                    if (n2 < 0 || string.equals(SpellChecker.TEMPORARY_DICT)) {
                        return false;
                    }
                    try {
                        if (string.equals(SpellChecker.PERSONAL_DICT)) {
                            this.savePDict(false);
                            break;
                        }
                        EditableTLex editableTLex = (EditableTLex)this.eDicts_.get(n2);
                        this.saveEditableDict(editableTLex, editableTLex.getLocation().toString());
                        break;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                case -1: {
                    if (n2 < 0) {
                        return false;
                    }
                    Object e = this.eDicts_.remove(n2);
                    this.members_.remove(e);
                    this.currentEdit_ = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("action");
                }
            }
            return true;
        }

        EditableWord[] getEditableWords() throws SpellException {
            if (this.currentEdit_ < 0) {
                throw new SpellException("no dictionary selected");
            }
            EditableTLex editableTLex = (EditableTLex)this.eDicts_.get(this.currentEdit_);
            return editableTLex.getEditableWords();
        }

        void changeWord(EditableWord editableWord) throws SpellException {
            if (this.currentEdit_ < 0) {
                throw new SpellException("no dictionary selected");
            }
            EditableTLex editableTLex = (EditableTLex)this.eDicts_.get(this.currentEdit_);
            if (editableWord.type == -1) {
                editableTLex.removeWord(editableWord.word);
            } else {
                editableTLex.addWord(editableWord.word, (byte)editableWord.type, editableWord.value, true);
            }
        }

        void savePDict(boolean bl) throws IOException {
            EditableTLex editableTLex = this.getEditableDict(SpellChecker.PERSONAL_DICT);
            if (editableTLex == null) {
                return;
            }
            String string = this.instantiatePDPath();
            if (bl) {
                this.readEditableDict(editableTLex, string, false);
            }
            this.saveEditableDict(editableTLex, string);
        }

        void saveEditableDict(EditableTLex editableTLex, String string) throws IOException {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), this.encoding));
            editableTLex.save(bufferedWriter);
            bufferedWriter.close();
        }

        void readEditableDict(EditableTLex editableTLex, String string, boolean bl) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), this.encoding));
                try {
                    editableTLex.load(bufferedReader, bl);
                }
                catch (SpellException spellException) {
                    // empty catch block
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String instantiatePDPath() {
            int n = SpellChecker.this.personalPath_.indexOf(SpellChecker.LANG_MARK);
            if (n < 0) {
                return SpellChecker.this.personalPath_ + "." + this.name;
            }
            return SpellChecker.this.personalPath_.substring(0, n) + this.name + SpellChecker.this.personalPath_.substring(n + SpellChecker.LANG_MARK.length());
        }
    }
}

