/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.Suggestions;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import azcheck.util.QuickSort;

public class SuggestionBox
implements Suggestions {
    protected String targetWord_;
    protected byte targetCap_;
    protected byte eSpace;
    protected byte eDash;
    protected TLex rules_;
    protected int suggestCnt_ = 0;
    protected Item[] suggestions_;
    static final int SUGGEST_MAX = 100;
    protected byte[] currentWord_;
    protected int cursor_;
    protected int cost_;
    protected int costMax_;
    protected int splitCount_ = 0;
    protected String suffix_;
    protected StringBuffer sbuffer_ = new StringBuffer();

    public String getWord() {
        return this.targetWord_;
    }

    public int getCount() {
        return this.suggestCnt_;
    }

    public String getSuggestion(int n) {
        return this.suggestions_[n].word;
    }

    public int getSuggestionPenalty(int n) {
        return this.suggestions_[n].cost;
    }

    public boolean contain(String string, int n) {
        int n2 = n < 0 || n > this.suggestCnt_ ? this.suggestCnt_ : n;
        for (int i = 0; i < n2; ++i) {
            if (!this.suggestions_[i].word.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String[] toArray() {
        String[] stringArray = new String[this.suggestCnt_];
        for (int i = 0; i < this.suggestCnt_; ++i) {
            stringArray[i] = this.getSuggestion(i);
        }
        return stringArray;
    }

    SuggestionBox() {
        this.suggestions_ = new Item[100];
        for (int i = 0; i < 100; ++i) {
            this.suggestions_[i] = new Item();
        }
        this.currentWord_ = new byte[256];
    }

    void setWord(CharSequence charSequence, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = charSequence.charAt(n + i);
        }
        this.targetWord_ = new String(cArray);
        this.targetCap_ = TLexRules.capType(charSequence, n, n2);
    }

    void mustCapitalize() {
        if (this.targetCap_ == 0) {
            this.targetCap_ = 1;
        }
    }

    void setCostMaximum(int n) {
        this.costMax_ = n;
    }

    void selectBestSuggestions(int n) {
        QuickSort.Compare compare = new QuickSort.Compare(){

            public int compare(Object object, Object object2) {
                Item item = (Item)object;
                Item item2 = (Item)object2;
                int n = item.cost - item2.cost;
                if (n != 0) {
                    return n;
                }
                return item.word.compareTo(item2.word);
            }
        };
        QuickSort.sort(this.suggestions_, 0, this.suggestCnt_ - 1, compare);
        if (this.suggestCnt_ > n) {
            this.suggestCnt_ = n;
        }
    }

    int getCursor() {
        return this.cursor_;
    }

    int getCost() {
        return this.cost_;
    }

    void back(int n, int n2) {
        this.cursor_ = n;
        this.cost_ = n2;
        if (this.cursor_ == 0 && this.cost_ == 0) {
            this.splitCount_ = 0;
        }
    }

    boolean put(byte by) {
        this.currentWord_[this.cursor_++] = by;
        return this.cost_ <= this.costMax_;
    }

    boolean put(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.currentWord_[this.cursor_ + i - n] = byArray[i];
        }
        this.cursor_ += n2 - n;
        return this.cost_ <= this.costMax_;
    }

    void dumpCurWord(int n) {
        for (int i = 0; i < this.cursor_; ++i) {
            if (i == n) {
                System.out.print(":");
            }
            System.out.print(this.rules_.decode(this.currentWord_[i]));
        }
        System.out.println();
    }

    boolean checkCost(int n) {
        return this.cost_ + n <= this.costMax_;
    }

    void putCost(int n) {
        this.cost_ += n;
    }

    int split(int n) {
        this.splitCount_ += n;
        return this.splitCount_;
    }

    void storeWord(int n) {
        if (n < 0) {
            return;
        }
        int n2 = TLex.getWordType(n);
        if (n2 > 0 && this.splitCount_ > 0) {
            this.cost_ += 27;
        }
        if (n2 < this.targetCap_ && this.targetCap_ != 3) {
            n2 = this.targetCap_;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == 1) {
            bl = true;
        } else if (n2 == 2) {
            bl2 = true;
        }
        this.sbuffer_.setLength(0);
        int n3 = 0;
        for (int i = 0; i < this.cursor_; ++i) {
            char c = this.rules_.decode(this.currentWord_[i]);
            if (c == ' ') {
                n3 = i + 1;
            }
            this.sbuffer_.append(bl2 || bl && i == 0 ? Character.toUpperCase(c) : c);
        }
        if (this.suffix_ != null) {
            if (this.suffix_.charAt(0) == '-' && this.sbuffer_.charAt(this.sbuffer_.length() - 1) == '-') {
                this.sbuffer_.append(this.suffix_.substring(1));
            } else {
                this.sbuffer_.append(this.suffix_);
            }
        }
        String string = new String(this.sbuffer_);
        if ((n & 8) != 0) {
            this.cost_ += -3;
        }
        this.add(string, this.cost_);
    }

    public void setSuffix(String string) {
        this.suffix_ = string;
    }

    public void add(String string, int n) {
        int n2 = this.suggestCnt_;
        while (--n2 >= 0) {
            if (!this.suggestions_[n2].word.equals(string)) continue;
            if (this.suggestions_[n2].cost > n) {
                this.suggestions_[n2].cost = n;
            }
            return;
        }
        if (this.suggestCnt_ < 100) {
            this.suggestions_[this.suggestCnt_].word = string;
            ++this.suggestCnt_;
            this.suggestions_[this.suggestCnt_].cost = n;
        } else {
            n2 = this.suggestCnt_;
            while (--n2 >= 0) {
                if (this.suggestions_[n2].cost <= n) continue;
                this.suggestions_[n2].word = string;
                this.suggestions_[n2].cost = n;
                break;
            }
        }
    }

    void setRules(TLex tLex) {
        this.rules_ = tLex;
        this.eSpace = this.rules_.encode(' ');
        this.eDash = this.rules_.encode('-');
    }

    static class Item {
        String word;
        int cost;

        Item() {
        }
    }
}

