/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierSnapin;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.Snapin;
import com.novell.application.console.snapin.context.ResultModifierSnapinContext;
import com.novell.application.console.snapin.context.SnapinContext;
import com.novell.application.console.snapin.scope.GlobalScope;
import com.novell.application.console.snapin.scope.Scope;
import com.novell.application.console.testing.C1Hooks;
import com.novell.utility.layouts.VerticalFlowLayout;
import com.novell.utility.localization.Loc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class ConsoleFilterDlg
extends JDialog
implements ActionListener,
KeyListener,
ComponentListener {
    private static final String DIALOG_TITLE = Resources.getString("ConsoleFilterDlgTitleKey");
    private static final String OK_BUTTON = Resources.getString("OKButtonKey");
    private static final String PREVIEW_BUTTON = Resources.getString("PreviewButtonKey");
    private static final String CANCEL_BUTTON = Resources.getString("CancelButtonKey");
    private static final String RESET_BUTTON = Resources.getString("ResetButtonKey");
    private static final String HELP_BUTTON = Resources.getString("HelpButtonKey");
    private JFrame m_parentFrame;
    private Component m_filterGUI;
    private JPanel m_filterGUIPanel;
    private JButton m_okButton = new JButton();
    private JButton m_previewButton = new JButton();
    private JButton m_cancelButton = new JButton();
    private JButton m_resetButton = new JButton();
    private JButton m_helpButton = new JButton();
    private ResultModifier m_rm;
    private ResultModifier m_rmOriginal;
    private ResultModifierSnapin m_rms;
    private String m_namespaceID;
    private ObjectEntry m_oe;
    private Shell m_theShell;
    private boolean m_bWaiting = false;

    private void layoutControls() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.m_filterGUIPanel = NConeFactory.novellJPanel(new JPanel(new BorderLayout()), "", "");
        this.m_filterGUIPanel.setOpaque(false);
        this.m_filterGUIPanel.add(this.m_filterGUI);
        JPanel jPanel = NConeFactory.novellJPanel(new JPanel(new VerticalFlowLayout()), "", "");
        jPanel.setOpaque(false);
        Loc.setText(this.m_okButton, OK_BUTTON);
        NConeFactory.novellJButton(this.m_okButton, Loc.removeHotChar(OK_BUTTON), "");
        this.m_okButton.addActionListener(this);
        this.m_okButton.setOpaque(true);
        jPanel.add(this.m_okButton);
        Loc.setText(this.m_cancelButton, CANCEL_BUTTON);
        NConeFactory.novellJButton(this.m_cancelButton, Loc.removeHotChar(CANCEL_BUTTON), "");
        this.m_cancelButton.addActionListener(this);
        this.m_cancelButton.setOpaque(true);
        jPanel.add(this.m_cancelButton);
        Loc.setText(this.m_previewButton, PREVIEW_BUTTON);
        NConeFactory.novellJButton(this.m_previewButton, Loc.removeHotChar(PREVIEW_BUTTON), "");
        this.m_previewButton.addActionListener(this);
        this.m_previewButton.setOpaque(true);
        jPanel.add(this.m_previewButton);
        Loc.setText(this.m_resetButton, RESET_BUTTON);
        NConeFactory.novellJButton(this.m_resetButton, Loc.removeHotChar(RESET_BUTTON), "");
        this.m_resetButton.addActionListener(this);
        this.m_resetButton.setOpaque(true);
        jPanel.add(this.m_resetButton);
        Loc.setText(this.m_helpButton, HELP_BUTTON);
        NConeFactory.novellJButton(this.m_helpButton, Loc.removeHotChar(HELP_BUTTON), "");
        this.m_helpButton.addActionListener(this);
        this.m_helpButton.setOpaque(true);
        jPanel.add(this.m_helpButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        container.add((Component)jPanel, "East");
        container.add((Component)this.m_filterGUIPanel, "Center");
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = new Rectangle();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.m_parentFrame == null || !this.m_parentFrame.isVisible() || this.m_parentFrame.getSize().width == 0 || this.m_parentFrame.getSize().height == 0) {
                rectangle.setBounds(0, 0, dimension.width, dimension.height);
            } else {
                rectangle = this.m_parentFrame.getBounds();
            }
            int n = Math.max(0, rectangle.x + (rectangle.width - this.getSize().width) / 2);
            int n2 = Math.max(0, rectangle.y + (rectangle.height - this.getSize().height) / 2);
            n = Math.min(n, dimension.width - this.getSize().width);
            n2 = Math.min(n2, dimension.height - this.getSize().height);
            ((Component)this).setLocation(n, n2);
            this.m_okButton.requestFocus();
        }
        super.setVisible(bl);
    }

    private void filter() {
        this.apply();
        this.close();
    }

    private void apply() {
        this.startWaitCursor();
        this.m_rm = this.m_rms.buildResultModifier();
        ObjectEntry objectEntry = this.m_rms.getCurrentContext();
        if (objectEntry != null && objectEntry != this.m_oe) {
            this.m_oe = objectEntry;
            this.m_namespaceID = this.m_oe.getNamespaceUniqueID();
        }
        this.refreshView();
        this.endWaitCursor();
    }

    private void cancel() {
        if (this.m_rm != this.m_rmOriginal) {
            this.m_rm = this.m_rmOriginal;
            this.refreshView();
        }
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.m_rms.shutdownSnapin();
        this.dispose();
    }

    private void reset() {
        this.startWaitCursor();
        Component component = this.m_filterGUI;
        this.m_filterGUI = this.m_rms.getUIComponent(this.m_oe, null);
        if (this.m_filterGUI != null) {
            component.removeComponentListener(this);
            component.removeKeyListener(this);
            this.m_filterGUI.addComponentListener(this);
            this.m_filterGUI.addKeyListener(this);
            this.m_filterGUIPanel.removeAll();
            this.m_filterGUIPanel.add(this.m_filterGUI);
            this.m_filterGUIPanel.revalidate();
            this.pack();
        } else {
            this.m_filterGUI = component;
            D.out("Filter Reset: null component received...");
        }
        this.endWaitCursor();
    }

    private void refreshView() {
        this.m_theShell.setFilterResultModifier(this.m_namespaceID, "Current", this.m_rm);
        this.startWaitCursor();
        this.m_theShell.refreshCurrentView();
        this.endWaitCursor();
    }

    private void help() {
        this.m_rms.showHelp();
    }

    void startWaitCursor() {
        if (!this.m_bWaiting) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_theShell.setCursor(Cursor.getPredefinedCursor(3));
            this.m_theShell.setBusy((Object)this, true, 3);
            this.m_bWaiting = true;
        }
    }

    void endWaitCursor() {
        if (this.m_bWaiting) {
            this.m_bWaiting = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.m_theShell.setCursor(Cursor.getPredefinedCursor(0));
            this.m_theShell.setBusy((Object)this, false, 3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_okButton) {
            this.filter();
        } else if (object == this.m_previewButton) {
            this.apply();
        } else if (object == this.m_cancelButton) {
            this.cancel();
        } else if (object == this.m_resetButton) {
            this.reset();
        } else if (object == this.m_helpButton) {
            this.help();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.cancel();
        } else if (keyEvent.getSource() == this.m_okButton) {
            this.filter();
        } else if (n == 112) {
            this.help();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.pack();
    }

    public ConsoleFilterDlg(ObjectEntry objectEntry, Shell shell, Frame frame, ResultModifierSnapin resultModifierSnapin, Object object) {
        super(frame, DIALOG_TITLE, true);
        this.m_theShell = shell;
        this.m_parentFrame = (JFrame)frame;
        this.startWaitCursor();
        this.m_rms = resultModifierSnapin;
        this.m_oe = objectEntry;
        this.m_namespaceID = this.m_oe.getNamespaceUniqueID();
        this.m_rmOriginal = this.m_rm = this.m_theShell.getFilterResultModifier(this.m_namespaceID, "Current");
        ResultModifierSnapinContext resultModifierSnapinContext = new ResultModifierSnapinContext(1, object, this);
        this.m_rms.initSnapin(new InitSnapinInfo(shell, (Object)Shell.SNAPIN_RESULTMODIFIER, (SnapinContext)resultModifierSnapinContext));
        this.m_filterGUI = this.m_rms.getUIComponent(this.m_oe, this.m_rm);
        if (this.m_filterGUI == null) {
            this.m_rms.shutdownSnapin();
            Snapin[] snapinArray = shell.loadSnapins((Scope)new GlobalScope(Shell.SNAPIN_RESULTMODIFIER));
            this.m_rms = (ResultModifierSnapin)snapinArray[0];
            this.m_rms.initSnapin(new InitSnapinInfo(shell, (Object)Shell.SNAPIN_RESULTMODIFIER, (SnapinContext)resultModifierSnapinContext));
            this.m_filterGUI = this.m_rms.getUIComponent(this.m_oe, this.m_rm);
        }
        this.m_filterGUI.addKeyListener(this);
        this.m_filterGUI.addComponentListener(this);
        this.layoutControls();
        if (this.m_rms.hasHelp()) {
            this.m_helpButton.setEnabled(true);
        } else {
            this.m_helpButton.setEnabled(false);
        }
        this.pack();
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.setName("ConsoleFilterDlg");
        C1Hooks.registerWindow(this);
        this.m_okButton.setName("OK");
        this.m_cancelButton.setName("Cancel");
        this.m_previewButton.setName("Preview");
        this.m_resetButton.setName("Reset");
        this.m_helpButton.setName("Help");
        this.setResizable(false);
        this.endWaitCursor();
    }
}

