/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ConsoleSearchDlgEntryTextAddin;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.EmptyObjectEntryEnumeration;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierSnapin;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.Snapin;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.context.ResultModifierSnapinContext;
import com.novell.application.console.snapin.context.SnapinContext;
import com.novell.application.console.snapin.scope.GlobalScope;
import com.novell.application.console.snapin.scope.Scope;
import com.novell.application.console.testing.C1Hooks;
import com.novell.application.console.util.vlist.VList;
import com.novell.utility.layouts.VerticalFlowLayout;
import com.novell.utility.localization.Loc;
import com.novell.utility.nmsgbox.NMsgBox;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public final class ConsoleSearchDlg
extends JDialog
implements ActionListener,
KeyListener,
ComponentListener {
    private static final int RESULT_HEIGHT = 200;
    private static final int RESULT_WIDTH = 500;
    private static final String DIALOG_TITLE = Resources.getString("ConsoleSearchDlgTitleKey");
    private static final String SEARCH_BUTTON = Resources.getString("ConsoleSearchButtonKey");
    private static final String CLOSE_BUTTON = Resources.getString("CloseButtonKey");
    private static final String RESET_BUTTON = Resources.getString("ResetButtonKey");
    private static final String HELP_BUTTON = Resources.getString("HelpButtonKey");
    private static final String RESULTS_TITLE = Resources.getString("ConsoleSearchResultsTitleKey");
    private static final String RESULTS_NOTHING_FOUND = Resources.getString("ConsoleSearchResultsNothingFoundKey");
    private static boolean m_bDlgAlreadyActive = false;
    private JFrame m_parentFrame;
    private Component m_findGUI;
    private JPanel m_findGUIPanel;
    private JComboBox m_searchCriteria;
    private VList m_results;
    private JPanel m_resultsPanel;
    private JPanel m_topContainer;
    private JButton m_searchButton = new JButton();
    private JButton m_closeButton = new JButton();
    private JButton m_helpButton = new JButton();
    private JButton m_resetButton = new JButton();
    private ResultModifier m_rm;
    private ResultModifierSnapin m_rms;
    private String m_namespaceID;
    private ObjectEntry m_oe;
    private ObjectEntry m_oeOriginal;
    private Shell m_theShell;
    private boolean m_bWaiting = false;

    public static boolean isAlreadyActive() {
        return m_bDlgAlreadyActive;
    }

    public void dispose() {
        m_bDlgAlreadyActive = false;
        super.dispose();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.dispose();
        }
        super.processEvent(aWTEvent);
    }

    private void layoutControls() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.m_findGUIPanel = NConeFactory.novellJPanel(new JPanel(new BorderLayout()), "", "");
        JPanel jPanel3 = NConeFactory.novellJPanel(new JPanel(new VerticalFlowLayout()), "", "");
        jPanel = NConeFactory.novellJPanel(jPanel, "", "");
        this.m_resultsPanel = NConeFactory.novellJPanel(new JPanel(new BorderLayout()), "", "");
        this.m_findGUIPanel.setOpaque(false);
        this.m_findGUIPanel.add((Component)jPanel2, "North");
        this.m_findGUIPanel.add(this.m_findGUI, "Center");
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        Loc.setText(this.m_searchButton, SEARCH_BUTTON);
        this.m_searchButton.addActionListener(this);
        this.m_searchButton.setOpaque(true);
        jPanel3.add(this.m_searchButton);
        Loc.setText(this.m_closeButton, CLOSE_BUTTON);
        this.m_closeButton.addActionListener(this);
        this.m_closeButton.setOpaque(true);
        jPanel3.add(this.m_closeButton);
        Loc.setText(this.m_resetButton, RESET_BUTTON);
        this.m_resetButton.addActionListener(this);
        this.m_resetButton.setOpaque(true);
        jPanel3.add(this.m_resetButton);
        Loc.setText(this.m_helpButton, HELP_BUTTON);
        this.m_helpButton.addActionListener(this);
        this.m_helpButton.setOpaque(true);
        jPanel3.add(this.m_helpButton);
        jPanel.add((Component)this.m_findGUIPanel, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.m_results = new VList();
        this.m_results.setShell(this.m_theShell);
        ConsoleSearchDlg consoleSearchDlg = this;
        if (consoleSearchDlg == null) {
            throw null;
        }
        this.m_results.addMouseListener(consoleSearchDlg.new MouseViewListener());
        this.m_results.enableStatusBarCount(false);
        this.m_resultsPanel.setPreferredSize(new Dimension(500, 200));
        this.m_resultsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_resultsPanel.add((Component)this.m_results, "Center");
        this.m_resultsPanel.setOpaque(false);
        container.add((Component)jPanel, "North");
        container.add((Component)this.m_resultsPanel, "Center");
    }

    public Shell getShell() {
        return this.m_theShell;
    }

    public void refreshResults() {
        if (this.m_results != null && this.m_results.isVisible()) {
            this.search();
        }
    }

    ObjectEntryCollection getSelectedObjects() {
        return this.m_results.getSelectedObjects();
    }

    void showContextMenu(int n, int n2) {
        JPopupMenu jPopupMenu;
        ObjectEntryCollection objectEntryCollection;
        if (this.m_results.locationToObject(new Point(n, n2)) != null && !(objectEntryCollection = this.getSelectedObjects()).hasNoElements() && (jPopupMenu = this.m_theShell.getPopupMenu(objectEntryCollection)) != null && jPopupMenu.getComponentCount() > 0) {
            int n3 = 2;
            int n4 = 0;
            Utilities.showPopup(jPopupMenu, this.m_results.getContentComponent(), n + n3, n2 + n4);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setDlgLocation();
            this.m_searchButton.requestFocus();
        }
        super.setVisible(bl);
    }

    public void setDlgLocation() {
        Rectangle rectangle = new Rectangle();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.m_resultsPanel.getSize();
        if (this.m_parentFrame == null || !this.m_parentFrame.isVisible() || this.m_parentFrame.getSize().width == 0 || this.m_parentFrame.getSize().height == 0) {
            rectangle.setBounds(0, 0, dimension.width, dimension.height);
        } else {
            rectangle = this.m_parentFrame.getBounds();
            if (!this.m_resultsPanel.isVisible()) {
                rectangle.height -= 200;
            }
        }
        int n = Math.max(0, rectangle.x + (rectangle.width - dimension2.width) / 2);
        int n2 = Math.max(0, rectangle.y + (rectangle.height - dimension2.height) / 2);
        n = Math.min(n, dimension.width - dimension2.width);
        n2 = Math.min(n2, dimension.height - dimension2.height);
        ((Component)this).setLocation(n, n2);
    }

    private void search() {
        boolean bl = true;
        ObjectEntry objectEntry = null;
        ObjectEntryEnumeration objectEntryEnumeration = null;
        this.startWaitCursor();
        this.m_rm = this.m_rms.buildResultModifier();
        objectEntry = this.m_rms.getCurrentContext();
        if (objectEntry != null && objectEntry != this.m_oe) {
            this.m_oe = objectEntry;
            this.m_namespaceID = this.m_oe.getNamespaceUniqueID();
            this.setTitle(DIALOG_TITLE + this.m_oe.getFullName());
        }
        this.m_theShell.setSearchResultModifier(this.m_namespaceID, "Current", this.m_rm);
        try {
            objectEntryEnumeration = this.m_theShell.getChildren(this.m_oe, this.m_rm);
        }
        catch (SnapinException snapinException) {
            Utilities.handleException(snapinException);
            objectEntryEnumeration = new EmptyObjectEntryEnumeration();
        }
        if (objectEntryEnumeration == null || !objectEntryEnumeration.hasMoreElements()) {
            bl = false;
        }
        this.m_results.setModel(objectEntryEnumeration);
        this.m_results.setFiltered(this.m_rm.getFiltered());
        if (this.m_rm.isSubContainerSearch()) {
            this.m_results.setVListEntryTextSnapin(new ConsoleSearchDlgEntryTextAddin(this.m_theShell, 2));
        } else {
            this.m_results.setVListEntryTextSnapin(new ConsoleSearchDlgEntryTextAddin(this.m_theShell, 1));
        }
        this.m_results.enableStatusBarCount(true);
        this.pack();
        this.endWaitCursor();
        if (!bl) {
            NMsgBox nMsgBox = new NMsgBox(this, RESULTS_TITLE, RESULTS_NOTHING_FOUND, 1);
            int n = nMsgBox.launch();
            this.setMyFocus();
        }
    }

    private void setMyFocus() {
        Container container = this;
        while (!(container instanceof JFrame)) {
            if (container instanceof JDialog) {
                container.requestFocus();
                break;
            }
            container = container.getParent();
        }
    }

    private void close() {
        this.setVisible(false);
        ShellStubs.searchDlg = null;
        this.dispose();
        this.m_rms.shutdownSnapin();
    }

    private void reset() {
        this.startWaitCursor();
        if (this.m_oe != this.m_oeOriginal) {
            this.m_oe = this.m_oeOriginal;
            this.m_namespaceID = this.m_oe.getNamespaceUniqueID();
            this.setTitle(DIALOG_TITLE + this.m_oe.getFullName());
        }
        Component component = this.m_findGUI;
        this.m_findGUI = this.m_rms.getUIComponent(this.m_oe, null);
        if (this.m_findGUI != null) {
            component.removeComponentListener(this);
            component.removeKeyListener(this);
            this.m_findGUI.addComponentListener(this);
            this.m_findGUI.addKeyListener(this);
            this.m_findGUIPanel.removeAll();
            this.m_findGUIPanel.add(this.m_findGUI);
            this.m_findGUIPanel.revalidate();
            this.m_results.setModel(null);
            this.m_results.setFiltered(0);
            this.m_results.enableStatusBarCount(false);
            this.pack();
        } else {
            this.m_findGUI = component;
            D.out("Find Reset: null component received...");
        }
        this.endWaitCursor();
    }

    private void help() {
        this.m_rms.showHelp();
        this.requestFocus();
    }

    void startWaitCursor() {
        if (!this.m_bWaiting) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_theShell.setCursor(Cursor.getPredefinedCursor(3));
            this.m_theShell.setBusy((Object)this, true, 3);
            this.m_bWaiting = true;
        }
    }

    void endWaitCursor() {
        if (this.m_bWaiting) {
            this.m_bWaiting = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.m_theShell.setCursor(Cursor.getPredefinedCursor(0));
            this.m_theShell.setBusy((Object)this, false, 3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_searchButton) {
            this.search();
            this.m_results.requestFocus();
        } else if (object == this.m_closeButton) {
            this.close();
        } else if (object == this.m_resetButton) {
            this.reset();
        } else if (object == this.m_helpButton) {
            this.help();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.close();
        } else if (n == 10 && keyEvent.getSource() == this) {
            this.search();
        } else if (n == 112) {
            this.help();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this.m_findGUI) {
            this.pack();
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + dimension.width > dimension2.width || point.y + dimension.height > dimension2.height) {
                this.setDlgLocation();
            }
        } else if (componentEvent.getComponent() == this && this.m_resultsPanel.isVisible()) {
            this.m_resultsPanel.setPreferredSize(this.m_resultsPanel.getSize());
        }
    }

    public ConsoleSearchDlg(ObjectEntry objectEntry, Shell shell, Frame frame, ResultModifierSnapin resultModifierSnapin, Object object) {
        super(frame, DIALOG_TITLE + objectEntry.getFullName(), false);
        this.enableEvents(64L);
        this.m_theShell = shell;
        this.m_parentFrame = (JFrame)frame;
        this.startWaitCursor();
        this.m_rms = resultModifierSnapin;
        this.m_oe = this.m_oeOriginal = objectEntry;
        this.m_namespaceID = this.m_oe.getNamespaceUniqueID();
        this.m_rm = this.m_theShell.getSearchResultModifier(this.m_namespaceID, "Current");
        ResultModifierSnapinContext resultModifierSnapinContext = new ResultModifierSnapinContext(2, object, this);
        this.m_rms.initSnapin(new InitSnapinInfo(shell, (Object)Shell.SNAPIN_RESULTMODIFIER, (SnapinContext)resultModifierSnapinContext));
        this.m_findGUI = this.m_rms.getUIComponent(this.m_oe, this.m_rm);
        if (this.m_findGUI == null) {
            this.m_rms.shutdownSnapin();
            Snapin[] snapinArray = shell.loadSnapins((Scope)new GlobalScope(Shell.SNAPIN_RESULTMODIFIER));
            this.m_rms = (ResultModifierSnapin)snapinArray[0];
            this.m_rms.initSnapin(new InitSnapinInfo(shell, (Object)Shell.SNAPIN_RESULTMODIFIER, (SnapinContext)resultModifierSnapinContext));
            this.m_findGUI = this.m_rms.getUIComponent(this.m_oe, this.m_rm);
        }
        this.m_findGUI.addKeyListener(this);
        this.m_findGUI.addComponentListener(this);
        this.layoutControls();
        if (this.m_rms.hasHelp()) {
            this.m_helpButton.setEnabled(true);
        } else {
            this.m_helpButton.setEnabled(false);
        }
        this.pack();
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.setName("ConsoleSearchDlg");
        C1Hooks.registerWindow(this);
        this.m_results.setName("Results");
        this.m_searchButton.setName("Find");
        NConeFactory.novellJButton(this.m_searchButton, this.m_searchButton.getName(), "");
        this.m_closeButton.setName("Close");
        NConeFactory.novellJButton(this.m_closeButton, this.m_closeButton.getName(), "");
        this.m_helpButton.setName("Help");
        NConeFactory.novellJButton(this.m_helpButton, this.m_helpButton.getName(), "");
        this.m_resetButton.setName("Reset");
        NConeFactory.novellJButton(this.m_resetButton, this.m_resetButton.getName(), "");
        this.setResizable(true);
        m_bDlgAlreadyActive = true;
        this.endWaitCursor();
    }

    class MouseViewListener
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                ConsoleSearchDlg.this.showContextMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                VList vList;
                ObjectEntry objectEntry;
                boolean bl;
                boolean bl2 = (mouseEvent.getModifiers() & 0x10) != 0;
                boolean bl3 = bl = mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isShiftDown();
                if (bl2 && !bl && (objectEntry = (vList = (VList)mouseEvent.getComponent()).locationToObject(new Point(mouseEvent.getX(), mouseEvent.getY()))) != null) {
                    ConsoleSearchDlg.this.m_theShell.executeDefaultPopupMenuItemAction(objectEntry);
                }
            }
        }

        MouseViewListener() {
        }
    }
}

