/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.ClassSorter;
import com.novell.application.console.shell.Constants;
import com.novell.application.console.shell.D;
import com.novell.application.console.shell.DefaultSnapinLister;
import com.novell.application.console.shell.Manifest;
import com.novell.application.console.shell.NonGuiShellStubs;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.shell.SnapinClassLoader;
import com.novell.application.console.shell.SnapinCollectionInfo;
import com.novell.application.console.shell.SnapinLister;
import com.novell.application.console.shell.Utilities;
import com.novell.application.console.snapin.Registration;
import com.novell.application.console.snapin.RegistrationItem;
import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Sorting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class ConsoleSnapinLister
implements SnapinLister {
    public static boolean nonGuiMode = false;
    static String[] snapinDirs = Constants.SnapinDirectoriesKey;
    static final String[] libDirs = Constants.LibDirectoriesKey;
    static SnapinClassLoader snapinClassLoader = DefaultSnapinLister.snapinClassLoader;
    private Array m_scisArray = new Array();
    private SnapinCollectionInfo[] m_scis = null;
    private Hashtable m_snapinNodes = new Hashtable();
    private String language;
    private String languageCountry;
    private static /* synthetic */ Class class$Lcom$novell$application$console$shell$SnapinCollectionInfo;
    private static /* synthetic */ Class class$Lcom$novell$application$console$snapin$Registration;

    public void initLister() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("consoleone.app.dir", "");
        String string2 = string + File.separator + "snapins" + File.separator + "core";
        String string3 = string + File.separator + "resources" + File.separator + "core";
        D.out("appPath = " + string);
        D.out("coreSnapinPath = " + string2);
        D.out("coreResourcesPath = " + string3);
        try {
            File file = new File(string2 + File.separator + "Console.jar");
            String string4 = file.getCanonicalPath();
            Array array = new Array();
            array.add((Object)string4);
            this.m_snapinNodes.put(file, array);
            snapinClassLoader.addSnapinPathFile(string4);
        }
        catch (IOException iOException) {
            D.reportException("IOException trying to add Console snapin to classpath - " + iOException, iOException);
        }
        this.miniResDredge(string3);
        if (!NonGuiShellStubs.alreadyInitialized) {
            try {
                URL.setURLStreamHandlerFactory(snapinClassLoader);
            }
            catch (Error error) {
                D.out("Error trying to setURLStreamHandlerFactory - " + error);
            }
        }
    }

    private void miniResDredge(String string) {
        D.out("\nminiResDredge: resDir=" + string);
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2;
                File file2 = new File(string, stringArray[n]);
                if (file2.isFile() && Utilities.isFileZipOrJar(stringArray[n]) && ((string2 = stringArray[n].toLowerCase()).startsWith("consoleoneresources") || string2.startsWith("consoleresources")) && this.checkForLanguageJar(file2)) {
                    D.out("   core res entry: " + stringArray[n]);
                    try {
                        snapinClassLoader.addSnapinPathFile(file2.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        D.reportException("IOException trying to add core resource jar to classpath - " + iOException, iOException);
                    }
                }
                ++n;
            }
        }
    }

    private boolean checkForLanguageJar(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        int n2 = n - 3;
        if (n2 > 0 && string.charAt(n2) == '_') {
            Object object;
            if (this.language == null) {
                object = ShellStubs.getLocale();
                this.language = "_" + ((Locale)object).getLanguage().toUpperCase();
                this.languageCountry = this.language + "_" + ((Locale)object).getCountry().toUpperCase();
            }
            object = string.substring(0, n);
            int n3 = ((String)(object = ((String)object).toUpperCase())).length();
            int n4 = n3 - 6;
            if (n4 > 0 && ((String)object).charAt(n4) == '_' ? !((String)object).endsWith(this.languageCountry) : !((String)object).endsWith(this.language)) {
                return false;
            }
        }
        return true;
    }

    public SnapinCollectionInfo[] getSnapinCollections() {
        if (this.m_scis == null) {
            this.loadSCIs();
            this.m_scis = (SnapinCollectionInfo[])Utilities.jglArrayToArray(this.m_scisArray, class$Lcom$novell$application$console$shell$SnapinCollectionInfo != null ? class$Lcom$novell$application$console$shell$SnapinCollectionInfo : (class$Lcom$novell$application$console$shell$SnapinCollectionInfo = ConsoleSnapinLister.class$("com.novell.application.console.shell.SnapinCollectionInfo")));
        }
        return this.m_scis;
    }

    public ClassLoader getClassLoader() {
        return snapinClassLoader;
    }

    void loadSCIs() {
        Object object;
        if (this.m_snapinNodes.isEmpty()) {
            object = Resources.getString("NoSnapinsMessageKey", "No snapins found.  Exiting...");
            System.out.println((String)object);
            System.exit(1);
        }
        object = this.m_snapinNodes.keys();
        while (object.hasMoreElements()) {
            File file = (File)object.nextElement();
            Array array = (Array)this.m_snapinNodes.get(file);
            if (array.size() == 0) continue;
            int n = 0;
            while (n < array.size()) {
                File file2 = new File((String)array.at(n));
                SnapinCollectionInfo snapinCollectionInfo = this.loadSCI(file2);
                if (snapinCollectionInfo != null) {
                    RegistrationItem[] registrationItemArray = snapinCollectionInfo.getRegistrationItems();
                    if (registrationItemArray != null && registrationItemArray.length > 0) {
                        this.m_scisArray.add((Object)snapinCollectionInfo);
                    } else {
                        D.out("Snapin Collection ignored... no registration items found.");
                    }
                }
                ++n;
            }
        }
    }

    SnapinCollectionInfo loadSCI(File file) {
        int n;
        RegistrationItem[] registrationItemArray;
        SnapinCollectionInfo snapinCollectionInfo = null;
        Array array = new Array();
        Manifest manifest = this.getManifest(file);
        if (manifest != null) {
            snapinCollectionInfo = manifest.getPackageInfo();
            if (snapinCollectionInfo.getPackageName() != null && snapinCollectionInfo.getPackageName().equals("")) {
                D.out("Invalid manifest, no header information for " + file.getAbsolutePath());
            }
        } else {
            snapinCollectionInfo = new SnapinCollectionInfo(null);
        }
        if (file.isFile() && Utilities.isFileZipOrJar((String)(registrationItemArray = new String(file.getPath())))) {
            int n2 = n = manifest != null && !manifest.isAutoRegister() ? 0 : 1;
            if (n == 0) {
                D.out("Processing manifest for registrars in " + file);
                array = this.processManifest(manifest);
            } else {
                D.out("Auto detecting registrars in " + file);
                try {
                    ZipFile zipFile = new ZipFile(file);
                    array = this.autoRegister(zipFile);
                    Sorting.sort((Sequence)array, (BinaryPredicate)new ClassSorter());
                }
                catch (ZipException zipException) {
                    D.reportException("ZipException reading jar/zip " + (String)registrationItemArray + " - " + zipException, zipException);
                }
                catch (IOException iOException) {
                    D.reportException("IOException reading jar/zip " + (String)registrationItemArray + " - " + iOException, iOException);
                }
            }
        }
        if ((registrationItemArray = new RegistrationItem[array.size()]) != null) {
            n = 0;
            while (n < registrationItemArray.length) {
                registrationItemArray[n] = (RegistrationItem)array.at(n);
                registrationItemArray[n].setClassLoader(snapinClassLoader);
                ++n;
            }
            snapinCollectionInfo.setRegistrationItems(registrationItemArray);
        }
        return snapinCollectionInfo;
    }

    Manifest getManifest(File file) {
        String string;
        Manifest manifest = null;
        if (file.isFile() && Utilities.isFileZipOrJar(string = new String(file.getPath()))) {
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (zipEntry != null) {
                    D.out("\n>>> Creating manifest object for " + string);
                    manifest = new Manifest(zipFile.getInputStream(zipEntry));
                } else {
                    D.out("\n>>> Could not find manifest in " + string + ", ConsoleOne will auto detect snapins");
                }
            }
            catch (ZipException zipException) {
                D.reportException("ZipException reading jar/zip " + string + " - " + zipException, zipException);
            }
            catch (IOException iOException) {
                D.reportException("IOException reading jar/zip " + string + " - " + iOException, iOException);
            }
        }
        return manifest;
    }

    Array processManifest(Manifest manifest) {
        Array array = new Array();
        Enumeration enumeration = manifest.getOrderedRegistrars();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Array array2 = new Array();
            D.out("    Loading registrar -> " + string);
            try {
                String string2 = ConsoleSnapinLister.changeToLoaderName(string);
                Registration registration = (Registration)snapinClassLoader.loadClass(string2).newInstance();
                array2 = this.retrieveRegistrationItems(registration);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                D.out("NoSuchMethodError while trying to instantiate registrar " + string + " - " + noSuchMethodError);
            }
            catch (ClassCastException classCastException) {
                D.reportException("ClassCastException while trying to instantiate registrar " + string + ", it may not implement RegistrationItem - " + classCastException, classCastException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                D.reportException("ClassNotFoundException while trying to instantiate registrar " + string + " - " + classNotFoundException, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                D.reportException("InstantiationException while trying to instantiate registrar " + string + " - " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                D.reportException("IllegalAccessException while trying to instantiate registrar " + string + " - " + illegalAccessException, illegalAccessException);
            }
            catch (Exception exception) {
                D.reportException("Exception while trying to instantiate registrar " + string + " - " + exception, exception);
            }
            this.combineArrays(array, array2);
        }
        return array;
    }

    private static String changeToLoaderName(String string) {
        String string2 = string.replace('/', '.');
        if ((string2 = string2.replace('\\', '.')).endsWith(".class")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        return string2.trim();
    }

    void combineArrays(Array array, Array array2) {
        int n = 0;
        while (n < array2.size()) {
            array.add(array2.at(n));
            ++n;
        }
    }

    Array autoRegister(ZipFile zipFile) {
        Array array = new Array();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ZipEntry zipEntry = null;
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            Array array2 = this.checkForRegistration(string);
            this.combineArrays(array, array2);
        }
        return array;
    }

    Array checkForRegistration(String string) {
        Class clazz;
        Array array = new Array();
        Class<?> clazz2 = null;
        Class<?>[] classArray = null;
        Object var5_5 = null;
        boolean bl = false;
        Class clazz3 = clazz = class$Lcom$novell$application$console$snapin$Registration != null ? class$Lcom$novell$application$console$snapin$Registration : (class$Lcom$novell$application$console$snapin$Registration = ConsoleSnapinLister.class$("com.novell.application.console.snapin.Registration"));
        if (string.endsWith(".class")) {
            try {
                clazz2 = snapinClassLoader.loadClass(ConsoleSnapinLister.changeToLoaderName(string));
                classArray = clazz2.getInterfaces();
                int n = 0;
                while (n < classArray.length) {
                    if (classArray[n] == clazz) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    Class<?> clazz4 = clazz2.getSuperclass();
                    while (!bl && clazz4 != null) {
                        classArray = clazz4.getInterfaces();
                        int n2 = 0;
                        while (n2 < classArray.length) {
                            if (classArray[n2] == clazz) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        clazz4 = clazz4.getSuperclass();
                    }
                }
            }
            catch (IllegalAccessError illegalAccessError) {
                D.reportException("IllegalAccessError occured while loading " + string + " - " + illegalAccessError, illegalAccessError);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                D.reportException("NoClassDefFoundError occured while loading " + string + " - " + noClassDefFoundError, noClassDefFoundError);
            }
            catch (ClassNotFoundException classNotFoundException) {
                D.reportException("ClassNotFoundException trying to load " + string + " - " + classNotFoundException, classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                D.reportException("NoSuchMethodError trying to load " + string + " - " + noSuchMethodError, noSuchMethodError);
            }
            catch (Exception exception) {
                D.reportException("Exception trying to load " + string + " - " + exception, exception);
            }
        }
        if (bl) {
            D.out("    Loading registrar -> " + clazz2);
            try {
                if (var5_5 == null) {
                    var5_5 = clazz2.newInstance();
                }
                array = this.retrieveRegistrationItems(var5_5);
            }
            catch (InstantiationException instantiationException) {
                D.reportException("InstantiationException while trying to instantiate " + string + " - " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                D.reportException("IllegalAccessException while trying to instantiate " + string + " - " + illegalAccessException, illegalAccessException);
            }
            catch (Exception exception) {
                D.reportException("Exception while trying to instantiate " + string + " - " + exception, exception);
            }
        }
        return array;
    }

    Array retrieveRegistrationItems(Registration registration) {
        Array array = new Array();
        RegistrationItem[] registrationItemArray = new RegistrationItem[]{};
        try {
            registrationItemArray = registration.getRegistration();
        }
        catch (Exception exception) {
            D.out("Exception occured in getRegistration() for class " + registration.getClass().getName());
            D.reportSnapinError(exception);
        }
        if (registrationItemArray != null) {
            int n = 0;
            while (n < registrationItemArray.length) {
                if (registrationItemArray[n] != null) {
                    registrationItemArray[n].setRegistrarName(registration.getClass().getName());
                    array.add((Object)registrationItemArray[n]);
                } else {
                    D.out("Returned a null registration item in array from " + registration.getClass().getName());
                }
                ++n;
            }
        }
        return array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ConsoleSnapinLister() {
    }
}

