/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.PlaceholderNamespace;
import com.novell.application.console.shell.Registry;
import com.novell.application.console.shell.Resources;
import com.novell.application.console.shell.ShellNamespace;
import com.novell.application.console.shell.ShellStubs;
import com.novell.application.console.snapin.DisplayIconSnapin;
import com.novell.application.console.snapin.DisplayNameSnapin;
import com.novell.application.console.snapin.DisplayNameSnapinRev2;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import com.novell.application.console.snapin.scope.GlobalScope;
import com.novell.application.console.snapin.scope.NamespaceScope;
import com.novell.application.console.snapin.scope.NamespaceTypeScope;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class DisplayHelper {
    static final String TOKEN_SEPARATOR = "%";
    static final Icon defaultUnknownIcon = new ImageIcon(Resources.getImage("UnknownObjectIcon.gif"));
    static final Icon specialNullObjectTypeIcon = new ImageIcon(Resources.getImage("UnknownObjectTypeIcon.gif"));
    static final Icon shortcut = new ImageIcon(Resources.getImage("Shortcut.gif"));
    static Hashtable icons = new Hashtable();
    static Hashtable nameSnapins = new Hashtable();
    static Hashtable noSnapins = new Hashtable();
    static Hashtable iconSnapins = new Hashtable();

    static String getDisplayName(ObjectEntry objectEntry, int n) {
        ObjectType objectType = objectEntry.getObjectType();
        String string = null;
        String string2 = objectType.getKey();
        if (noSnapins.containsKey(string2)) {
            if (n == 2) {
                return objectEntry.getNamespace().getFullName(objectEntry);
            }
            return objectEntry.getName();
        }
        DisplayNameSnapin displayNameSnapin = (DisplayNameSnapin)nameSnapins.get(string2);
        if (displayNameSnapin != null) {
            try {
                string = DisplayHelper.getNameHelper(displayNameSnapin, objectEntry, n);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (string != null) {
                return string;
            }
        }
        if (objectEntry.getName().equals("@My World!")) {
            return ShellNamespace.getTopName();
        }
        Array array = null;
        DisplayNameSnapin displayNameSnapin2 = null;
        String string3 = objectType.getName();
        String string4 = objectType.getNamespace().getUniqueID();
        InitSnapinInfo initSnapinInfo = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_DISPLAYNAME);
        array = Registry.getSnapins(new NamespaceTypeScope(Shell.SNAPIN_DISPLAYNAME, string4, string3), initSnapinInfo);
        int n2 = 0;
        while (n2 < array.size() && string == null) {
            displayNameSnapin2 = (DisplayNameSnapin)array.at(n2);
            try {
                string = DisplayHelper.getNameHelper(displayNameSnapin2, objectEntry, n);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            ++n2;
        }
        if (string == null) {
            array = Registry.getSnapins(new NamespaceScope(Shell.SNAPIN_DISPLAYNAME, string4), initSnapinInfo);
            n2 = 0;
            while (n2 < array.size() && string == null) {
                displayNameSnapin2 = (DisplayNameSnapin)array.at(n2);
                try {
                    string = DisplayHelper.getNameHelper(displayNameSnapin2, objectEntry, n);
                }
                catch (Exception exception) {
                    D.reportSnapinError(exception);
                }
                ++n2;
            }
            if (string == null) {
                array = Registry.getSnapins(new GlobalScope(Shell.SNAPIN_DISPLAYNAME), initSnapinInfo);
                n2 = 0;
                while (n2 < array.size() && string == null) {
                    displayNameSnapin2 = (DisplayNameSnapin)array.at(n2);
                    try {
                        string = DisplayHelper.getNameHelper(displayNameSnapin2, objectEntry, n);
                    }
                    catch (Exception exception) {
                        D.reportSnapinError(exception);
                    }
                    ++n2;
                }
                if (string == null) {
                    if (objectEntry.getObjectType().isShortcut()) {
                        ObjectEntry objectEntry2 = ShellStubs.dereferenceShortcut(objectEntry);
                        if (objectEntry2 != null) {
                            String string5 = DisplayHelper.getDisplayName(objectEntry2, n);
                            if (string5 != null) {
                                return string5;
                            }
                        } else {
                            D.out("Error dereferencing shortcut to get display name, dereference returned null for " + objectEntry + ", using shortcut name.");
                        }
                    }
                    noSnapins.put(string2, "");
                    if (n == 2) {
                        return objectEntry.getNamespace().getFullName(objectEntry);
                    }
                    return objectEntry.getName();
                }
            }
        }
        if (displayNameSnapin2 != null) {
            nameSnapins.put(string2, displayNameSnapin2);
        }
        return string;
    }

    static String getDisplayName(String string, String string2) {
        Array array = null;
        String string3 = null;
        InitSnapinInfo initSnapinInfo = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_DISPLAYNAME);
        array = Registry.getSnapins(new NamespaceTypeScope(Shell.SNAPIN_DISPLAYNAME, string, string2), initSnapinInfo);
        string3 = DisplayHelper.querySnapinsForName(array, string, string2);
        if (string3 == null && (string3 = DisplayHelper.querySnapinsForName(array = Registry.getSnapins(new NamespaceScope(Shell.SNAPIN_DISPLAYICON, string), initSnapinInfo), string, string2)) == null && (string3 = DisplayHelper.querySnapinsForName(array = Registry.getSnapins(new GlobalScope(Shell.SNAPIN_DISPLAYICON), initSnapinInfo), string, string2)) == null) {
            D.assert(false, "No DisplayNameSnapin found that would handle namespace = " + string + " type = " + string2 + ", using default name.");
            string3 = string2;
        }
        return string3;
    }

    static Icon getDisplayIcon(String string, String string2) {
        String string3 = string + TOKEN_SEPARATOR + string2;
        Icon icon = (Icon)icons.get(string3);
        if (icon != null) {
            return icon;
        }
        Array array = null;
        InitSnapinInfo initSnapinInfo = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_DISPLAYICON);
        array = Registry.getSnapins(new NamespaceTypeScope(Shell.SNAPIN_DISPLAYICON, string, string2), initSnapinInfo);
        icon = DisplayHelper.querySnapinsForIcon(array, string, string2);
        if (icon == null && (icon = DisplayHelper.querySnapinsForIcon(array = Registry.getSnapins(new NamespaceScope(Shell.SNAPIN_DISPLAYICON, string), initSnapinInfo), string, string2)) == null && (icon = DisplayHelper.querySnapinsForIcon(array = Registry.getSnapins(new GlobalScope(Shell.SNAPIN_DISPLAYICON), initSnapinInfo), string, string2)) == null) {
            icon = defaultUnknownIcon;
        }
        return icon;
    }

    static Icon getDisplayIcon(ObjectEntry objectEntry) {
        InitSnapinInfo initSnapinInfo;
        Icon icon = null;
        ObjectType objectType = objectEntry.getObjectType();
        String string = objectType.getKey();
        icon = (Icon)icons.get(string);
        DisplayIconSnapin displayIconSnapin = (DisplayIconSnapin)iconSnapins.get(string);
        if (displayIconSnapin != null) {
            try {
                icon = displayIconSnapin.getDisplayIcon(objectEntry);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (icon != null) {
                return icon;
            }
        }
        if (objectEntry.getObjectType().getNamespace() instanceof ShellNamespace && objectEntry.getName().equals("@My World!")) {
            return ShellNamespace.getTopIcon();
        }
        if (objectEntry.getNamespace() instanceof PlaceholderNamespace) {
            return PlaceholderNamespace.ns.getDisplayIcon(objectEntry);
        }
        if (objectEntry.getObjectType().isNull()) {
            return specialNullObjectTypeIcon;
        }
        Array array = null;
        String string2 = objectType.getName();
        String string3 = objectType.getNamespace().getUniqueID();
        array = Registry.getSnapins(new NamespaceTypeScope(Shell.SNAPIN_DISPLAYICON, string3, string2), initSnapinInfo = new InitSnapinInfo(MainShell.getInstance(), (Object)Shell.SNAPIN_DISPLAYICON));
        icon = DisplayHelper.querySnapinsForIcon(array, objectEntry);
        if (icon == null && (icon = DisplayHelper.querySnapinsForIcon(array = Registry.getSnapins(new NamespaceScope(Shell.SNAPIN_DISPLAYICON, string3), initSnapinInfo), objectEntry)) == null && (icon = DisplayHelper.querySnapinsForIcon(array = Registry.getSnapins(new GlobalScope(Shell.SNAPIN_DISPLAYICON), initSnapinInfo), objectEntry)) == null) {
            if (objectEntry.getObjectType().isShortcut()) {
                ObjectEntry objectEntry2 = ShellStubs.dereferenceShortcut(objectEntry);
                if (objectEntry2 != null) {
                    Icon icon2 = DisplayHelper.getDisplayIcon(objectEntry2);
                    if (icon2 != null) {
                        return DisplayHelper.addShortcutToIcon(icon2);
                    }
                } else {
                    D.out("Error dereferencing shortcut to get display icon, dereference returned null for " + objectEntry + ", using unknown icon.");
                }
            }
            icon = defaultUnknownIcon;
        }
        return icon;
    }

    static Icon getUnknownIcon() {
        return defaultUnknownIcon;
    }

    private static Icon querySnapinsForIcon(Array array, String string, String string2) {
        Icon icon = null;
        int n = 0;
        while (n < array.size() && icon == null) {
            DisplayIconSnapin displayIconSnapin = (DisplayIconSnapin)array.at(n);
            try {
                icon = displayIconSnapin.getDisplayIcon(string, string2);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            ++n;
        }
        return icon;
    }

    private static Icon querySnapinsForIcon(Array array, ObjectEntry objectEntry) {
        ObjectType objectType = objectEntry.getObjectType();
        Icon icon = null;
        int n = 0;
        while (n < array.size() && icon == null) {
            DisplayIconSnapin displayIconSnapin = (DisplayIconSnapin)array.at(n);
            try {
                icon = displayIconSnapin.getDisplayIcon(objectEntry);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            if (icon != null) {
                iconSnapins.put(objectType.getKey(), displayIconSnapin);
                if (!displayIconSnapin.doesIconChangePerEntry(objectType)) {
                    icons.put(objectType.getNamespace().getUniqueID() + TOKEN_SEPARATOR + objectType.getName(), icon);
                }
            }
            ++n;
        }
        return icon;
    }

    private static String querySnapinsForName(Array array, String string, String string2) {
        String string3 = null;
        int n = 0;
        while (n < array.size() && string3 == null) {
            DisplayNameSnapin displayNameSnapin = (DisplayNameSnapin)array.at(n);
            try {
                string3 = displayNameSnapin.getDisplayName(string, string2);
            }
            catch (Exception exception) {
                D.reportSnapinError(exception);
            }
            ++n;
        }
        return string3;
    }

    private static Icon addShortcutToIcon(Icon icon) {
        return new OverlayedIcon(icon, shortcut);
    }

    private static String getNameHelper(DisplayNameSnapin displayNameSnapin, ObjectEntry objectEntry, int n) throws SnapinException {
        if (displayNameSnapin instanceof DisplayNameSnapinRev2) {
            DisplayNameSnapinRev2 displayNameSnapinRev2 = (DisplayNameSnapinRev2)displayNameSnapin;
            return displayNameSnapinRev2.getDisplayName(objectEntry, n);
        }
        return displayNameSnapin.getDisplayName(objectEntry);
    }

    DisplayHelper() {
    }

    static class OverlayedIcon
    implements Icon {
        Icon icon = null;
        Icon overlay = null;

        public int getIconHeight() {
            return Math.max(this.icon.getIconHeight(), this.overlay.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon.getIconWidth(), this.overlay.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
            this.overlay.paintIcon(component, graphics, n, n2);
        }

        public OverlayedIcon(Icon icon, Icon icon2) {
            this.icon = icon;
            this.overlay = icon2;
        }
    }
}

