/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.PropertyBook;
import com.novell.application.console.snapin.PropertyBookEvent;
import com.novell.application.console.snapin.PropertyBookListener;
import com.novell.application.console.snapin.context.PageSnapinContext;
import com.novell.utility.mpec.MPEC;
import java.util.Vector;

public final class MPECObserver
implements PropertyBookListener {
    private static MPECObserver singleton = new MPECObserver();
    private int mpecCntr = 0;
    private Vector theMPECs = null;
    private Vector theOEs = new Vector();

    public static final MPECObserver getInstance() {
        return singleton;
    }

    public int getMPECCntr() {
        return this.mpecCntr;
    }

    public void propertyBookInit(PropertyBookEvent propertyBookEvent) {
        ObjectEntryCollection objectEntryCollection = ((PageSnapinContext)((Object)propertyBookEvent.getSource())).getObjectCollection();
        PropertyBook propertyBook = ((PageSnapinContext)((Object)propertyBookEvent.getSource())).getPropertyBook();
        if (!objectEntryCollection.hasNoElements()) {
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry objectEntry = objectEntryEnumeration.next();
                if (objectEntry == null) continue;
                this.theOEs.addElement(objectEntry);
            }
        }
        if (propertyBook != null) {
            this.theMPECs.addElement(propertyBook);
        }
        ++this.mpecCntr;
    }

    public void propertyBookShutdown(PropertyBookEvent propertyBookEvent) {
        Object object;
        ObjectEntryCollection objectEntryCollection = ((PageSnapinContext)((Object)propertyBookEvent.getSource())).getObjectCollection();
        PropertyBook propertyBook = ((PageSnapinContext)((Object)propertyBookEvent.getSource())).getPropertyBook();
        if (!objectEntryCollection.hasNoElements()) {
            ObjectEntryEnumeration objectEntryEnumeration = objectEntryCollection.elements();
            while (objectEntryEnumeration.hasMoreElements()) {
                object = objectEntryEnumeration.next();
                if (object == null) continue;
                this.theOEs.removeElement(object);
            }
        }
        int n = this.theMPECs.indexOf(propertyBook);
        if (propertyBook != null) {
            this.theMPECs.removeElement(propertyBook);
        }
        --this.mpecCntr;
        if (this.mpecCntr != 0) {
            if (n > 0) {
                --n;
            }
            object = (PropertyBook)this.theMPECs.elementAt(n);
            object.getComponent().requestFocus();
        }
    }

    public void shutdownMPECs() {
        if (this.getMPECCntr() > 0) {
            Vector vector = (Vector)this.theMPECs.clone();
            int n = 0;
            while (n < vector.size()) {
                ((MPEC)vector.elementAt(n)).doCancel();
                ++n;
            }
        }
    }

    public boolean existsOE(ObjectEntry objectEntry) {
        return this.theOEs.contains(objectEntry);
    }

    private MPECObserver() {
        this.theMPECs = new Vector();
        MainShell.getInstance().addPropertyBookListener((PropertyBookListener)this);
    }
}

