/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.shell;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class StatusBarLayout
implements LayoutManager {
    private int gapBetweenItems = 2;
    private int statusBarHeight = 25;
    private boolean centerComponents = true;

    public void addLayoutComponent(String string, Component component) {
        D.assert(component != null);
        if (component == null) {
            throw new IllegalArgumentException("Cannot add component: component is null.");
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        D.assert(container instanceof StatusBar);
        return container.getSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        D.assert(container instanceof StatusBar);
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            Component component = container.getComponent(n2);
            Dimension dimension = component.getPreferredSize();
            n += dimension.width + this.gapBetweenItems;
            ++n2;
        }
        n2 = this.statusBarHeight + insets.top + insets.bottom;
        return new Dimension(n += insets.left + insets.right, n2);
    }

    public void layoutContainer(Container container) {
        Component component;
        D.assert(container instanceof StatusBar);
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = insets.left;
        Dimension dimension = container.getSize();
        int n3 = dimension.width - insets.left - insets.right;
        int n4 = 0;
        int n5 = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n5];
        int n6 = this.statusBarHeight;
        boolean bl = true;
        if (n3 < 0) {
            D.assert(false);
            n3 = 0;
        }
        int n7 = 0;
        while (n7 < n5) {
            component = container.getComponent(n7);
            dimensionArray[n7] = component.getPreferredSize();
            n4 += dimensionArray[n7].width + this.gapBetweenItems;
            ++n7;
        }
        if (n4 >= this.gapBetweenItems) {
            n4 -= this.gapBetweenItems;
        }
        if (n4 > n3) {
            n4 = 0;
            n7 = 0;
            while (n7 < n5) {
                component = container.getComponent(n7);
                dimensionArray[n7] = component.getMinimumSize();
                n4 += dimensionArray[n7].width + this.gapBetweenItems;
                ++n7;
            }
            if (n4 >= this.gapBetweenItems) {
                n4 -= this.gapBetweenItems;
            }
            if (n4 > n3) {
                bl = false;
            }
        }
        n7 = 0;
        while (n7 < n5) {
            component = container.getComponent(n7);
            Dimension dimension2 = dimensionArray[n7];
            int n8 = dimension2.height;
            int n9 = n;
            if (this.centerComponents && n8 < n6) {
                n9 = (n6 - n8) / 2 + 1 + n;
            }
            component.setLocation(n2, n9);
            if (n8 > n6) {
                n8 = n6;
            }
            if (n7 == n5 - 1 && bl) {
                component.setSize(n3 - n2, n8);
                n2 = n3 + this.gapBetweenItems;
            } else {
                component.setSize(dimension2.width, n8);
                n2 += dimension2.width + this.gapBetweenItems;
            }
            ++n7;
        }
    }

    StatusBarLayout() {
    }
}

