/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.shell.Constants;
import com.novell.application.console.snapin.InitSnapinInfo;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.StatusBarSnapin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public abstract class AbstractStatusBarSnapin
implements StatusBarSnapin {
    private static final int HEIGHT = 21;
    private static final int BORDER_PAD = 2;
    private static final String WIDTH_CHAR = "W";
    private static final Color TEXT_COLOR = Constants.AbstractStatusBarTextColorKey;
    protected Component component;
    protected Shell shell;
    private int width = 1;
    private JLabel label;

    public abstract String getSnapinName();

    public abstract String getSnapinDescription();

    public final boolean initSnapin(InitSnapinInfo initSnapinInfo) {
        this.shell = initSnapinInfo.getShell();
        return this.initAbstractSnapin(initSnapinInfo);
    }

    public boolean initAbstractSnapin(InitSnapinInfo initSnapinInfo) {
        return true;
    }

    public final void shutdownSnapin() {
        this.shutdownAbstractSnapin();
    }

    public void shutdownAbstractSnapin() {
    }

    public Component getStatusBarItem() {
        if (this.component == null) {
            String string = this.getStatusBarText();
            this.label = NConeFactory.novellJLabel(new JLabel(string), string, "");
            this.label.setForeground(TEXT_COLOR);
            this.label.setFont(Constants.getFont("DefaultSimpleStatusBarFontKey"));
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
            Graphics graphics = this.label.getGraphics();
            int n = ((Component)this.label).getFontMetrics(this.label.getFont()).stringWidth(WIDTH_CHAR);
            int n2 = n * this.width;
            int n3 = Math.max(n2, this.label.getPreferredSize().width);
            this.label.setPreferredSize(new Dimension(n3, 21));
            this.component = this.label;
        } else {
            this.refresh();
        }
        return this.component;
    }

    public abstract String getStatusBarText();

    public void refresh() {
        if (this.label != null) {
            this.label.setText(this.getStatusBarText());
        }
    }

    public void setStatusBarWidth(int n) {
        this.width = n;
    }
}

