/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapinresource;

import com.novell.application.console.shell.D;
import com.novell.application.console.shell.SnapinClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SnapinResourceURLConnection
extends URLConnection {
    private String name;
    private final String protocol;
    private final int protocolLength = "snapinresource".length();
    private String contentType = null;
    private SnapinClassLoader loader = null;

    public void connect() throws IOException {
        this.contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
        if (this.contentType == null) {
            if (this.url.getFile().endsWith("gif")) {
                this.contentType = "image/gif";
            } else if (this.url.getFile().endsWith("html")) {
                this.contentType = "text/html";
            } else if (this.url.getFile().endsWith("htm")) {
                this.contentType = "text/html";
            } else if (this.url.getFile().endsWith("properties")) {
                this.contentType = "text/properties";
            } else {
                throw new IOException("SnapinResource contains unknown content type");
            }
        }
        this.connected = true;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                D.out("IOException in SnapinResourceURLConnection::getContentType() trying to connect - " + iOException);
            }
        }
        return this.contentType;
    }

    public Object getContent() throws IOException {
        return super.getContent();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.loader.getResourceAsStream(this.url.getFile());
    }

    public SnapinResourceURLConnection(URL uRL, SnapinClassLoader snapinClassLoader) throws MalformedURLException, IOException {
        super(uRL);
        this.protocol = "snapinresource";
        this.loader = snapinClassLoader;
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!uRL.getProtocol().equals("snapinresource")) {
            throw new MalformedURLException("Incorrect protocol for snapin resource");
        }
        this.name = string;
    }
}

